/*
 * Decompiled with CFR 0.152.
 */
package com.obs.services.internal.io;

import com.obs.log.ILogger;
import com.obs.log.LoggerBuilder;
import com.obs.services.internal.io.InputStreamWrapper;
import com.obs.services.internal.io.UnrecoverableIOException;
import java.io.IOException;
import java.io.InputStream;

public class InterruptableInputStream
extends InputStream
implements InputStreamWrapper {
    private static final ILogger log = LoggerBuilder.getLogger(InterruptableInputStream.class);
    private InputStream inputStream = null;
    private boolean interrupted = false;

    public InterruptableInputStream(InputStream inputStream2) {
        this.inputStream = inputStream2;
    }

    private void doInterrupted() throws IOException {
        if (this.interrupted) {
            try {
                this.close();
            }
            catch (IOException ioe) {
                log.warn("io close failed.", ioe);
            }
            throw new UnrecoverableIOException("Reading from input stream deliberately interrupted");
        }
    }

    @Override
    public int read() throws IOException {
        this.doInterrupted();
        return this.inputStream.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.doInterrupted();
        return this.inputStream.read(b, off, len);
    }

    @Override
    public int available() throws IOException {
        this.doInterrupted();
        return this.inputStream.available();
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }

    @Override
    public InputStream getWrappedInputStream() {
        return this.inputStream;
    }

    public void interrupt() {
        this.interrupted = true;
    }
}

