/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.utils;

import com.google.common.base.Strings;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.dao.entity.TaskInstance;
import org.apache.dolphinscheduler.dao.entity.WorkflowInstance;
import org.apache.dolphinscheduler.server.master.engine.WorkflowEventBus;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowExecutionGraph;
import org.apache.dolphinscheduler.server.master.engine.graph.IWorkflowGraph;
import org.apache.dolphinscheduler.server.master.engine.task.runnable.ITaskExecutionRunnable;
import org.apache.dolphinscheduler.server.master.engine.workflow.runnable.IWorkflowExecutionRunnable;
import org.apache.dolphinscheduler.server.master.runner.IWorkflowExecuteContext;

public final class WorkflowInstanceUtils {
    public static String logWorkflowInstanceInDetails(IWorkflowExecutionRunnable workflowExecutionRunnable) {
        IWorkflowExecuteContext workflowExecuteContext = workflowExecutionRunnable.getWorkflowExecuteContext();
        IWorkflowExecutionGraph workflowExecutionGraph = workflowExecuteContext.getWorkflowExecutionGraph();
        IWorkflowGraph workflowGraph = workflowExecuteContext.getWorkflowGraph();
        WorkflowInstance workflowInstance = workflowExecuteContext.getWorkflowInstance();
        WorkflowEventBus workflowEventBus = workflowExecuteContext.getWorkflowEventBus();
        List startNodes = workflowExecutionGraph.getStartNodes().stream().map(ITaskExecutionRunnable::getName).collect(Collectors.toList());
        StringBuilder logBuilder = new StringBuilder();
        int horizontalLineLength = 80;
        int titleLength = 40;
        int leftSpaces = 20;
        String centeredTitle = String.format("%20s%s", "", "Workflow Instance Detail");
        logBuilder.append("\n").append(Strings.repeat((String)"*", (int)80)).append("\n").append(centeredTitle).append("\n").append(Strings.repeat((String)"*", (int)80)).append("\n").append("Workflow Instance Name:  ").append(workflowInstance.getName()).append("\n").append("Command Type:            ").append(workflowInstance.getCommandType()).append("\n").append("State:                   ").append(workflowInstance.getState().name()).append("\n").append("StartNodes:              ").append(startNodes).append("\n").append("TotalTasks:              ").append(workflowExecutionRunnable.getWorkflowExecuteContext().getWorkflowExecutionGraph().getAllTaskExecutionRunnable().size()).append("\n").append("Host:                    ").append(workflowInstance.getHost()).append("\n").append("Is SubWorkflow:          ").append(workflowInstance.getIsSubWorkflow().name()).append("\n").append("Run Times:               ").append(workflowInstance.getRunTimes()).append("\n").append("Tenant:                  ").append(workflowInstance.getTenantCode()).append("\n").append("Work Group:              ").append(workflowInstance.getWorkerGroup()).append("\n").append("EventBusSummary:         ").append(workflowEventBus.getWorkflowEventBusSummary()).append("\n").append("Schedule Time:           ").append(workflowInstance.getScheduleTime()).append("\n").append("Start Time:              ").append(workflowInstance.getStartTime()).append("\n").append("Restart Time:            ").append(workflowInstance.getRestartTime()).append("\n").append("End Time:                ").append(workflowInstance.getEndTime());
        return logBuilder.toString();
    }

    public static String logTaskInstanceInDetail(TaskInstance taskInstance) {
        StringBuilder logBuilder = new StringBuilder();
        int horizontalLineLength = 80;
        int titleLength = 40;
        int leftSpaces = 20;
        String centeredTitle = String.format("%20s%s", "", "Task Instance Detail");
        logBuilder.append("\n").append(Strings.repeat((String)"*", (int)80)).append("\n").append(centeredTitle).append("\n").append(Strings.repeat((String)"*", (int)80)).append("\n").append("Task Name:              ").append(taskInstance.getName()).append("\n").append("Workflow Instance Name: ").append(taskInstance.getWorkflowInstance().getName()).append("\n").append("Task Execute Type:      ").append(taskInstance.getTaskExecuteType().getDesc()).append("\n").append("Execute State:          ").append(taskInstance.getState().getDesc()).append("\n").append("Host:                   ").append(taskInstance.getHost()).append("\n").append("Task Type:              ").append(taskInstance.getTaskType()).append("\n").append("Priority:               ").append(taskInstance.getTaskInstancePriority().getDescp()).append("\n").append("Tenant:                 ").append(taskInstance.getWorkflowInstance().getTenantCode()).append("\n").append("First Submit Time:      ").append(taskInstance.getFirstSubmitTime()).append("\n").append("Submit Time:            ").append(taskInstance.getSubmitTime()).append("\n").append("Start Time:             ").append(taskInstance.getStartTime()).append("\n").append("End Time:               ").append(taskInstance.getEndTime()).append("\n");
        return logBuilder.toString();
    }

    @Generated
    private WorkflowInstanceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

