/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.spi.params.radio;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.LinkedList;
import java.util.List;
import org.apache.dolphinscheduler.spi.params.base.FormType;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.radio.RadioParamProps;

public class RadioParam
extends PluginParams {
    @JsonProperty(value="options")
    private List<ParamsOptions> options;
    private RadioParamProps props;

    private RadioParam(Builder builder) {
        super(builder);
        this.options = builder.options;
    }

    public static Builder newBuilder(String name, String title) {
        return new Builder(name, title);
    }

    public List<ParamsOptions> getOptions() {
        return this.options;
    }

    @Override
    public RadioParamProps getProps() {
        return this.props;
    }

    public static class Builder
    extends PluginParams.Builder {
        private List<ParamsOptions> options;
        private RadioParamProps props;

        public Builder(String name, String title) {
            super(name, FormType.RADIO, title);
        }

        public Builder setOptions(List<ParamsOptions> options) {
            this.options = options;
            return this;
        }

        public Builder addParamsOptions(ParamsOptions paramsOptions) {
            if (this.options == null) {
                this.options = new LinkedList<ParamsOptions>();
            }
            this.options.add(paramsOptions);
            return this;
        }

        public Builder setProps(RadioParamProps props) {
            this.props = props;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setTitle(String title) {
            this.title = title;
            return this;
        }

        public Builder setInfo(String info) {
            this.info = info;
            return this;
        }

        public Builder setValue(Object value) {
            this.value = value;
            return this;
        }

        public Builder setValidateList(List<Validate> validateList) {
            this.validateList = validateList;
            return this;
        }

        public Builder addValidate(Validate validate) {
            if (this.validateList == null) {
                this.validateList = new LinkedList();
            }
            this.validateList.add(validate);
            return this;
        }

        public Builder setHidden(Boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public Builder setDisplay(Boolean display) {
            this.display = display;
            return this;
        }

        @Override
        public RadioParam build() {
            return new RadioParam(this);
        }
    }
}

