/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.sql.models.AuthenticationType;
import com.azure.resourcemanager.sql.models.ExportRequest;
import com.azure.resourcemanager.sql.models.ImportOperationMode;
import com.azure.resourcemanager.sql.models.StorageKeyType;
import com.fasterxml.jackson.annotation.JsonProperty;

public final class ImportExtensionProperties
extends ExportRequest {
    @JsonProperty(value="operationMode", required=true)
    private ImportOperationMode operationMode;
    private static final ClientLogger LOGGER = new ClientLogger(ImportExtensionProperties.class);

    public ImportOperationMode operationMode() {
        return this.operationMode;
    }

    public ImportExtensionProperties withOperationMode(ImportOperationMode operationMode) {
        this.operationMode = operationMode;
        return this;
    }

    @Override
    public ImportExtensionProperties withStorageKeyType(StorageKeyType storageKeyType) {
        super.withStorageKeyType(storageKeyType);
        return this;
    }

    @Override
    public ImportExtensionProperties withStorageKey(String storageKey) {
        super.withStorageKey(storageKey);
        return this;
    }

    @Override
    public ImportExtensionProperties withStorageUri(String storageUri) {
        super.withStorageUri(storageUri);
        return this;
    }

    @Override
    public ImportExtensionProperties withAdministratorLogin(String administratorLogin) {
        super.withAdministratorLogin(administratorLogin);
        return this;
    }

    @Override
    public ImportExtensionProperties withAdministratorLoginPassword(String administratorLoginPassword) {
        super.withAdministratorLoginPassword(administratorLoginPassword);
        return this;
    }

    @Override
    public ImportExtensionProperties withAuthenticationType(AuthenticationType authenticationType) {
        super.withAuthenticationType(authenticationType);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.operationMode() == null) {
            throw LOGGER.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property operationMode in model ImportExtensionProperties"));
        }
    }
}

