/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.conf.HAUtil;
import org.apache.hadoop.yarn.conf.YarnConfiguration;

public abstract class YarnClientUtils {
    private static final String ADD_LABEL_FORMAT_ERR_MSG = "Input format for adding node-labels is not correct, it should be labelName1[(exclusive=true/false)],LabelName2[] ..";
    public static final String NO_LABEL_ERR_MSG = "No cluster node-labels are specified";

    public static String getRmPrincipal(Configuration conf) throws IOException {
        String principal = conf.get("yarn.resourcemanager.principal");
        String prepared = null;
        if (principal != null) {
            prepared = YarnClientUtils.getRmPrincipal(principal, conf);
        }
        return prepared;
    }

    public static String getRmPrincipal(String rmPrincipal, Configuration conf) throws IOException {
        if (rmPrincipal == null) {
            throw new IllegalArgumentException("RM principal string is null");
        }
        if (HAUtil.isHAEnabled((Configuration)conf)) {
            conf = YarnClientUtils.getYarnConfWithRmHaId(conf);
        }
        String hostname = conf.getSocketAddr("yarn.resourcemanager.address", "0.0.0.0:8032", 8032).getHostName();
        return SecurityUtil.getServerPrincipal((String)rmPrincipal, (String)hostname);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<NodeLabel> buildNodeLabelsFromStr(String args) {
        ArrayList<NodeLabel> nodeLabels = new ArrayList<NodeLabel>();
        for (String p : args.split(",")) {
            if (p.trim().isEmpty()) continue;
            String labelName = p;
            boolean exclusive = true;
            int leftParenthesisIdx = p.indexOf("(");
            int rightParenthesisIdx = p.indexOf(")");
            if (leftParenthesisIdx == -1 && rightParenthesisIdx != -1 || leftParenthesisIdx != -1 && rightParenthesisIdx == -1) {
                throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
            }
            if (leftParenthesisIdx > 0 && rightParenthesisIdx > 0) {
                if (leftParenthesisIdx > rightParenthesisIdx) {
                    throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
                }
                String property = p.substring(p.indexOf("(") + 1, p.indexOf(")"));
                if (property.contains("=")) {
                    String key = property.substring(0, property.indexOf("=")).trim();
                    String value = property.substring(property.indexOf("=") + 1, property.length()).trim();
                    if (!key.equals("exclusive") || !ImmutableSet.of((Object)"true", (Object)"false").contains((Object)value)) throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
                    exclusive = Boolean.parseBoolean(value);
                } else if (!property.trim().isEmpty()) {
                    throw new IllegalArgumentException(ADD_LABEL_FORMAT_ERR_MSG);
                }
            }
            if (labelName.contains("(")) {
                labelName = labelName.substring(0, labelName.indexOf("(")).trim();
            }
            nodeLabels.add(NodeLabel.newInstance((String)labelName, (boolean)exclusive));
        }
        if (!nodeLabels.isEmpty()) return nodeLabels;
        throw new IllegalArgumentException(NO_LABEL_ERR_MSG);
    }

    @VisibleForTesting
    static YarnConfiguration getYarnConfWithRmHaId(Configuration conf) throws IOException {
        YarnConfiguration yarnConf = new YarnConfiguration(conf);
        if (yarnConf.get("yarn.resourcemanager.ha.id") == null) {
            String[] rmIds = yarnConf.getStrings("yarn.resourcemanager.ha.rm-ids");
            if (rmIds != null && rmIds.length > 0) {
                yarnConf.set("yarn.resourcemanager.ha.id", rmIds[0]);
            } else {
                throw new IOException("RM_HA_IDS property is not set for HA resource manager");
            }
        }
        return yarnConf;
    }
}

