/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.sql.fluent.models;

import com.azure.resourcemanager.sql.fluent.models.RecommendedElasticPoolMetricInner;
import com.azure.resourcemanager.sql.models.ElasticPoolEdition;
import com.azure.resourcemanager.sql.models.TrackedResource;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class RecommendedElasticPoolProperties {
    @JsonProperty(value="databaseEdition", access=JsonProperty.Access.WRITE_ONLY)
    private ElasticPoolEdition databaseEdition;
    @JsonProperty(value="dtu")
    private Double dtu;
    @JsonProperty(value="databaseDtuMin")
    private Double databaseDtuMin;
    @JsonProperty(value="databaseDtuMax")
    private Double databaseDtuMax;
    @JsonProperty(value="storageMB")
    private Double storageMB;
    @JsonProperty(value="observationPeriodStart", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime observationPeriodStart;
    @JsonProperty(value="observationPeriodEnd", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime observationPeriodEnd;
    @JsonProperty(value="maxObservedDtu", access=JsonProperty.Access.WRITE_ONLY)
    private Double maxObservedDtu;
    @JsonProperty(value="maxObservedStorageMB", access=JsonProperty.Access.WRITE_ONLY)
    private Double maxObservedStorageMB;
    @JsonProperty(value="databases", access=JsonProperty.Access.WRITE_ONLY)
    private List<TrackedResource> databases;
    @JsonProperty(value="metrics", access=JsonProperty.Access.WRITE_ONLY)
    private List<RecommendedElasticPoolMetricInner> metrics;

    public ElasticPoolEdition databaseEdition() {
        return this.databaseEdition;
    }

    public Double dtu() {
        return this.dtu;
    }

    public RecommendedElasticPoolProperties withDtu(Double dtu) {
        this.dtu = dtu;
        return this;
    }

    public Double databaseDtuMin() {
        return this.databaseDtuMin;
    }

    public RecommendedElasticPoolProperties withDatabaseDtuMin(Double databaseDtuMin) {
        this.databaseDtuMin = databaseDtuMin;
        return this;
    }

    public Double databaseDtuMax() {
        return this.databaseDtuMax;
    }

    public RecommendedElasticPoolProperties withDatabaseDtuMax(Double databaseDtuMax) {
        this.databaseDtuMax = databaseDtuMax;
        return this;
    }

    public Double storageMB() {
        return this.storageMB;
    }

    public RecommendedElasticPoolProperties withStorageMB(Double storageMB) {
        this.storageMB = storageMB;
        return this;
    }

    public OffsetDateTime observationPeriodStart() {
        return this.observationPeriodStart;
    }

    public OffsetDateTime observationPeriodEnd() {
        return this.observationPeriodEnd;
    }

    public Double maxObservedDtu() {
        return this.maxObservedDtu;
    }

    public Double maxObservedStorageMB() {
        return this.maxObservedStorageMB;
    }

    public List<TrackedResource> databases() {
        return this.databases;
    }

    public List<RecommendedElasticPoolMetricInner> metrics() {
        return this.metrics;
    }

    public void validate() {
        if (this.databases() != null) {
            this.databases().forEach(e -> e.validate());
        }
        if (this.metrics() != null) {
            this.metrics().forEach(e -> e.validate());
        }
    }
}

