/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.dto.resources.filter;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.dolphinscheduler.api.dto.resources.filter.IFilter;
import org.apache.dolphinscheduler.plugin.storage.api.StorageEntity;

public class ResourceFilter
implements IFilter {
    private String suffix;
    private List<StorageEntity> resourceList;

    public ResourceFilter(String suffix, List<StorageEntity> resourceList) {
        this.suffix = suffix;
        this.resourceList = resourceList;
    }

    public Set<StorageEntity> fileFilter() {
        return this.resourceList.stream().filter(t -> t.getFullName().endsWith(this.suffix)).collect(Collectors.toSet());
    }

    Set<StorageEntity> listAllParent() {
        HashSet<StorageEntity> parentList = new HashSet<StorageEntity>();
        Set<StorageEntity> filterFileList = this.fileFilter();
        for (StorageEntity file : filterFileList) {
            String fullName = file.getFullName();
            for (StorageEntity resource : this.resourceList) {
                if (!fullName.startsWith(resource.getFullName())) continue;
                parentList.add(resource);
            }
        }
        return parentList;
    }

    @Override
    public List<StorageEntity> filter() {
        return new ArrayList<StorageEntity>(this.listAllParent());
    }
}

