/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.plugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertChannelFactory;
import org.apache.dolphinscheduler.common.enums.PluginType;
import org.apache.dolphinscheduler.common.enums.WarningType;
import org.apache.dolphinscheduler.dao.PluginDao;
import org.apache.dolphinscheduler.dao.entity.PluginDefine;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.apache.dolphinscheduler.spi.params.base.ParamsOptions;
import org.apache.dolphinscheduler.spi.params.base.PluginParams;
import org.apache.dolphinscheduler.spi.params.base.Validate;
import org.apache.dolphinscheduler.spi.params.radio.RadioParam;
import org.apache.dolphinscheduler.spi.plugin.PrioritySPIFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public final class AlertPluginManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertPluginManager.class);
    private final PluginDao pluginDao;
    private final Map<Integer, AlertChannel> alertPluginMap = new HashMap<Integer, AlertChannel>();

    public AlertPluginManager(PluginDao pluginDao) {
        this.pluginDao = pluginDao;
    }

    public void start() {
        log.info("AlertPluginManager start...");
        this.checkAlertPluginExist();
        this.installAlertPlugin();
        log.info("AlertPluginManager started...");
    }

    public Optional<AlertChannel> getAlertChannel(int id) {
        return Optional.ofNullable(this.alertPluginMap.get(id));
    }

    public int size() {
        return this.alertPluginMap.size();
    }

    private void checkAlertPluginExist() {
        if (!this.pluginDao.checkPluginDefineTableExist()) {
            log.error("Plugin Define Table t_ds_plugin_define Not Exist. Please Create it First!");
            System.exit(1);
        }
    }

    private void installAlertPlugin() {
        PluginParams warningTypeParams = this.getWarningTypeParams();
        PrioritySPIFactory prioritySPIFactory = new PrioritySPIFactory(AlertChannelFactory.class);
        for (Map.Entry entry : prioritySPIFactory.getSPIMap().entrySet()) {
            String name = (String)entry.getKey();
            AlertChannelFactory factory = (AlertChannelFactory)entry.getValue();
            AlertChannel alertChannel = factory.create();
            ArrayList<PluginParams> params = new ArrayList<PluginParams>(factory.params());
            String paramsJson = PluginParamsTransfer.transferParamsToJson(params);
            params.add(0, warningTypeParams);
            PluginDefine pluginDefine = new PluginDefine(name, PluginType.ALERT.getDesc(), paramsJson);
            int id = this.pluginDao.addOrUpdatePluginDefine(pluginDefine);
            this.alertPluginMap.put(id, alertChannel);
            log.info("Success register alert plugin: {}", (Object)name);
        }
    }

    private PluginParams getWarningTypeParams() {
        return RadioParam.newBuilder((String)"WarningType", (String)"warningType").addParamsOptions(new ParamsOptions(WarningType.SUCCESS.getDescp(), (Object)WarningType.SUCCESS.getDescp(), false)).addParamsOptions(new ParamsOptions(WarningType.FAILURE.getDescp(), (Object)WarningType.FAILURE.getDescp(), false)).addParamsOptions(new ParamsOptions(WarningType.ALL.getDescp(), (Object)WarningType.ALL.getDescp(), false)).setValue((Object)WarningType.ALL.getDescp()).addValidate(Validate.newBuilder().setRequired(true).build()).build();
    }
}

