/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.alert.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.dolphinscheduler.alert.api.AlertChannel;
import org.apache.dolphinscheduler.alert.api.AlertData;
import org.apache.dolphinscheduler.alert.api.AlertInfo;
import org.apache.dolphinscheduler.alert.api.AlertResult;
import org.apache.dolphinscheduler.alert.plugin.AlertPluginManager;
import org.apache.dolphinscheduler.alert.service.EventSender;
import org.apache.dolphinscheduler.common.enums.AlertStatus;
import org.apache.dolphinscheduler.common.utils.JSONUtils;
import org.apache.dolphinscheduler.dao.entity.AlertPluginInstance;
import org.apache.dolphinscheduler.dao.entity.AlertSendStatus;
import org.apache.dolphinscheduler.extract.alert.request.AlertSendResponse;
import org.apache.dolphinscheduler.spi.params.PluginParamsTransfer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEventSender<T>
implements EventSender<T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractEventSender.class);
    protected final AlertPluginManager alertPluginManager;
    private final long sendEventTimeout;

    protected AbstractEventSender(AlertPluginManager alertPluginManager, long sendEventTimeout) {
        this.alertPluginManager = alertPluginManager;
        this.sendEventTimeout = sendEventTimeout;
    }

    @Override
    public void sendEvent(T event) {
        List<AlertPluginInstance> alertPluginInstanceList = this.getAlertPluginInstanceList(event);
        if (CollectionUtils.isEmpty(alertPluginInstanceList)) {
            this.onError(event, "No bind plugin instance found");
            return;
        }
        AlertData alertData = this.getAlertData(event);
        ArrayList<AlertSendStatus> alertSendStatuses = new ArrayList<AlertSendStatus>();
        for (AlertPluginInstance instance : alertPluginInstanceList) {
            AlertResult alertResult = this.doSendEvent(instance, alertData);
            AlertStatus alertStatus = alertResult.isSuccess() ? AlertStatus.EXECUTION_SUCCESS : AlertStatus.EXECUTION_FAILURE;
            AlertSendStatus alertSendStatus2 = AlertSendStatus.builder().alertId(this.getEventId(event).intValue()).alertPluginInstanceId(instance.getId().intValue()).sendStatus(alertStatus).log(JSONUtils.toJsonString((Object)alertResult)).createTime(new Date()).build();
            alertSendStatuses.add(alertSendStatus2);
        }
        long failureCount = alertSendStatuses.stream().filter(alertSendStatus -> alertSendStatus.getSendStatus() == AlertStatus.EXECUTION_FAILURE).count();
        long successCount = alertSendStatuses.stream().filter(alertSendStatus -> alertSendStatus.getSendStatus() == AlertStatus.EXECUTION_SUCCESS).count();
        if (successCount == 0L) {
            this.onError(event, JSONUtils.toJsonString(alertSendStatuses));
        } else if (failureCount > 0L) {
            this.onPartialSuccess(event, JSONUtils.toJsonString(alertSendStatuses));
        } else {
            this.onSuccess(event, JSONUtils.toJsonString(alertSendStatuses));
        }
    }

    public abstract List<AlertPluginInstance> getAlertPluginInstanceList(T var1);

    public abstract AlertData getAlertData(T var1);

    public abstract Integer getEventId(T var1);

    public abstract void onError(T var1, String var2);

    public abstract void onPartialSuccess(T var1, String var2);

    public abstract void onSuccess(T var1, String var2);

    @Override
    public AlertResult doSendEvent(AlertPluginInstance instance, AlertData alertData) {
        int pluginDefineId = instance.getPluginDefineId();
        Optional<AlertChannel> alertChannelOptional = this.alertPluginManager.getAlertChannel(pluginDefineId);
        if (!alertChannelOptional.isPresent()) {
            return AlertResult.fail((String)("Cannot find the alertPlugin: " + pluginDefineId));
        }
        AlertChannel alertChannel = alertChannelOptional.get();
        AlertInfo alertInfo = AlertInfo.builder().alertData(alertData).alertParams(JSONUtils.toMap((String)instance.getPluginInstanceParams())).alertPluginInstanceId(instance.getId().intValue()).build();
        try {
            AlertResult alertResult = this.sendEventTimeout <= 0L ? alertChannel.process(alertInfo) : CompletableFuture.supplyAsync(() -> alertChannel.process(alertInfo)).get(this.sendEventTimeout, TimeUnit.MILLISECONDS);
            Preconditions.checkNotNull((Object)alertResult, (Object)"AlertResult cannot be null");
            return alertResult;
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            return AlertResult.fail((String)ExceptionUtils.getMessage((Throwable)interruptedException));
        }
        catch (Exception e) {
            log.error("Send alert data {} failed", (Object)alertData, (Object)e);
            return AlertResult.fail((String)ExceptionUtils.getMessage((Throwable)e));
        }
    }

    @Override
    public AlertSendResponse syncTestSend(int pluginDefineId, String pluginInstanceParams) {
        Optional<AlertChannel> alertChannelOptional = this.alertPluginManager.getAlertChannel(pluginDefineId);
        if (!alertChannelOptional.isPresent()) {
            AlertSendResponse.AlertSendResponseResult alertSendResponseResult = AlertSendResponse.AlertSendResponseResult.fail((String)("Cannot find the alertPlugin: " + pluginDefineId));
            return AlertSendResponse.fail((List)Lists.newArrayList((Object[])new AlertSendResponse.AlertSendResponseResult[]{alertSendResponseResult}));
        }
        AlertData alertData = AlertData.builder().title("DolphinScheduler test alert").content("[{\"message\":\" This is a test alert message form DolphinScheduler\"}]").build();
        AlertInfo alertInfo = AlertInfo.builder().alertData(alertData).alertParams(PluginParamsTransfer.getPluginParamsMap((String)pluginInstanceParams)).build();
        try {
            AlertResult alertResult = alertChannelOptional.get().process(alertInfo);
            Preconditions.checkNotNull((Object)alertResult, (Object)"AlertResult cannot be null");
            if (alertResult.isSuccess()) {
                return AlertSendResponse.success((List)Lists.newArrayList((Object[])new AlertSendResponse.AlertSendResponseResult[]{AlertSendResponse.AlertSendResponseResult.success()}));
            }
            return AlertSendResponse.fail((List)Lists.newArrayList((Object[])new AlertSendResponse.AlertSendResponseResult[]{AlertSendResponse.AlertSendResponseResult.fail((String)alertResult.getMessage())}));
        }
        catch (Exception e) {
            log.error("Test send alert error", (Throwable)e);
            return new AlertSendResponse(false, (List)Lists.newArrayList((Object[])new AlertSendResponse.AlertSendResponseResult[]{AlertSendResponse.AlertSendResponseResult.fail((String)ExceptionUtils.getMessage((Throwable)e))}));
        }
    }
}

