/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.api.core.ApiFuture;
import com.google.cloud.ReadChannel;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.ByteRangeSpec;
import com.google.cloud.storage.StorageException;
import com.google.common.base.Preconditions;
import java.io.IOException;

interface StorageReadChannel
extends ReadChannel {
    public StorageReadChannel setByteRangeSpec(ByteRangeSpec var1);

    public ApiFuture<BlobInfo> getObject();

    default public ByteRangeSpec getByteRangeSpec() {
        return ByteRangeSpec.nullRange();
    }

    @Deprecated
    default public void seek(long position) throws IOException {
        Preconditions.checkArgument((position >= 0L ? 1 : 0) != 0, (Object)"position must be >= 0");
        try {
            this.setByteRangeSpec(this.getByteRangeSpec().withNewBeginOffset(position));
        }
        catch (StorageException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    @Deprecated
    default public ReadChannel limit(long limit) {
        Preconditions.checkArgument((limit >= 0L ? 1 : 0) != 0, (Object)"limit must be >= 0");
        this.setByteRangeSpec(this.getByteRangeSpec().withNewEndOffset(limit));
        return this;
    }

    @Deprecated
    default public long limit() {
        return this.getByteRangeSpec().endOffset();
    }
}

