/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.appservice.models;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.resourcemanager.appservice.models.FunctionApp;
import reactor.core.publisher.Mono;

public final class FunctionAuthenticationPolicy
implements HttpPipelinePolicy {
    private final FunctionApp functionApp;
    private static final String HEADER_NAME = "x-functions-key";
    private String masterKey;

    public FunctionAuthenticationPolicy(FunctionApp functionApp) {
        this.functionApp = functionApp;
    }

    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        Mono masterKeyMono = this.masterKey == null ? this.functionApp.getMasterKeyAsync().map(key -> {
            this.masterKey = key;
            return key;
        }) : Mono.just((Object)this.masterKey);
        return masterKeyMono.flatMap(key -> {
            context.getHttpRequest().setHeader(HEADER_NAME, key);
            return next.process();
        });
    }
}

