/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util.timeline;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptReport;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationResourceUsageReport;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerReport;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.YarnApplicationAttemptState;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEntity;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineEvent;
import org.apache.hadoop.yarn.api.records.timelineservice.TimelineMetric;

public final class TimelineEntityV2Converter {
    private TimelineEntityV2Converter() {
    }

    public static ContainerReport convertToContainerReport(TimelineEntity entity) {
        NavigableSet events;
        int allocatedMem = 0;
        int allocatedVcore = 0;
        String allocatedHost = null;
        int allocatedPort = -1;
        int allocatedPriority = 0;
        long createdTime = 0L;
        long finishedTime = 0L;
        String diagnosticsInfo = null;
        int exitStatus = -1000;
        ContainerState state = null;
        String nodeHttpAddress = null;
        Map entityInfo = entity.getInfo();
        if (entityInfo != null) {
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_MEMORY")) {
                allocatedMem = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_MEMORY");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_VCORE")) {
                allocatedVcore = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_VCORE");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_HOST")) {
                allocatedHost = entityInfo.get("YARN_CONTAINER_ALLOCATED_HOST").toString();
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_PORT")) {
                allocatedPort = (Integer)entityInfo.get("YARN_CONTAINER_ALLOCATED_PORT");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_PRIORITY")) {
                allocatedPriority = Integer.parseInt(entityInfo.get("YARN_CONTAINER_ALLOCATED_PRIORITY").toString());
            }
            if (entityInfo.containsKey("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS")) {
                nodeHttpAddress = (String)entityInfo.get("YARN_CONTAINER_ALLOCATED_HOST_HTTP_ADDRESS");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_DIAGNOSTICS_INFO")) {
                diagnosticsInfo = entityInfo.get("YARN_CONTAINER_DIAGNOSTICS_INFO").toString();
            }
            if (entityInfo.containsKey("YARN_CONTAINER_EXIT_STATUS")) {
                exitStatus = (Integer)entityInfo.get("YARN_CONTAINER_EXIT_STATUS");
            }
            if (entityInfo.containsKey("YARN_CONTAINER_STATE")) {
                state = ContainerState.valueOf((String)entityInfo.get("YARN_CONTAINER_STATE").toString());
            }
        }
        if ((events = entity.getEvents()) != null) {
            for (TimelineEvent event : events) {
                if (event.getId().equals("YARN_RM_CONTAINER_CREATED")) {
                    createdTime = event.getTimestamp();
                    continue;
                }
                if (!event.getId().equals("YARN_RM_CONTAINER_FINISHED")) continue;
                finishedTime = event.getTimestamp();
            }
        }
        String logUrl = null;
        NodeId allocatedNode = null;
        if (allocatedHost != null) {
            allocatedNode = NodeId.newInstance(allocatedHost, (int)allocatedPort);
        }
        return ContainerReport.newInstance((ContainerId)ContainerId.fromString((String)entity.getId()), (Resource)Resource.newInstance((int)allocatedMem, (int)allocatedVcore), (NodeId)allocatedNode, (Priority)Priority.newInstance((int)allocatedPriority), (long)createdTime, (long)finishedTime, diagnosticsInfo, logUrl, (int)exitStatus, state, nodeHttpAddress);
    }

    public static ApplicationAttemptReport convertToApplicationAttemptReport(TimelineEntity entity) {
        NavigableSet events;
        String host = null;
        int rpcPort = -1;
        ContainerId amContainerId = null;
        String trackingUrl = null;
        String originalTrackingUrl = null;
        String diagnosticsInfo = null;
        YarnApplicationAttemptState state = null;
        Map entityInfo = entity.getInfo();
        long startTime = 0L;
        long finishTime = 0L;
        if (entityInfo != null) {
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_HOST")) {
                host = entityInfo.get("YARN_APPLICATION_ATTEMPT_HOST").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_RPC_PORT")) {
                rpcPort = (Integer)entityInfo.get("YARN_APPLICATION_ATTEMPT_RPC_PORT");
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER")) {
                amContainerId = ContainerId.fromString((String)entityInfo.get("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_TRACKING_URL")) {
                trackingUrl = entityInfo.get("YARN_APPLICATION_ATTEMPT_TRACKING_URL").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL")) {
                originalTrackingUrl = entityInfo.get("YARN_APPLICATION_ATTEMPT_ORIGINAL_TRACKING_URL").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO")) {
                diagnosticsInfo = entityInfo.get("YARN_APPLICATION_ATTEMPT_DIAGNOSTICS_INFO").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_STATE")) {
                state = YarnApplicationAttemptState.valueOf((String)entityInfo.get("YARN_APPLICATION_ATTEMPT_STATE").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER")) {
                amContainerId = ContainerId.fromString((String)entityInfo.get("YARN_APPLICATION_ATTEMPT_MASTER_CONTAINER").toString());
            }
        }
        if ((events = entity.getEvents()) != null) {
            for (TimelineEvent event : events) {
                if (event.getId().equals("YARN_APPLICATION_ATTEMPT_REGISTERED")) {
                    startTime = event.getTimestamp();
                    continue;
                }
                if (!event.getId().equals("YARN_APPLICATION_ATTEMPT_FINISHED")) continue;
                finishTime = event.getTimestamp();
            }
        }
        return ApplicationAttemptReport.newInstance((ApplicationAttemptId)ApplicationAttemptId.fromString((String)entity.getId()), (String)host, (int)rpcPort, trackingUrl, originalTrackingUrl, diagnosticsInfo, state, (ContainerId)amContainerId, (long)startTime, (long)finishTime);
    }

    public static ApplicationReport convertToApplicationReport(TimelineEntity entity) {
        Set metrics;
        Map configs;
        String user = null;
        String queue = null;
        String name = null;
        String type = null;
        boolean unmanagedApplication = false;
        long createdTime = 0L;
        long finishedTime = 0L;
        float progress = 0.0f;
        int applicationPriority = 0;
        ApplicationAttemptId latestApplicationAttemptId = null;
        String diagnosticsInfo = null;
        FinalApplicationStatus finalStatus = FinalApplicationStatus.UNDEFINED;
        YarnApplicationState state = YarnApplicationState.ACCEPTED;
        ApplicationResourceUsageReport appResources = null;
        HashSet<String> appTags = null;
        String appNodeLabelExpression = null;
        String amNodeLabelExpression = null;
        Map entityInfo = entity.getInfo();
        if (entityInfo != null) {
            if (entityInfo.containsKey("YARN_APPLICATION_USER")) {
                user = entityInfo.get("YARN_APPLICATION_USER").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_QUEUE")) {
                queue = entityInfo.get("YARN_APPLICATION_QUEUE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_NAME")) {
                name = entityInfo.get("YARN_APPLICATION_NAME").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TYPE")) {
                type = entityInfo.get("YARN_APPLICATION_TYPE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TYPE")) {
                type = entityInfo.get("YARN_APPLICATION_TYPE").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_UNMANAGED_APPLICATION")) {
                unmanagedApplication = Boolean.parseBoolean(entityInfo.get("YARN_APPLICATION_UNMANAGED_APPLICATION").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_PRIORITY")) {
                applicationPriority = Integer.parseInt(entityInfo.get("YARN_APPLICATION_PRIORITY").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_TAGS")) {
                appTags = new HashSet<String>();
                Object obj = entityInfo.get("YARN_APPLICATION_TAGS");
                if (obj != null && obj instanceof Collection) {
                    for (Object o : (Collection)obj) {
                        if (o == null) continue;
                        appTags.add(o.toString());
                    }
                }
            }
            if (entityInfo.containsKey("YARN_APPLICATION_LATEST_APP_ATTEMPT")) {
                latestApplicationAttemptId = ApplicationAttemptId.fromString((String)entityInfo.get("YARN_APPLICATION_LATEST_APP_ATTEMPT").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_DIAGNOSTICS_INFO")) {
                diagnosticsInfo = entityInfo.get("YARN_APPLICATION_DIAGNOSTICS_INFO").toString();
            }
            if (entityInfo.containsKey("YARN_APPLICATION_FINAL_STATUS")) {
                finalStatus = FinalApplicationStatus.valueOf((String)entityInfo.get("YARN_APPLICATION_FINAL_STATUS").toString());
            }
            if (entityInfo.containsKey("YARN_APPLICATION_STATE")) {
                state = YarnApplicationState.valueOf((String)entityInfo.get("YARN_APPLICATION_STATE").toString());
            }
        }
        if ((configs = entity.getConfigs()).containsKey("YARN_APP_NODE_LABEL_EXPRESSION")) {
            appNodeLabelExpression = (String)configs.get("YARN_APP_NODE_LABEL_EXPRESSION");
        }
        if (configs.containsKey("YARN_AM_NODE_LABEL_EXPRESSION")) {
            amNodeLabelExpression = (String)configs.get("YARN_AM_NODE_LABEL_EXPRESSION");
        }
        if ((metrics = entity.getMetrics()) != null) {
            long vcoreSeconds = 0L;
            long memorySeconds = 0L;
            long preemptedVcoreSeconds = 0L;
            long preemptedMemorySeconds = 0L;
            for (TimelineMetric metric : metrics) {
                switch (metric.getId()) {
                    case "YARN_APPLICATION_CPU": {
                        vcoreSeconds = TimelineEntityV2Converter.getAverageValue(metric.getValues().values());
                        break;
                    }
                    case "YARN_APPLICATION_MEMORY": {
                        memorySeconds = TimelineEntityV2Converter.getAverageValue(metric.getValues().values());
                        break;
                    }
                    case "YARN_APPLICATION_MEM_PREEMPT_METRIC": {
                        preemptedVcoreSeconds = TimelineEntityV2Converter.getAverageValue(metric.getValues().values());
                        break;
                    }
                    case "YARN_APPLICATION_CPU_PREEMPT_METRIC": {
                        preemptedVcoreSeconds = TimelineEntityV2Converter.getAverageValue(metric.getValues().values());
                        break;
                    }
                }
            }
            HashMap<String, Long> resourceSecondsMap = new HashMap<String, Long>();
            HashMap<String, Long> preemptedResoureSecondsMap = new HashMap<String, Long>();
            resourceSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), memorySeconds);
            resourceSecondsMap.put(ResourceInformation.VCORES.getName(), vcoreSeconds);
            preemptedResoureSecondsMap.put(ResourceInformation.MEMORY_MB.getName(), preemptedMemorySeconds);
            preemptedResoureSecondsMap.put(ResourceInformation.VCORES.getName(), preemptedVcoreSeconds);
            appResources = ApplicationResourceUsageReport.newInstance((int)0, (int)0, null, null, null, resourceSecondsMap, (float)0.0f, (float)0.0f, preemptedResoureSecondsMap);
        }
        NavigableSet events = entity.getEvents();
        long updatedTimeStamp = 0L;
        if (events != null) {
            for (TimelineEvent event : events) {
                if (event.getId().equals("YARN_APPLICATION_CREATED")) {
                    createdTime = event.getTimestamp();
                    continue;
                }
                if (event.getId().equals("YARN_APPLICATION_UPDATED")) {
                    if (event.getTimestamp() <= updatedTimeStamp) continue;
                    updatedTimeStamp = event.getTimestamp();
                    continue;
                }
                if (event.getId().equals("YARN_APPLICATION_STATE_UPDATED")) {
                    Map eventInfo = event.getInfo();
                    if (eventInfo == null || !eventInfo.containsKey("YARN_APPLICATION_STATE") || state != YarnApplicationState.ACCEPTED) continue;
                    state = YarnApplicationState.valueOf((String)eventInfo.get("YARN_APPLICATION_STATE").toString());
                    continue;
                }
                if (!event.getId().equals("YARN_APPLICATION_FINISHED")) continue;
                progress = 1.0f;
                state = YarnApplicationState.FINISHED;
                finishedTime = event.getTimestamp();
            }
        }
        return ApplicationReport.newInstance((ApplicationId)ApplicationId.fromString((String)entity.getId()), (ApplicationAttemptId)latestApplicationAttemptId, (String)user, (String)queue, (String)name, null, (int)-1, null, (YarnApplicationState)state, (String)diagnosticsInfo, null, (long)createdTime, (long)finishedTime, (FinalApplicationStatus)finalStatus, appResources, null, (float)progress, (String)type, null, appTags, (boolean)unmanagedApplication, (Priority)Priority.newInstance((int)applicationPriority), (String)appNodeLabelExpression, (String)amNodeLabelExpression);
    }

    private static long getAverageValue(Collection<Number> values) {
        if (values == null || values.isEmpty()) {
            return 0L;
        }
        long sum = 0L;
        for (Number value : values) {
            sum += value.longValue();
        }
        return sum / (long)values.size();
    }
}

