/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.AuthInfo;
import io.fabric8.kubernetes.api.model.AuthInfoFluent;
import io.fabric8.kubernetes.api.model.AuthInfoFluentImpl;
import java.util.Objects;

public class AuthInfoBuilder
extends AuthInfoFluentImpl<AuthInfoBuilder>
implements VisitableBuilder<AuthInfo, AuthInfoBuilder> {
    AuthInfoFluent<?> fluent;
    Boolean validationEnabled;

    public AuthInfoBuilder() {
        this(false);
    }

    public AuthInfoBuilder(Boolean validationEnabled) {
        this(new AuthInfo(), validationEnabled);
    }

    public AuthInfoBuilder(AuthInfoFluent<?> fluent) {
        this(fluent, (Boolean)false);
    }

    public AuthInfoBuilder(AuthInfoFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new AuthInfo(), validationEnabled);
    }

    public AuthInfoBuilder(AuthInfoFluent<?> fluent, AuthInfo instance) {
        this(fluent, instance, false);
    }

    public AuthInfoBuilder(AuthInfoFluent<?> fluent, AuthInfo instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withAs(instance.getAs());
        fluent.withAsGroups(instance.getAsGroups());
        fluent.withAsUserExtra(instance.getAsUserExtra());
        fluent.withAuthProvider(instance.getAuthProvider());
        fluent.withClientCertificate(instance.getClientCertificate());
        fluent.withClientCertificateData(instance.getClientCertificateData());
        fluent.withClientKey(instance.getClientKey());
        fluent.withClientKeyData(instance.getClientKeyData());
        fluent.withExec(instance.getExec());
        fluent.withExtensions(instance.getExtensions());
        fluent.withPassword(instance.getPassword());
        fluent.withToken(instance.getToken());
        fluent.withTokenFile(instance.getTokenFile());
        fluent.withUsername(instance.getUsername());
        fluent.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    public AuthInfoBuilder(AuthInfo instance) {
        this(instance, (Boolean)false);
    }

    public AuthInfoBuilder(AuthInfo instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withAs(instance.getAs());
        this.withAsGroups(instance.getAsGroups());
        this.withAsUserExtra(instance.getAsUserExtra());
        this.withAuthProvider(instance.getAuthProvider());
        this.withClientCertificate(instance.getClientCertificate());
        this.withClientCertificateData(instance.getClientCertificateData());
        this.withClientKey(instance.getClientKey());
        this.withClientKeyData(instance.getClientKeyData());
        this.withExec(instance.getExec());
        this.withExtensions(instance.getExtensions());
        this.withPassword(instance.getPassword());
        this.withToken(instance.getToken());
        this.withTokenFile(instance.getTokenFile());
        this.withUsername(instance.getUsername());
        this.withAdditionalProperties(instance.getAdditionalProperties());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public AuthInfo build() {
        AuthInfo buildable = new AuthInfo(this.fluent.getAs(), this.fluent.getAsGroups(), this.fluent.getAsUserExtra(), this.fluent.getAuthProvider(), this.fluent.getClientCertificate(), this.fluent.getClientCertificateData(), this.fluent.getClientKey(), this.fluent.getClientKeyData(), this.fluent.getExec(), this.fluent.getExtensions(), this.fluent.getPassword(), this.fluent.getToken(), this.fluent.getTokenFile(), this.fluent.getUsername());
        buildable.setAdditionalProperties(this.fluent.getAdditionalProperties());
        return buildable;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AuthInfoBuilder that = (AuthInfoBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.fluent, this.validationEnabled, super.hashCode());
    }
}

