/*
 * Decompiled with CFR 0.152.
 */
package com.qcloud.cos.demo.ci;

import com.qcloud.cos.COSClient;
import com.qcloud.cos.demo.ci.AuditingResultUtil;
import com.qcloud.cos.demo.ci.ClientUtils;
import com.qcloud.cos.model.ciModel.auditing.AuditingInfo;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingInputObject;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.BatchImageAuditingResponse;
import com.qcloud.cos.model.ciModel.auditing.BatchImageJobDetail;
import com.qcloud.cos.model.ciModel.auditing.DescribeImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingRequest;
import com.qcloud.cos.model.ciModel.auditing.ImageAuditingResponse;
import com.qcloud.cos.utils.Jackson;
import java.util.List;

public class ImageAuditingDemo {
    public static void main(String[] args) throws InterruptedException {
        COSClient client = ClientUtils.getTestClient();
        ImageAuditingDemo.imageAuditing(client);
    }

    public static void imageAuditing(COSClient client) {
        ImageAuditingRequest request = new ImageAuditingRequest();
        request.setBucketName("demobucket-1234567890");
        request.setObjectKey("1.png");
        request.setLargeImageDetect("1");
        request.setBizType("a34415d405a001ef15f4855f46e*****");
        ImageAuditingResponse response = client.imageAuditing(request);
        System.out.println(Jackson.toJsonString(response));
        List<AuditingInfo> imageInfoList = AuditingResultUtil.getImageInfoList(response);
        System.out.println(response);
    }

    public static void batchImageAuditing(COSClient client) {
        BatchImageAuditingRequest request = new BatchImageAuditingRequest();
        request.setBucketName("demo-123456789");
        List<BatchImageAuditingInputObject> inputList = request.getInputList();
        BatchImageAuditingInputObject input = new BatchImageAuditingInputObject();
        input.setObject("1.jpg");
        input.setDataId("DataId");
        inputList.add(input);
        input = new BatchImageAuditingInputObject();
        input.setUrl("https://demo-123456789.cos.ap-chongqing.myqcloud.com/1.png");
        input.setDataId("DataId");
        inputList.add(input);
        request.getConf().setDetectType("all");
        BatchImageAuditingResponse response = client.batchImageAuditing(request);
        List<BatchImageJobDetail> jobList = response.getJobList();
        for (BatchImageJobDetail batchImageJobDetail : jobList) {
            List<AuditingInfo> imageInfoList = AuditingResultUtil.getBatchImageInfoList(batchImageJobDetail);
            System.out.println(imageInfoList);
        }
    }

    public static void describeAuditingImageJob(COSClient client) {
        DescribeImageAuditingRequest request = new DescribeImageAuditingRequest();
        request.setBucketName("demobucket-1234567890");
        request.setJobId("si45a4f827badf11ecb72c525400bc****");
        ImageAuditingResponse response = client.describeAuditingImageJob(request);
        System.out.println(Jackson.toJsonString(response));
    }
}

