/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.trafficmanager.implementation;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.ExternalChildResourcesCachedImpl;
import com.azure.resourcemanager.trafficmanager.fluent.EndpointsClient;
import com.azure.resourcemanager.trafficmanager.fluent.models.EndpointInner;
import com.azure.resourcemanager.trafficmanager.fluent.models.ProfileInner;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerAzureEndpointImpl;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerEndpointImpl;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerExternalEndpointImpl;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerNestedProfileEndpointImpl;
import com.azure.resourcemanager.trafficmanager.implementation.TrafficManagerProfileImpl;
import com.azure.resourcemanager.trafficmanager.models.EndpointType;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerAzureEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerExternalEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerNestedProfileEndpoint;
import com.azure.resourcemanager.trafficmanager.models.TrafficManagerProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import reactor.core.publisher.Flux;

class TrafficManagerEndpointsImpl
extends ExternalChildResourcesCachedImpl<TrafficManagerEndpointImpl, TrafficManagerEndpoint, EndpointInner, TrafficManagerProfileImpl, TrafficManagerProfile> {
    private final ClientLogger logger = new ClientLogger(((Object)((Object)this)).getClass());
    private final EndpointsClient client;

    TrafficManagerEndpointsImpl(EndpointsClient client, TrafficManagerProfileImpl parent) {
        super((Object)parent, parent.taskGroup(), "Endpoint");
        this.client = client;
        this.cacheCollection();
    }

    List<EndpointInner> allEndpointsInners() {
        ArrayList<EndpointInner> allEndpoints = new ArrayList<EndpointInner>();
        for (TrafficManagerEndpointImpl epImpl : this.collection().values()) {
            allEndpoints.add((EndpointInner)((Object)epImpl.innerModel()));
        }
        return allEndpoints;
    }

    Map<String, TrafficManagerAzureEndpoint> azureEndpointsAsMap() {
        HashMap<String, TrafficManagerAzureEndpointImpl> result = new HashMap<String, TrafficManagerAzureEndpointImpl>();
        for (Map.Entry entry : this.collection().entrySet()) {
            TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)entry.getValue();
            if (endpoint.endpointType() != EndpointType.AZURE) continue;
            TrafficManagerAzureEndpointImpl azureEndpoint = new TrafficManagerAzureEndpointImpl((String)entry.getKey(), (TrafficManagerProfileImpl)this.getParent(), (EndpointInner)((Object)endpoint.innerModel()), this.client);
            result.put((String)entry.getKey(), azureEndpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    Map<String, TrafficManagerExternalEndpoint> externalEndpointsAsMap() {
        HashMap<String, TrafficManagerExternalEndpointImpl> result = new HashMap<String, TrafficManagerExternalEndpointImpl>();
        for (Map.Entry entry : this.collection().entrySet()) {
            TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)entry.getValue();
            if (endpoint.endpointType() != EndpointType.EXTERNAL) continue;
            TrafficManagerExternalEndpointImpl externalEndpoint = new TrafficManagerExternalEndpointImpl((String)entry.getKey(), (TrafficManagerProfileImpl)this.getParent(), (EndpointInner)((Object)endpoint.innerModel()), this.client);
            result.put((String)entry.getKey(), externalEndpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    Map<String, TrafficManagerNestedProfileEndpoint> nestedProfileEndpointsAsMap() {
        HashMap<String, TrafficManagerNestedProfileEndpointImpl> result = new HashMap<String, TrafficManagerNestedProfileEndpointImpl>();
        for (Map.Entry entry : this.collection().entrySet()) {
            TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)entry.getValue();
            if (endpoint.endpointType() != EndpointType.NESTED_PROFILE) continue;
            TrafficManagerNestedProfileEndpointImpl nestedProfileEndpoint = new TrafficManagerNestedProfileEndpointImpl((String)entry.getKey(), (TrafficManagerProfileImpl)this.getParent(), (EndpointInner)((Object)endpoint.innerModel()), this.client);
            result.put((String)entry.getKey(), nestedProfileEndpoint);
        }
        return Collections.unmodifiableMap(result);
    }

    public TrafficManagerEndpointImpl defineAzureTargetEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineDefine(name);
        endpoint.withEndpointType(EndpointType.AZURE);
        return endpoint;
    }

    public TrafficManagerEndpointImpl defineExteralTargetEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineDefine(name);
        endpoint.withEndpointType(EndpointType.EXTERNAL);
        return endpoint;
    }

    public TrafficManagerEndpointImpl defineNestedProfileTargetEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineDefine(name);
        endpoint.withEndpointType(EndpointType.NESTED_PROFILE);
        return endpoint;
    }

    public TrafficManagerEndpointImpl updateAzureEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineUpdate(name);
        if (endpoint.endpointType() != EndpointType.AZURE) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("An azure endpoint with name " + name + " not found in the profile"));
        }
        return endpoint;
    }

    public TrafficManagerEndpointImpl updateExternalEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineUpdate(name);
        if (endpoint.endpointType() != EndpointType.EXTERNAL) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("An external endpoint with name " + name + " not found in the profile"));
        }
        return endpoint;
    }

    public TrafficManagerEndpointImpl updateNestedProfileEndpoint(String name) {
        TrafficManagerEndpointImpl endpoint = (TrafficManagerEndpointImpl)this.prepareInlineUpdate(name);
        if (endpoint.endpointType() != EndpointType.NESTED_PROFILE) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("A nested profile endpoint with name " + name + " not found in the profile"));
        }
        return endpoint;
    }

    public void remove(String name) {
        this.prepareInlineRemove(name);
    }

    public void addEndpoint(TrafficManagerEndpointImpl endpoint) {
        this.addChildResource(endpoint);
    }

    protected List<TrafficManagerEndpointImpl> listChildResources() {
        ArrayList<TrafficManagerEndpointImpl> childResources = new ArrayList<TrafficManagerEndpointImpl>();
        if (((ProfileInner)((Object)((TrafficManagerProfileImpl)this.getParent()).innerModel())).endpoints() != null) {
            for (EndpointInner inner : ((ProfileInner)((Object)((TrafficManagerProfileImpl)this.getParent()).innerModel())).endpoints()) {
                childResources.add(new TrafficManagerEndpointImpl(inner.name(), (TrafficManagerProfileImpl)this.getParent(), inner, this.client));
            }
        }
        return childResources;
    }

    protected Flux<TrafficManagerEndpointImpl> listChildResourcesAsync() {
        return Flux.fromIterable(this.listChildResources());
    }

    protected TrafficManagerEndpointImpl newChildResource(String name) {
        TrafficManagerEndpointImpl endpoint = new TrafficManagerEndpointImpl(name, (TrafficManagerProfileImpl)this.getParent(), new EndpointInner(), this.client);
        return endpoint.withRoutingWeight(1).withTrafficEnabled();
    }
}

