/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datasync.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum AgentStatus {
    ONLINE("ONLINE"),
    OFFLINE("OFFLINE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, AgentStatus> VALUE_MAP;
    private final String value;

    private AgentStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static AgentStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<AgentStatus> knownValues() {
        EnumSet<AgentStatus> knownValues = EnumSet.allOf(AgentStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(AgentStatus.class, AgentStatus::toString);
    }
}

