/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.network.models;

import com.azure.resourcemanager.network.models.ApplicationGateway;
import com.azure.resourcemanager.network.models.ApplicationGatewayAuthenticationCertificate;
import com.azure.resourcemanager.network.models.ApplicationGatewayBackendHttpSettings;
import com.azure.resourcemanager.network.models.ApplicationGatewayProbe;
import com.azure.resourcemanager.network.models.ApplicationGatewayProtocol;
import com.azure.resourcemanager.network.models.HasPort;
import com.azure.resourcemanager.network.models.HasProtocol;
import com.azure.resourcemanager.resources.fluentcore.arm.models.ChildResource;
import com.azure.resourcemanager.resources.fluentcore.model.Attachable;
import com.azure.resourcemanager.resources.fluentcore.model.HasInnerModel;
import com.azure.resourcemanager.resources.fluentcore.model.Settable;
import java.io.File;
import java.io.IOException;
import java.util.Map;

public interface ApplicationGatewayBackendHttpConfiguration
extends HasInnerModel<ApplicationGatewayBackendHttpSettings>,
ChildResource<ApplicationGateway>,
HasProtocol<ApplicationGatewayProtocol>,
HasPort {
    public Map<String, ApplicationGatewayAuthenticationCertificate> authenticationCertificates();

    public boolean cookieBasedAffinity();

    public int requestTimeout();

    public ApplicationGatewayProbe probe();

    public String hostHeader();

    public boolean isHostHeaderFromBackend();

    public boolean isProbeEnabled();

    public int connectionDrainingTimeoutInSeconds();

    public String affinityCookieName();

    public String path();

    public static interface UpdateDefinition<ReturnT>
    extends UpdateDefinitionStages.Blank<ReturnT>,
    UpdateDefinitionStages.WithAttach<ReturnT>,
    UpdateDefinitionStages.WithAttachAndAuthCert<ReturnT> {
    }

    public static interface UpdateDefinitionStages {

        public static interface WithConnectionDraining<ReturnT> {
            public WithAttach<ReturnT> withConnectionDrainingTimeoutInSeconds(int var1);
        }

        public static interface WithHostHeader<ReturnT> {
            public WithAttach<ReturnT> withHostHeader(String var1);

            public WithAttach<ReturnT> withHostHeaderFromBackend();
        }

        public static interface WithProbe<ReturnT> {
            public WithAttach<ReturnT> withProbe(String var1);
        }

        public static interface WithPath<ReturnT> {
            public WithAttach<ReturnT> withPath(String var1);
        }

        public static interface WithCookieName<ReturnT> {
            public WithAttach<ReturnT> withAffinityCookieName(String var1);
        }

        public static interface WithAffinity<ReturnT> {
            public WithAttach<ReturnT> withCookieBasedAffinity();

            public WithAttach<ReturnT> withoutCookieBasedAffinity();
        }

        public static interface WithProtocol<ReturnT> {
            public WithAttachAndAuthCert<ReturnT> withHttps();
        }

        public static interface WithRequestTimeout<ReturnT> {
            public WithAttach<ReturnT> withRequestTimeout(int var1);
        }

        public static interface WithPort<ReturnT>
        extends HasPort.UpdateDefinitionStages.WithPort<WithAttach<ReturnT>> {
        }

        public static interface WithAuthenticationCertificate<ReturnT> {
            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificate(String var1);

            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromBytes(byte[] var1);

            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromFile(File var1) throws IOException;

            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromBase64(String var1);
        }

        public static interface WithAttach<ReturnT>
        extends Attachable.InUpdate<ReturnT>,
        WithPort<ReturnT>,
        WithAffinity<ReturnT>,
        WithProtocol<ReturnT>,
        WithRequestTimeout<ReturnT>,
        WithHostHeader<ReturnT>,
        WithConnectionDraining<ReturnT>,
        WithCookieName<ReturnT>,
        WithPath<ReturnT>,
        WithAuthenticationCertificate<ReturnT> {
        }

        public static interface WithAttachAndAuthCert<ReturnT>
        extends WithAttach<ReturnT>,
        WithAuthenticationCertificate<ReturnT> {
        }

        public static interface Blank<ReturnT>
        extends WithAttach<ReturnT> {
        }
    }

    public static interface Update
    extends Settable<ApplicationGateway.Update>,
    UpdateStages.WithPort,
    UpdateStages.WithAffinity,
    UpdateStages.WithProtocol,
    UpdateStages.WithRequestTimeout,
    UpdateStages.WithProbe,
    UpdateStages.WithHostHeader,
    UpdateStages.WithConnectionDraining,
    UpdateStages.WithCookieName,
    UpdateStages.WithPath,
    UpdateStages.WithAuthenticationCertificate {
    }

    public static interface UpdateStages {

        public static interface WithAuthenticationCertificate {
            public Update withAuthenticationCertificate(String var1);

            public Update withAuthenticationCertificateFromBytes(byte[] var1);

            public Update withAuthenticationCertificateFromFile(File var1) throws IOException;

            public Update withAuthenticationCertificateFromBase64(String var1);

            public Update withoutAuthenticationCertificate(String var1);

            public Update withoutAuthenticationCertificates();
        }

        public static interface WithPath {
            public Update withPath(String var1);
        }

        public static interface WithCookieName {
            public Update withAffinityCookieName(String var1);
        }

        public static interface WithConnectionDraining {
            public Update withConnectionDrainingTimeoutInSeconds(int var1);

            public Update withoutConnectionDraining();
        }

        public static interface WithHostHeader {
            public Update withHostHeaderFromBackend();

            public Update withoutHostHeader();

            public Update withHostHeader(String var1);
        }

        public static interface WithProbe {
            public Update withProbe(String var1);

            public Update withoutProbe();
        }

        public static interface WithRequestTimeout {
            public Update withRequestTimeout(int var1);
        }

        public static interface WithProtocol {
            public Update withHttps();

            public Update withHttp();
        }

        public static interface WithAffinity {
            public Update withCookieBasedAffinity();

            public Update withoutCookieBasedAffinity();
        }

        public static interface WithPort
        extends HasPort.UpdateStages.WithPort<Update> {
        }
    }

    public static interface Definition<ReturnT>
    extends DefinitionStages.Blank<ReturnT>,
    DefinitionStages.WithAttach<ReturnT>,
    DefinitionStages.WithAttachAndAuthCert<ReturnT> {
    }

    public static interface DefinitionStages {

        public static interface WithAttach<ReturnT>
        extends Attachable.InDefinition<ReturnT>,
        WithPort<ReturnT>,
        WithAffinity<ReturnT>,
        WithProtocol<ReturnT>,
        WithRequestTimeout<ReturnT>,
        WithProbe<ReturnT>,
        WithHostHeader<ReturnT>,
        WithConnectionDraining<ReturnT>,
        WithCookieName<ReturnT>,
        WithPath<ReturnT> {
        }

        public static interface WithAttachAndAuthCert<ReturnT>
        extends WithAttach<ReturnT>,
        WithAuthenticationCertificate<ReturnT> {
        }

        public static interface WithAuthenticationCertificate<ReturnT> {
            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificate(String var1);

            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromBytes(byte[] var1);

            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromFile(File var1) throws IOException;

            public WithAttachAndAuthCert<ReturnT> withAuthenticationCertificateFromBase64(String var1);
        }

        public static interface WithConnectionDraining<ReturnT> {
            public WithAttach<ReturnT> withConnectionDrainingTimeoutInSeconds(int var1);
        }

        public static interface WithHostHeader<ReturnT> {
            public WithAttach<ReturnT> withHostHeaderFromBackend();

            public WithAttach<ReturnT> withHostHeader(String var1);
        }

        public static interface WithProbe<ReturnT> {
            public WithAttach<ReturnT> withProbe(String var1);
        }

        public static interface WithRequestTimeout<ReturnT> {
            public WithAttach<ReturnT> withRequestTimeout(int var1);
        }

        public static interface WithPath<ReturnT> {
            public WithAttach<ReturnT> withPath(String var1);
        }

        public static interface WithCookieName<ReturnT> {
            public WithAttach<ReturnT> withAffinityCookieName(String var1);
        }

        public static interface WithAffinity<ReturnT> {
            public WithAttach<ReturnT> withCookieBasedAffinity();
        }

        public static interface WithProtocol<ReturnT> {
            public WithAttachAndAuthCert<ReturnT> withHttps();
        }

        public static interface WithPort<ReturnT>
        extends HasPort.DefinitionStages.WithPort<WithAttach<ReturnT>> {
        }

        public static interface Blank<ReturnT>
        extends WithAttach<ReturnT> {
        }
    }
}

