/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.utils;

import com.baomidou.mybatisplus.core.metadata.IPage;
import java.util.Collections;
import java.util.List;
import lombok.Generated;

public class PageInfo<T> {
    private List<T> totalList = Collections.emptyList();
    private Integer total = 0;
    private Integer totalPage;
    private Integer pageSize = 20;
    private Integer currentPage = 0;
    private Integer pageNo;

    public PageInfo() {
    }

    public PageInfo(Integer currentPage, Integer pageSize) {
        if (currentPage == null) {
            currentPage = 1;
        }
        this.pageNo = (currentPage - 1) * pageSize;
        this.pageSize = pageSize;
        this.currentPage = currentPage;
    }

    public static <T> PageInfo<T> of(IPage<T> iPage) {
        PageInfo<T> pageInfo = new PageInfo<T>((int)iPage.getCurrent(), (int)iPage.getSize());
        pageInfo.setTotalList(iPage.getRecords());
        pageInfo.setTotal((int)iPage.getTotal());
        return pageInfo;
    }

    public static <T> PageInfo<T> of(Integer currentPage, Integer pageSize) {
        return new PageInfo<T>(currentPage, pageSize);
    }

    public Integer getTotalPage() {
        if (this.pageSize == null || this.pageSize == 0) {
            this.pageSize = 10;
        }
        this.totalPage = this.total % this.pageSize == 0 ? (this.total / this.pageSize == 0 ? 1 : this.total / this.pageSize) : this.total / this.pageSize + 1;
        return this.totalPage;
    }

    @Generated
    public static <T> PageInfoBuilder<T> builder() {
        return new PageInfoBuilder();
    }

    @Generated
    public List<T> getTotalList() {
        return this.totalList;
    }

    @Generated
    public Integer getTotal() {
        return this.total;
    }

    @Generated
    public Integer getPageSize() {
        return this.pageSize;
    }

    @Generated
    public Integer getCurrentPage() {
        return this.currentPage;
    }

    @Generated
    public Integer getPageNo() {
        return this.pageNo;
    }

    @Generated
    public void setTotalList(List<T> totalList) {
        this.totalList = totalList;
    }

    @Generated
    public void setTotal(Integer total) {
        this.total = total;
    }

    @Generated
    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    @Generated
    public void setCurrentPage(Integer currentPage) {
        this.currentPage = currentPage;
    }

    @Generated
    public void setPageNo(Integer pageNo) {
        this.pageNo = pageNo;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageInfo)) {
            return false;
        }
        PageInfo other = (PageInfo)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$total = this.getTotal();
        Integer other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        Integer this$totalPage = this.getTotalPage();
        Integer other$totalPage = other.getTotalPage();
        if (this$totalPage == null ? other$totalPage != null : !((Object)this$totalPage).equals(other$totalPage)) {
            return false;
        }
        Integer this$pageSize = this.getPageSize();
        Integer other$pageSize = other.getPageSize();
        if (this$pageSize == null ? other$pageSize != null : !((Object)this$pageSize).equals(other$pageSize)) {
            return false;
        }
        Integer this$currentPage = this.getCurrentPage();
        Integer other$currentPage = other.getCurrentPage();
        if (this$currentPage == null ? other$currentPage != null : !((Object)this$currentPage).equals(other$currentPage)) {
            return false;
        }
        Integer this$pageNo = this.getPageNo();
        Integer other$pageNo = other.getPageNo();
        if (this$pageNo == null ? other$pageNo != null : !((Object)this$pageNo).equals(other$pageNo)) {
            return false;
        }
        List<T> this$totalList = this.getTotalList();
        List<T> other$totalList = other.getTotalList();
        return !(this$totalList == null ? other$totalList != null : !((Object)this$totalList).equals(other$totalList));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageInfo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        Integer $totalPage = this.getTotalPage();
        result = result * 59 + ($totalPage == null ? 43 : ((Object)$totalPage).hashCode());
        Integer $pageSize = this.getPageSize();
        result = result * 59 + ($pageSize == null ? 43 : ((Object)$pageSize).hashCode());
        Integer $currentPage = this.getCurrentPage();
        result = result * 59 + ($currentPage == null ? 43 : ((Object)$currentPage).hashCode());
        Integer $pageNo = this.getPageNo();
        result = result * 59 + ($pageNo == null ? 43 : ((Object)$pageNo).hashCode());
        List<T> $totalList = this.getTotalList();
        result = result * 59 + ($totalList == null ? 43 : ((Object)$totalList).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageInfo(totalList=" + this.getTotalList() + ", total=" + this.getTotal() + ", totalPage=" + this.getTotalPage() + ", pageSize=" + this.getPageSize() + ", currentPage=" + this.getCurrentPage() + ", pageNo=" + this.getPageNo() + ")";
    }

    @Generated
    public PageInfo(List<T> totalList, Integer total, Integer totalPage, Integer pageSize, Integer currentPage, Integer pageNo) {
        this.totalList = totalList;
        this.total = total;
        this.totalPage = totalPage;
        this.pageSize = pageSize;
        this.currentPage = currentPage;
        this.pageNo = pageNo;
    }

    @Generated
    public void setTotalPage(Integer totalPage) {
        this.totalPage = totalPage;
    }

    @Generated
    public static class PageInfoBuilder<T> {
        @Generated
        private List<T> totalList;
        @Generated
        private Integer total;
        @Generated
        private Integer totalPage;
        @Generated
        private Integer pageSize;
        @Generated
        private Integer currentPage;
        @Generated
        private Integer pageNo;

        @Generated
        PageInfoBuilder() {
        }

        @Generated
        public PageInfoBuilder<T> totalList(List<T> totalList) {
            this.totalList = totalList;
            return this;
        }

        @Generated
        public PageInfoBuilder<T> total(Integer total) {
            this.total = total;
            return this;
        }

        @Generated
        public PageInfoBuilder<T> totalPage(Integer totalPage) {
            this.totalPage = totalPage;
            return this;
        }

        @Generated
        public PageInfoBuilder<T> pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Generated
        public PageInfoBuilder<T> currentPage(Integer currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        @Generated
        public PageInfoBuilder<T> pageNo(Integer pageNo) {
            this.pageNo = pageNo;
            return this;
        }

        @Generated
        public PageInfo<T> build() {
            return new PageInfo<T>(this.totalList, this.total, this.totalPage, this.pageSize, this.currentPage, this.pageNo);
        }

        @Generated
        public String toString() {
            return "PageInfo.PageInfoBuilder(totalList=" + this.totalList + ", total=" + this.total + ", totalPage=" + this.totalPage + ", pageSize=" + this.pageSize + ", currentPage=" + this.currentPage + ", pageNo=" + this.pageNo + ")";
        }
    }
}

