// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

suite("rqg12257") {
    String db = context.config.getDbNameByFile(context.file)
    
	multi_sql """
	drop database if exists ${db};
	create database ${db};
	use ${db};

create table table_200_undef_partitions2_keys3_properties4_distributed_by52 (
col_int_undef_signed int  null  ,
col_date_undef_signed date  null  ,
col_int_undef_signed_not_null int  not null  ,
col_date_undef_signed_not_null date  not null  ,
col_varchar_5__undef_signed varchar(5)  null  ,
col_varchar_5__undef_signed_not_null varchar(5)  not null  ,
pk int
) engine=olap
DUPLICATE KEY(col_int_undef_signed, col_date_undef_signed)
PARTITION BY             RANGE(col_int_undef_signed) (
                PARTITION p0 VALUES LESS THAN ('4'),
                PARTITION p1 VALUES LESS THAN ('6'),
                PARTITION p2 VALUES LESS THAN ('7'),
                PARTITION p3 VALUES LESS THAN ('8'),
                PARTITION p4 VALUES LESS THAN ('10'),
                PARTITION p5 VALUES LESS THAN ('83647'),
                PARTITION p100 VALUES LESS THAN ('2147483647')
            )
        
distributed by hash(pk) buckets 10
properties("replication_num" = "1");
insert into table_200_undef_partitions2_keys3_properties4_distributed_by52(pk,col_int_undef_signed,col_int_undef_signed_not_null,col_date_undef_signed,col_date_undef_signed_not_null,col_varchar_5__undef_signed,col_varchar_5__undef_signed_not_null) values (0,26920,23303,'2023-12-12','2010-06-27','o','s'),(1,3,1,null,'2023-12-11','f','s'),(2,-27490,7,'2023-12-16','2023-12-13',null,'q'),(3,0,-3125347,'2023-12-18','2023-12-13','g','r'),(4,28062,2,'2023-12-11','2023-12-12','v','s'),(5,31608,32161,'2023-12-16','2023-12-13',null,'v'),(6,null,9,'2023-12-18','2023-12-15','l','e'),(7,null,0,'2023-12-13','2023-12-13','e','t'),(8,6,9,null,'2023-12-12','l','u'),(9,8,4,'2023-12-10','2023-12-15','e','c'),(10,6198,8,'2023-12-11','2023-12-17','b','c'),(11,8,-3399500,'2023-12-12','2023-12-17',null,'m'),(12,6287737,7,'2023-12-14','2023-12-16','t','r'),(13,9,5,'2014-04-24','2023-12-11','m','m'),(14,0,9,null,'2005-04-26','h','m'),(15,null,3,'2023-12-11','2023-12-16','m','g'),(16,5,25645,null,'2023-12-10','h','l'),(17,2,7,'2013-09-18','2023-12-12','t','f'),(18,6,2,'2023-12-14','2007-04-02','c','r'),(19,3,2,null,'2023-12-14','t','t'),(20,8,6,'2002-02-14','2010-11-28','d','a'),(21,null,8,'2009-09-01','2023-12-11','g','l'),(22,0,5,'2023-12-16','2023-12-11','l','h'),(23,3,1,'2023-12-17','2023-12-15','z','j'),(24,3,9,'2023-12-14','2003-11-06','i','o'),(25,null,-5338326,'2023-12-11','2023-12-12','a','n'),(26,2771091,6,'2023-12-09','2023-12-11','b','n'),(27,5,-16067,'2023-12-09','2011-01-17','g','l'),(28,null,1,'2023-12-14','2023-12-15','j','l'),(29,null,6,'2023-12-09','2023-12-16','w','w'),(30,8,6,'2023-12-14','2023-12-13','v','n'),(31,2,5150044,'2023-12-15','2023-12-14','z','n'),(32,null,6,'2000-06-17','2002-02-21','h','u'),(33,-2571939,-17295,'2023-12-18','2023-12-11','h','a'),(34,null,6,'2023-12-18','2023-12-10','z','c'),(35,1,4,'2023-12-12','2023-12-10','j','e'),(36,4,-3379564,'2023-12-16','2023-12-16','b','l'),(37,20188,3,'2023-12-15','2023-12-09','u','u'),(38,18098,9,'2023-12-09','2023-12-13','m','p'),(39,5,-5531,'2023-12-18','2001-07-05','p','g'),(40,7,3,'2023-12-17','2023-12-18','d','n'),(41,-10179,0,null,'2023-12-12','y','v'),(42,0,6,'2023-12-12','2006-03-24','y','g'),(43,5,1,'2023-12-12','2006-03-16','x','f'),(44,2,4,'2012-12-22','2005-12-19','z','o'),(45,2,3605005,'2023-12-18','2023-12-09','v','q'),(46,3,6,'2018-02-23','2023-12-12','c','n'),(47,8,8447,'2023-12-17','2023-12-16','y','a'),(48,1,8,'2023-12-14','2023-12-14','g','b'),(49,2,5,'2023-12-14','2023-12-18','z','p'),(50,1,2,'2001-06-06','2023-12-13','q','c'),(51,3,6,'2004-09-03','2023-12-09','a','c'),(52,-23696,8,'2023-12-16','2023-12-16','k','p'),(53,8,1,'2023-12-16','2023-12-15','w','s'),(54,9,6016548,'2023-12-10','2023-12-09','b','m'),(55,9,969,'2023-12-09','2023-12-13','w','f'),(56,-6789736,2,'2023-12-13','2023-12-14','w','l'),(57,3,-3836432,'2023-12-17','2015-06-26','p','x'),(58,-20802,9,'2023-12-11','2023-12-10',null,'o'),(59,null,27309,null,'2000-06-01','x','m'),(60,-7298024,5,'2023-12-12','2000-04-13','i','x'),(61,9,5,'2005-01-20','2003-12-17','t','t'),(62,null,-5061,'2023-12-13','2023-12-09','o','m'),(63,5,1648185,'2003-01-02','2023-12-15','u','j'),(64,6,4912631,'2009-09-21','2023-12-18','a','m'),(65,4515,-23725,'2023-12-10','2023-12-13','l','y'),(66,-5144914,-6857465,'2003-11-11','2023-12-16','d','h'),(67,null,5,'2023-12-09','2023-12-15','t','m'),(68,null,-30281,'2009-07-11','2023-12-15','y','n'),(69,0,3,'2023-12-16','2023-12-15','c','u'),(70,9,4,'2006-05-14','2023-12-09','v','q'),(71,0,8,'2023-12-11','2023-12-11','p','q'),(72,4,7233537,'2001-11-09','2023-12-14','n','e'),(73,9,0,'2023-12-17','2023-12-18','i','d'),(74,8,2630278,'2023-12-12','2023-12-14','x','r'),(75,-939622,5,null,'2023-12-13',null,'p'),(76,4,6,'2023-12-09','2023-12-11','w','s'),(77,7,6,'2023-12-12','2023-12-18','s','z'),(78,5,5,'2023-12-14','2023-12-09','w','z'),(79,7,4,'2023-12-10','2023-12-14','b','r'),(80,3,-564909,'2007-09-07','2015-04-02','u','q'),(81,1,2,'2003-01-04','2023-12-13',null,'u'),(82,8,8,null,'2023-12-11',null,'b'),(83,7,2164800,'2023-12-11','2023-12-13','x','a'),(84,1,5,null,'2023-12-14','a','h'),(85,8,1182335,'2023-12-14','2023-12-14','h','l'),(86,null,4687,'2023-12-15','2023-12-16','l','j'),(87,8,9,'2023-12-11','2008-11-28','p','k'),(88,4737,6,'2023-12-17','2023-12-18','l','o'),(89,null,-4053340,'2023-12-18','2006-06-27','k','w'),(90,-2554934,6,null,'2023-12-10','v','j'),(91,6,2,'2023-12-16','2023-12-11','r','v'),(92,1,2,'2014-02-18','2001-09-21',null,'z'),(93,1,20580,null,'2010-06-09','j','o'),(94,5,1,'2023-12-09','2023-12-09','t','c'),(95,9,0,'2023-12-18','2023-12-10',null,'o'),(96,6756950,2,'2023-12-11','2017-07-12','l','m'),(97,2,-3068,'2023-12-09','2023-12-12','t','r'),(98,6,6,'2023-12-18','2023-12-12','p','h'),(99,4,16130,'2023-12-12','2023-12-17','h','p'),(100,4,3,'2023-12-18','2023-12-16','r','z'),(101,5,4,'2023-12-17','2023-12-10','f','z'),(102,-5755589,6,'2023-12-11','2003-03-10','f','m'),(103,-2421540,5,'2023-12-14','2011-10-19','k','c'),(104,5,2,'2023-12-13','2023-12-09',null,'p'),(105,2124657,3,'2023-12-11','2023-12-14','b','n'),(106,4,4,null,'2012-07-26','y','o'),(107,8,4,'2023-12-11','2023-12-09','n','t'),(108,0,9,'2010-10-06','2023-12-09','n','x'),(109,8,9,'2023-12-13','2016-02-28','k','q'),(110,2,5214477,'2011-04-01','2023-12-12','s','b'),(111,9,5834341,'2023-12-16','2023-12-11','v','h'),(112,4,7,'2023-12-18','2023-12-10','p','s'),(113,8,4,'2023-12-16','2023-12-11','c','d'),(114,-19017,2,'2023-12-12','2023-12-11','e','s'),(115,0,2,'2023-12-14','2023-12-13','u','m'),(116,7,17865,null,'2003-09-19','g','v'),(117,2,1,'2023-12-12','2023-12-09',null,'s'),(118,1,5,'2023-12-13','2023-12-12','i','n'),(119,4,4,'2023-12-10','2005-03-22','s','z'),(120,null,5,'2023-12-13','2023-12-14','w','s'),(121,null,4,'2023-12-11','2023-12-16','x','z'),(122,5,0,'2023-12-12','2023-12-11','y','r'),(123,0,8,'2023-12-12','2023-12-12','p','a'),(124,407,6783005,'2023-12-10','2023-12-09','a','z'),(125,20364,1,'2023-12-09','2023-12-18','i','x'),(126,2,7,'2011-06-21','2023-12-14','r','j'),(127,4,9,'2023-12-16','2023-12-18','o','v'),(128,3574296,5,null,'2023-12-15','e','o'),(129,8,4,'2023-12-15','2023-12-11','n','d'),(130,5,7,'2023-12-16','2015-08-13','v','f'),(131,5960571,3,'2013-11-26','2023-12-14','y','k'),(132,7156680,1,'2005-10-21','2023-12-10',null,'m'),(133,8,11555,'2023-12-17','2023-12-09','o','u'),(134,9,9,null,'2023-12-18','l','j'),(135,5,18177,'2023-12-13','2023-12-12','g','d'),(136,null,2,'2023-12-12','2023-12-12','u','g'),(137,7,3,'2023-12-17','2014-02-25','f','n'),(138,-9745,17940,'2023-12-11','2023-12-13','x','e'),(139,1,4,null,'2023-12-17','c','b'),(140,8,7,'2023-12-14','2005-07-04','k','y'),(141,5,29237,'2023-12-10','2023-12-17','h','r'),(142,null,3,'2005-02-21','2023-12-09','q','j'),(143,4,7,'2023-12-11','2009-10-26','k','r'),(144,0,6,'2023-12-10','2023-12-18','n','v'),(145,null,5,null,'2023-12-09','d','v'),(146,5,1,null,'2023-12-12','z','f'),(147,1,3,'2012-06-28','2023-12-16',null,'g'),(148,-24333,5,'2023-12-11','2023-12-13','g','z'),(149,8,-2634935,'2023-12-10','2023-12-12','d','q'),(150,0,7,'2023-12-13','2023-12-15','l','r'),(151,4,1,null,'2023-12-17','t','h'),(152,-11765,2,null,'2023-12-15','h','u'),(153,null,-8468,'2023-12-17','2023-12-13','o','y'),(154,29409,8197428,'2000-10-19','2004-01-09','l','n'),(155,6,2472301,'2023-12-18','2023-12-18','x','h'),(156,-23182,2,'2023-12-10','2023-12-17','f','q'),(157,26588,2748,'2023-12-09','2023-12-16','q','w'),(158,5,4,'2023-12-09','2023-12-13','h','j'),(159,3,6,'2023-12-14','2023-12-11','t','e'),(160,5985348,7,'2023-12-18','2023-12-14',null,'j'),(161,5,1,'2023-12-16','2023-12-15','z','b'),(162,7,1,'2023-12-13','2023-12-10','c','m'),(163,8,5,'2023-12-16','2023-12-13','h','z'),(164,8,9,'2023-12-14','2023-12-11','c','d'),(165,9,-16478,null,'2012-07-06','a','o'),(166,7,6,'2023-12-18','2023-12-09',null,'e'),(167,7,-7980,null,'2023-12-17','o','c'),(168,null,9,'2023-12-14','2023-12-16','p','r'),(169,null,4464061,'2023-12-15','2003-07-09','i','p'),(170,-29701,3,null,'2010-10-04','l','h'),(171,4,9,'2023-12-15','2017-12-19',null,'r'),(172,1163,0,'2014-10-06','2023-12-18','x','l'),(173,4,2,'2023-12-09','2023-12-17','f','x'),(174,5,0,null,'2023-12-17','n','e'),(175,6,-1449511,'2023-12-12','2023-12-16',null,'z'),(176,-30093,6717227,'2023-12-16','2023-12-11','k','v'),(177,-14275,3,'2023-12-11','2015-08-14','j','a'),(178,7,5463934,'2023-12-11','2012-10-03','d','v'),(179,-7592351,0,'2019-05-16','2023-12-14','r','s'),(180,null,0,'2023-12-10','2000-01-28','a','l'),(181,9,3,null,'2023-12-09',null,'o'),(182,4,-1067514,'2023-12-16','2023-12-12','q','e'),(183,3,3,'2023-12-12','2023-12-10','y','r'),(184,null,4,'2023-12-13','2023-12-18',null,'t'),(185,4,-559,'2023-12-14','2023-12-09','p','v'),(186,2,-7740406,'2023-12-18','2023-12-10',null,'y'),(187,8,-11370,'2023-12-18','2023-12-13','e','u'),(188,0,5,'2023-12-16','2023-12-16','n','l'),(189,null,-5771295,'2023-12-13','2023-12-09','f','t'),(190,2,2,null,'2023-12-15',null,'x'),(191,2268060,4895823,'2023-12-18','2023-12-13','p','p'),(192,9,5,'2023-12-13','2023-12-11','e','i'),(193,null,0,null,'2017-08-03','x','f'),(194,6,1108635,'2023-12-17','2023-12-11','k','f'),(195,null,9,'2014-03-07','2015-11-25','k','w'),(196,10540,3,'2004-03-22','2023-12-14','w','f'),(197,-31441,6,'2023-12-09','2023-12-13','w','n'),(198,7,-7074292,'2023-12-09','2023-12-16','q','x'),(199,12475,142,'2023-12-16','2023-12-10','m','d');

create table table_200_undef_partitions2_keys3_properties4_distributed_by5 (
col_int_undef_signed int  null  ,
col_int_undef_signed_not_null int  not null  ,
col_date_undef_signed date  null  ,
col_date_undef_signed_not_null date  not null  ,
col_varchar_5__undef_signed varchar(5)  null  ,
col_varchar_5__undef_signed_not_null varchar(5)  not null  ,
pk int
) engine=olap
DUPLICATE KEY(col_int_undef_signed)
PARTITION BY             RANGE(col_int_undef_signed) (
                PARTITION p0 VALUES LESS THAN ('4'),
                PARTITION p1 VALUES LESS THAN ('6'),
                PARTITION p2 VALUES LESS THAN ('7'),
                PARTITION p3 VALUES LESS THAN ('8'),
                PARTITION p4 VALUES LESS THAN ('10'),
                PARTITION p5 VALUES LESS THAN ('83647'),
                PARTITION p100 VALUES LESS THAN ('2147483647')
            )
        
distributed by hash(pk) buckets 10
properties("replication_num" = "1");
insert into table_200_undef_partitions2_keys3_properties4_distributed_by5(pk,col_int_undef_signed,col_int_undef_signed_not_null,col_date_undef_signed,col_date_undef_signed_not_null,col_varchar_5__undef_signed,col_varchar_5__undef_signed_not_null)
    values (0,2,2,null,'2023-12-14','c','y'),
(1,9,1,'2015-06-20','2023-12-09','i','w'),
(2,9,8,'2023-12-13','2023-12-12','p','p'),
(3,null,1,'2023-12-18','2023-12-17','s','c'),
(4,2,6,'2023-12-11','2023-12-13','f','a'),
(5,1996613,-31050,'2023-12-09','2023-12-10',null,'j'),
(6,3,0,'2023-12-15','2023-12-17','l','f'),
(7,-24465,3,'2023-12-10','2023-12-09','a','n'),
(8,6,5,'2023-12-18','2023-12-16',null,'e'),
(9,5,1,'2023-12-12','2023-12-13','j','z'),
(10,-8015300,4,'2023-12-13','2023-12-18','b','d'),
(11,5,4,'2023-12-11','2023-12-13',null,'x'),
(12,-14653,1,'2019-10-05','2005-09-05','s','m'),
(13,7,0,'2023-12-12','2023-12-18','d','y'),
(14,-262707,9,'2005-04-11','2023-12-15','o','s'),
(15,5,7,'2023-12-16','2023-12-09',null,'n'),
(16,4,1,'2023-12-10','2023-12-18',null,'a'),
(17,6,0,null,'2004-09-23',null,'d'),
(18,null,2,'2005-06-14','2023-12-17','p','s'),
(19,6,5,'2023-12-11','2023-12-17','y','l'),
(20,30613,7,null,'2023-12-13','h','r'),
(21,0,2200815,'2023-12-17','2023-12-18',null,'h'),
(22,9,0,'2023-12-13','2023-12-18','w','q'),
(23,9,4,null,'2023-12-18',null,'i'),
(24,-4939,8,'2023-12-10','2023-12-18','p','t'),
(25,7,5,null,'2023-12-10','l','z'),
(26,0,9,'2023-12-15','2023-12-17','a','v'),
(27,9,-16167,'2023-12-17','2011-02-15','h','b'),
(28,5,1,'2008-08-17','2023-12-10','k','t'),
(29,null,8,'2023-12-10','2023-12-10','g','g'),
(30,-5899,3,'2023-12-11','2000-07-21','z','x'),
(31,3,6302479,'2023-12-17','2023-12-15','f','w'),
(32,6,8,'2023-12-10','2023-12-14','e','j'),
(33,-19533,1,'2023-12-16','2023-12-15','f','l'),
(34,7,4,'2023-12-18','2023-12-10','w','k'),
(35,1,1,'2023-12-09','2007-10-12','h','e'),
(36,26116,4,'2023-12-14','2023-12-11','r','h'),
(37,5,14276,null,'2023-12-16','k','g'),
(38,1,4,'2023-12-11','2018-03-21','n','d'),
(39,6,9,null,'2023-12-09','m','u'),
(40,2,4,'2023-12-17','2023-12-15','o','h'),
(41,2055246,6,'2023-12-17','2023-12-17','l','v'),
(42,0,8,'2023-12-18','2006-12-06','o','y'),
(43,2,-5875895,'2023-12-18','2005-02-05','s','p'),
(44,1,9,'2023-12-11','2023-12-18',null,'u'),
(45,2,-4172303,null,'2023-12-12','p','g'),
(46,3,-1617,'2023-12-11','2023-12-12','c','e'),
(47,7,-5472370,'2008-12-24','2001-04-26','b','m'),
(48,-5129872,1,'2007-11-23','2023-12-14',null,'m'),
(49,-14398,-7152997,'2023-12-18','2023-12-17','x','v'),
(50,5,6,'2023-12-16','2023-12-18','r','j'),
(51,5,-5229938,'2023-12-14','2023-12-14','l','p'),
(52,2,0,'2023-12-15','2023-12-17','x','v'),
(53,-5984631,5,'2023-12-11','2023-12-14',null,'d'),
(54,4565561,5,'2023-12-11','2023-12-11','z','l'),
(55,3,6,'2023-12-13','2023-12-18','j','w'),
(56,6,-4748871,'2023-12-15','2023-12-14','s','y'),
(57,9,8,'2023-12-14','2023-12-13','e','a'),
(58,0,5,null,'2023-12-18','x','v'),
(59,2,7,'2023-12-09','2023-12-09','o','p'),
(60,null,-2628279,'2000-02-12','2023-12-18','j','y'),
(61,1,6,'2023-12-13','2023-12-14','z','l'),
(62,3,5,null,'2023-12-14','z','n'),
(63,-18999,5021804,'2023-12-09','2004-02-18','h','z'),
(64,8367273,-379,'2023-12-12','2023-12-10','o','w'),
(65,6,-6344751,'2023-12-14','2023-12-18','e','d'),
(66,6,-2551034,'2009-10-07','2023-12-17','x','y'),
(67,8,9,'2023-12-12','2023-12-11','x','c'),
(68,-329988,8,'2023-12-18','2023-12-15','e','l'),
(69,-6403336,28987,'2023-12-14','2023-12-15','a','y'),
(70,20727,-19935,null,'2023-12-16',null,'z'),
(71,4,3,null,'2023-12-15','o','y'),
(72,6,-20445,null,'2023-12-09','t','f'),
(73,0,1,'2023-12-17','2023-12-18','k','v'),
(74,-25018,-27762,'2003-02-14','2002-02-05','z','d'),
(75,0,9,'2023-12-12','2018-05-17','y','n'),
(76,5,1,'2023-12-17','2023-12-18','t','k'),
(77,null,6,'2017-08-25','2023-12-09','s','m'),
(78,7,7,'2023-12-11','2023-12-15','e','z'),
(79,8,4067211,'2003-08-18','2023-12-15','q','e'),
(80,-2782101,7,'2023-12-15','2023-12-09',null,'n'),
(81,4,3,'2015-04-19','2023-12-10','l','s'),
(82,null,22109,'2023-12-15','2023-12-16','w','c'),
(83,9,1,'2023-12-14','2023-12-12','k','q'),
(84,-9488,-4795,'2023-12-12','2023-12-18','y','y'),
(85,1,-6072344,'2023-12-12','2023-12-13','m','a'),
(86,1,2,null,'2023-12-11','v','d'),
(87,null,1,'2023-12-11','2023-12-10',null,'d'),
(88,7270119,5,'2023-12-17','2008-02-04','v','c'),
(89,2,8,'2023-12-15','2023-12-10','g','l'),
(90,-4711688,-4031594,'2023-12-09','2023-12-13','d','f'),
(91,null,1395,'2023-12-10','2023-12-15','a','i'),
(92,3,7,null,'2023-12-10','v','r'),
(93,6,3,null,'2023-12-09','q','l'),
(94,28468,5,'2023-12-09','2023-12-17','f','k'),
(95,9,6,null,'2016-02-02',null,'m'),
(96,-2329254,3,'2023-12-12','2023-12-18','k','n'),
(97,null,-7409880,'2023-12-09','2023-12-15','h','j'),
(98,3,6,'2002-01-11','2000-02-08','s','b'),
(99,2,4,'2023-12-14','2000-09-17',null,'v'),
(100,7,-1364635,'2023-12-17','2023-12-10','i','a'),
(101,null,8,'2023-12-13','2023-12-13','y','u'),
(102,5,9,'2023-12-13','2023-12-18','e','q'),
(103,null,-702546,'2023-12-15','2012-06-12','t','z'),
(104,23537,2,'2023-12-12','2023-12-17','h','p'),
(105,null,8,'2023-12-12','2023-12-18',null,'y'),
(106,6,1,null,'2017-05-19','c','z'),
(107,4342993,5,'2023-12-12','2023-12-18','g','a'),
(108,4,7,'2023-12-12','2023-12-14','m','p'),
(109,6,8,'2023-12-18','2017-11-22','a','i'),
(110,6,-5615791,'2015-11-02','2023-12-09','j','s'),
(111,8,4,'2023-12-09','2023-12-16',null,'z'),
(112,2,7691121,null,'2023-12-09','q','r'),
(113,null,3,'2023-12-13','2023-12-12','u','x'),
(114,1,4398947,'2023-12-09','2023-12-13',null,'u'),
(115,null,7,'2023-12-11','2023-12-09','n','c'),
(116,-16785,-1536603,'2023-12-10','2023-12-13','c','f'),
(117,-30978,-1350,null,'2023-12-11','t','d'),
(118,6,5973689,null,'2023-12-15',null,'u'),
(119,7,3,'2023-12-15','2023-12-14','w','e'),
(120,3,9,'2023-12-12','2023-12-15','a','k'),
(121,null,6,'2017-08-06','2023-12-18','p','h'),
(122,4,8,'2018-03-28','2023-12-16','x','b'),
(123,7,20865,'2023-12-17','2023-12-10','g','x'),
(124,3,5,'2023-12-18','2023-12-16','c','h'),
(125,null,-7162178,'2005-04-21','2023-12-17','j','s'),
(126,3,1,'2010-01-10','2019-06-28','a','i'),
(127,8,7,'2023-12-17','2008-12-28','p','y'),
(128,-8425,19060,'2005-03-13','2010-09-06','r','z'),
(129,5,9,'2023-12-16','2001-04-21','i','d'),
(130,7,0,'2023-12-11','2023-12-15','c','y'),
(131,4,8,'2023-12-12','2017-08-14','m','u'),
(132,-5332663,3,'2023-12-18','2023-12-16','v','k'),
(133,-11973,-4263523,'2023-12-18','2023-12-18',null,'k'),
(134,4,1,'2023-12-15','2023-12-13','e','j'),
(135,6,2420,null,'2023-12-13','y','s'),
(136,7768,7,null,'2023-12-13','y','r'),
(137,-2223,7,'2007-04-28','2023-12-18',null,'d'),
(138,4,2,'2023-12-14','2011-06-13','h','k'),
(139,5379,2,'2023-12-18','2023-12-09','r','k'),
(140,7971660,8,'2023-12-17','2018-06-28','u','b'),
(141,3,5,'2023-12-17','2023-12-13','h','i'),
(142,2330337,5,'2023-12-18','2000-08-28','o','a'),
(143,6501282,6,'2023-12-10','2023-12-17','k','j'),
(144,8,5,'2023-12-16','2023-12-09','l','m'),
(145,2,8026441,'2023-12-10','2023-12-14','j','t'),
(146,8,-7960122,'2023-12-09','2023-12-11','z','g'),
(147,-23723,1,'2023-12-16','2023-12-15','l','x'),
(148,9,7,'2023-12-13','2023-12-10',null,'w'),
(149,7,-7300336,'2002-08-02','2002-08-27','u','p'),
(150,null,1,null,'2023-12-10','s','t'),
(151,null,7,'2023-12-18','2023-12-14','k','l'),
(152,3,5,'2023-12-10','2006-03-01','d','f'),
(153,6,2307292,'2023-12-15','2023-12-09','o','u'),
(154,3757534,-6753340,'2023-12-13','2019-02-15','y','g'),
(155,0,4943873,'2023-12-16','2023-12-13','k','i'),
(156,3,2,'2023-12-13','2023-12-16','i','y'),
(157,8,4,'2023-12-09','2023-12-10','a','y'),
(158,1,9,'2023-12-12','2023-12-15','u','p'),
(159,8,7840509,null,'2008-06-19','l','x'),
(160,23010,5,'2017-12-20','2023-12-15','p','q'),
(161,0,0,null,'2023-12-18','g','m'),
(162,9,3705780,'2023-12-16','2023-12-12','o','a'),
(163,null,-17022,'2023-12-13','2023-12-13','s','k'),
(164,null,6,'2023-12-14','2023-12-13','s','e'),
(165,null,8,'2023-12-15','2023-12-16','o','e'),
(166,0,6,'2023-12-14','2023-12-16',null,'w'),
(167,3297576,8,'2023-12-17','2023-12-14','a','z'),
(168,9,0,'2023-12-18','2023-12-11','n','o'),
(169,7,6,null,'2023-12-09','m','m'),
(170,4,5592370,'2023-12-10','2023-12-15',null,'t'),
(171,2656389,9,'2023-12-14','2023-12-12',null,'h'),
(172,8,1,'2023-12-12','2002-06-27','z','q'),
(173,8,3,'2023-12-15','2023-12-14','d','w'),
(174,17473,4,'2004-11-26','2023-12-10','t','o'),
(175,7,-17330,'2023-12-14','2023-12-14','d','i'),
(176,2,-31652,null,'2023-12-09','n','e'),
(177,9,0,'2023-12-09','2023-12-13','c','t'),
(178,-7603492,4,'2023-12-09','2023-12-14','l','g'),
(179,null,32549,null,'2023-12-12','p','m'),
(180,0,-6415,'2023-12-11','2023-12-11','b','u'),
(181,-26321,8,null,'2023-12-13','o','j'),
(182,1,10798,'2023-12-16','2023-12-18','x','s'),
(183,5,4,'2023-12-11','2023-12-16','d','c'),
(184,2810913,9,'2023-12-14','2023-12-16','d','t'),
(185,1707,7,null,'2023-12-14','m','i'),
(186,null,4,null,'2023-12-17','s','q'),
(187,6,3,'2023-12-15','2010-12-17','k','i'),
(188,-12254,-12199,'2023-12-18','2023-12-11','q','f'),
(189,3,6,'2023-12-12','2023-12-14',null,'y'),
(190,-5041887,4,'2013-03-27','2023-12-14','w','w'),
(191,5,1,null,'2023-12-10','f','o'),
(192,0,8,'2023-12-10','2023-12-17','d','g'),
(193,7,5,'2023-12-11','2023-12-18','z','v'),
(194,9,5,null,'2023-12-18','l','k'),
(195,2,7,null,'2023-12-11','m','i'),
(196,null,5,'2023-12-09','2023-12-16','q','e'),
(197,null,2,'2023-12-16','2023-12-16','h','u'),
(198,-8622,1,'2023-12-10','2023-12-15','q','f'),
(199,1,8,'2012-06-28','2023-12-10','e','y');

create table table_20_undef_partitions2_keys3_properties4_distributed_by54 (
col_date_undef_signed date  null  ,
col_int_undef_signed int  null  ,
col_int_undef_signed_not_null int  not null  ,
col_date_undef_signed_not_null date  not null  ,
col_varchar_5__undef_signed varchar(5)  null  ,
col_varchar_5__undef_signed_not_null varchar(5)  not null  ,
pk int
) engine=olap
DUPLICATE KEY(col_date_undef_signed)
PARTITION BY             RANGE(col_date_undef_signed) (
                PARTITION p0 VALUES LESS THAN ('2023-12-11'),
                PARTITION p1 VALUES LESS THAN ('2023-12-15'),
                PARTITION p2 VALUES LESS THAN ('2023-12-16'),
                PARTITION p3 VALUES LESS THAN ('2023-12-17'),
                PARTITION p4 VALUES LESS THAN ('2024-01-18'),
                PARTITION p5 VALUES LESS THAN ('2026-02-18'),
                PARTITION p100 VALUES LESS THAN ('9999-12-31')
            )
        
distributed by hash(pk) buckets 10
properties("replication_num" = "1");
insert into table_20_undef_partitions2_keys3_properties4_distributed_by54(pk,col_int_undef_signed,col_int_undef_signed_not_null,col_date_undef_signed,col_date_undef_signed_not_null,col_varchar_5__undef_signed,col_varchar_5__undef_signed_not_null) values (0,2611214,8,null,'2023-12-12','u','m'),(1,8,6,'2023-12-17','2004-05-24','o','s'),(2,null,4,'2023-12-09','2023-12-11','w','g'),(3,14231,1,'2023-12-18','2023-12-13',null,'q'),(4,3,9,'2023-12-13','2016-01-27','h','k'),(5,null,9,'2023-12-09','2023-12-14','y','h'),(6,7,7459174,'2023-12-09','2023-12-17',null,'g'),(7,6,-4433907,'2023-12-17','2023-12-12','v','j'),(8,2,-21515,null,'2023-12-09','l','w'),(9,5763549,4,'2023-12-12','2023-12-11','w','r'),(10,4437052,0,null,'2023-12-15','y','g'),(11,3,3,'2023-12-12','2023-12-16','e','s'),(12,-3516633,-8038112,null,'2023-12-16','i','q'),(13,4,0,'2019-02-14','2023-12-14','z','t'),(14,4,24419,'2023-12-17','2023-12-14','y','a'),(15,-29232,8,'2023-12-11','2019-01-23','q','b'),(16,null,7,'2015-07-13','2018-09-14',null,'k'),(17,18327,7,'2023-12-17','2023-12-10','d','f'),(18,0,3,'2023-12-18','2023-12-15','h','w'),(19,2,6,'2023-12-17','2023-12-09','n','n');
	"""

    Thread.sleep(70000) // wait for row count report of the tables just loaded
    // sql """ ANALYZE TABLE table_200_undef_partitions2_keys3_properties4_distributed_by52 WITH SYNC """
    // sql """ ANALYZE TABLE table_200_undef_partitions2_keys3_properties4_distributed_by5 WITH SYNC """
    // sql """ ANALYZE TABLE table_20_undef_partitions2_keys3_properties4_distributed_by54 WITH SYNC """

	qt_rqg12257 """
SELECT
    6 + (tbl_alias1.col_int_undef_signed_not_null) AS col_alias1,
    (9) col_alias2,
    SUM (
        (
            1 + (
                CASE
                    WHEN (
                        LENGTH (tbl_alias1.col_varchar_5__undef_signed) <=> (6 - (1))
                    ) THEN (3)
                    ELSE ((8))
                END
            )
        )
    ) col_alias3,
    SUM (DISTINCT tbl_alias1.col_int_undef_signed) AS col_alias4
FROM
    table_200_undef_partitions2_keys3_properties4_distributed_by52 AS tbl_alias1
    LEFT JOIN table_200_undef_partitions2_keys3_properties4_distributed_by52 AS tbl_alias2 ON tbl_alias1.col_varchar_5__undef_signed_not_null >= tbl_alias1.col_varchar_5__undef_signed
    RIGHT JOIN table_200_undef_partitions2_keys3_properties4_distributed_by5 AS tbl_alias3 ON tbl_alias1.col_varchar_5__undef_signed >= tbl_alias1.col_date_undef_signed_not_null FULL
    JOIN table_20_undef_partitions2_keys3_properties4_distributed_by54 AS tbl_alias4 ON tbl_alias1.col_date_undef_signed_not_null <=> tbl_alias4.col_date_undef_signed_not_null
WHERE
    NOT (
        tbl_alias3.col_varchar_5__undef_signed_not_null < tbl_alias1.col_varchar_5__undef_signed_not_null
    )
GROUP BY
    col_alias1,
    col_alias2
ORDER BY
    col_alias1,
    col_alias2,
    col_alias3,
    col_alias4 ASC
LIMIT
    10 OFFSET 100;
	"""
}