/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.fun.SqlInternalOperators;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class LiteralSqlAggregator
implements SqlAggregator {
    @Override
    public SqlAggFunction calciteFunction() {
        return SqlInternalOperators.LITERAL_AGG;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        if (aggregateCall.rexList.size() == 0) {
            return null;
        }
        RexNode literal = (RexNode)aggregateCall.rexList.get(0);
        DruidExpression expr = Expressions.toDruidExpression(plannerContext, inputAccessor.getInputRowSignature(), literal);
        if (expr == null) {
            return null;
        }
        return Aggregation.create((List<AggregatorFactory>)ImmutableList.of(), (PostAggregator)new ExpressionPostAggregator(name, expr.getExpression(), null, expr.getDruidType(), plannerContext.getExprMacroTable()));
    }
}

