/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression.builtin;

import com.google.inject.Inject;
import java.util.List;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Evals;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.query.extraction.ExtractionFn;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.query.lookup.RegisteredLookupExtractionFn;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class QueryLookupOperatorConversion
implements SqlOperatorConversion {
    public static final SqlFunction SQL_FUNCTION = OperatorConversions.operatorBuilder("LOOKUP").operandNames("expr", "lookupName", "replaceMissingValueWith").operandTypes(SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER, SqlTypeFamily.CHARACTER).requiredOperandCount(2).literalOperands(1, 2).returnTypeNullable(SqlTypeName.VARCHAR).functionCategory(SqlFunctionCategory.STRING).build();
    private final LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider;

    @Inject
    public QueryLookupOperatorConversion(LookupExtractorFactoryContainerProvider lookupExtractorFactoryContainerProvider) {
        this.lookupExtractorFactoryContainerProvider = lookupExtractorFactoryContainerProvider;
    }

    public SqlFunction calciteOperator() {
        return SQL_FUNCTION;
    }

    @Override
    public DruidExpression toDruidExpression(PlannerContext plannerContext, RowSignature rowSignature, RexNode rexNode) {
        return OperatorConversions.convertDirectCallWithExtraction(plannerContext, rowSignature, rexNode, StringUtils.toLowerCase((String)this.calciteOperator().getName()), inputExpressions -> {
            DruidExpression arg = (DruidExpression)inputExpressions.get(0);
            Expr lookupNameExpr = plannerContext.parseExpression(((DruidExpression)inputExpressions.get(1)).getExpression());
            String replaceMissingValueWith = this.getReplaceMissingValueWith((List<DruidExpression>)inputExpressions, plannerContext);
            String lookupName = (String)lookupNameExpr.getLiteralValue();
            plannerContext.addLookupToLoad(this.lookupExtractorFactoryContainerProvider.getCanonicalLookupName(lookupName));
            if (arg.isSimpleExtraction() && lookupNameExpr.isLiteral()) {
                return arg.getSimpleExtraction().cascade((ExtractionFn)new RegisteredLookupExtractionFn(this.lookupExtractorFactoryContainerProvider, lookupName, false, replaceMissingValueWith, null, Boolean.valueOf(!plannerContext.isPullUpLookup())));
            }
            return null;
        });
    }

    public LookupExtractorFactoryContainerProvider getLookupExtractorFactoryContainerProvider() {
        return this.lookupExtractorFactoryContainerProvider;
    }

    private String getReplaceMissingValueWith(List<DruidExpression> inputExpressions, PlannerContext plannerContext) {
        Expr missingValExpr;
        if (inputExpressions.size() > 2 && (missingValExpr = plannerContext.parseExpression(inputExpressions.get(2).getExpression())).isLiteral()) {
            return Evals.asString((Object)missingValExpr.getLiteralValue());
        }
        return null;
    }
}

