/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.ValidationException;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.query.QueryContext;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.parser.DruidSqlInsert;
import org.apache.druid.sql.calcite.parser.DruidSqlReplace;
import org.apache.druid.sql.calcite.parser.ParseException;
import org.apache.druid.sql.calcite.parser.Token;
import org.apache.druid.sql.calcite.planner.CalcitePlanner;
import org.apache.druid.sql.calcite.planner.IngestHandler;
import org.apache.druid.sql.calcite.planner.NoOpPlannerHook;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerHook;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.planner.QueryHandler;
import org.apache.druid.sql.calcite.planner.SqlParameterizerShuttle;
import org.apache.druid.sql.calcite.planner.SqlStatementHandler;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.joda.time.DateTimeZone;

public class DruidPlanner
implements Closeable {
    public static final Joiner SPACE_JOINER = Joiner.on((String)" ");
    public static final Joiner COMMA_JOINER = Joiner.on((String)", ");
    private final FrameworkConfig frameworkConfig;
    private final CalcitePlanner planner;
    private final PlannerContext plannerContext;
    private final SqlEngine engine;
    private final PlannerHook hook;
    private State state = State.START;
    private SqlStatementHandler handler;
    private boolean authorized;

    DruidPlanner(FrameworkConfig frameworkConfig, PlannerContext plannerContext, SqlEngine engine, PlannerHook hook) {
        this.frameworkConfig = frameworkConfig;
        this.planner = new CalcitePlanner(frameworkConfig);
        this.plannerContext = plannerContext;
        this.engine = engine;
        this.hook = hook == null ? NoOpPlannerHook.INSTANCE : hook;
    }

    public void validate() {
        SqlNode root;
        Preconditions.checkState((this.state == State.START ? 1 : 0) != 0);
        this.engine.validateContext(this.plannerContext.queryContextMap());
        String sql = this.plannerContext.getSql();
        this.hook.captureSql(sql);
        try {
            root = this.planner.parse(sql);
        }
        catch (SqlParseException e1) {
            throw DruidPlanner.translateException((Exception)((Object)e1));
        }
        root = this.rewriteParameters(root);
        this.hook.captureSqlNode(root);
        this.handler = this.createHandler(root);
        this.handler.validate();
        this.plannerContext.setResourceActions(this.handler.resourceActions());
        this.state = State.VALIDATED;
    }

    private SqlStatementHandler createHandler(SqlNode node) {
        SqlNode query = node;
        SqlExplain explain = null;
        if (query.getKind() == SqlKind.EXPLAIN) {
            explain = (SqlExplain)query;
            query = explain.getExplicandum();
        }
        HandlerContextImpl handlerContext = new HandlerContextImpl();
        if (query.getKind() == SqlKind.INSERT) {
            if (query instanceof DruidSqlInsert) {
                return new IngestHandler.InsertHandler(handlerContext, (DruidSqlInsert)query, explain);
            }
            if (query instanceof DruidSqlReplace) {
                return new IngestHandler.ReplaceHandler(handlerContext, (DruidSqlReplace)query, explain);
            }
        }
        if (query.isA((Set)SqlKind.QUERY)) {
            return new QueryHandler.SelectHandler(handlerContext, query, explain);
        }
        throw InvalidSqlInput.exception((String)"Unsupported SQL statement [%s]", (Object[])new Object[]{node.getKind()});
    }

    private SqlNode rewriteParameters(SqlNode original) {
        if (this.plannerContext.getParameters().isEmpty()) {
            return original;
        }
        return (SqlNode)original.accept((SqlVisitor)new SqlParameterizerShuttle(this.plannerContext));
    }

    public PrepareResult prepare() {
        Preconditions.checkState((this.state == State.VALIDATED ? 1 : 0) != 0);
        this.handler.prepare();
        this.state = State.PREPARED;
        return this.prepareResult();
    }

    public AuthResult authorize(Function<Set<ResourceAction>, AuthorizationResult> authorizer, Set<ResourceAction> extraActions) {
        Preconditions.checkState((this.state == State.VALIDATED ? 1 : 0) != 0);
        Set<ResourceAction> sqlResourceActions = this.plannerContext.getResourceActions();
        HashSet<ResourceAction> allResourceActions = new HashSet<ResourceAction>(sqlResourceActions);
        allResourceActions.addAll(extraActions);
        AuthorizationResult authorizationResult = authorizer.apply(allResourceActions);
        this.plannerContext.setAuthorizationResult(authorizationResult);
        this.authorized = true;
        return new AuthResult(authorizationResult, sqlResourceActions, allResourceActions);
    }

    public PlannerResult plan() {
        Preconditions.checkState((this.state == State.VALIDATED || this.state == State.PREPARED ? 1 : 0) != 0);
        Preconditions.checkState((boolean)this.authorized);
        this.state = State.PLANNED;
        return this.handler.plan();
    }

    public PlannerContext getPlannerContext() {
        return this.plannerContext;
    }

    public PrepareResult prepareResult() {
        return this.handler.prepareResult();
    }

    @Override
    public void close() {
        this.planner.close();
    }

    public static DruidException translateException(Exception e) {
        try {
            throw e;
        }
        catch (DruidException inner) {
            return inner;
        }
        catch (ValidationException inner) {
            return DruidPlanner.parseValidationMessage((Exception)((Object)inner));
        }
        catch (SqlParseException inner) {
            Throwable cause = inner.getCause();
            if (cause instanceof DruidException) {
                return (DruidException)cause;
            }
            if (cause instanceof ParseException) {
                ParseException parseException = (ParseException)cause;
                SqlParserPos failurePosition = inner.getPos();
                if (parseException.expectedTokenSequences == null) {
                    return DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).withErrorCode("invalidInput").build((Throwable)inner, "%s", new Object[]{inner.getMessage()}).withContext("sourceType", (Object)"sql");
                }
                String theUnexpectedToken = DruidPlanner.getUnexpectedTokenString(parseException);
                String[] tokenDictionary = inner.getTokenImages();
                int[][] expectedTokenSequences = inner.getExpectedTokenSequences();
                ArrayList<String> expectedTokens = new ArrayList<String>(expectedTokenSequences.length);
                for (int[] expectedTokenSequence : expectedTokenSequences) {
                    Object[] strings = new String[expectedTokenSequence.length];
                    for (int i = 0; i < expectedTokenSequence.length; ++i) {
                        strings[i] = tokenDictionary[expectedTokenSequence[i]];
                    }
                    expectedTokens.add(SPACE_JOINER.join(strings));
                }
                return InvalidSqlInput.exception((Throwable)inner, (String)"Received an unexpected token [%s] (line [%s], column [%s]), acceptable options: [%s]", (Object[])new Object[]{theUnexpectedToken, failurePosition.getLineNum(), failurePosition.getColumnNum(), COMMA_JOINER.join(expectedTokens)}).withContext("line", (Object)failurePosition.getLineNum()).withContext("column", (Object)failurePosition.getColumnNum()).withContext("endLine", (Object)failurePosition.getEndLineNum()).withContext("endColumn", (Object)failurePosition.getEndColumnNum()).withContext("token", (Object)theUnexpectedToken).withContext("expected", expectedTokens);
            }
            return InvalidSqlInput.exception((String)inner.getMessage(), (Object[])new Object[0]);
        }
        catch (RelOptPlanner.CannotPlanException inner) {
            return DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build((Throwable)inner, "%s", new Object[]{inner.getMessage()});
        }
        catch (Exception inner) {
            return DruidException.forPersona((DruidException.Persona)DruidException.Persona.ADMIN).ofCategory(DruidException.Category.UNCATEGORIZED).build((Throwable)inner, "%s", new Object[]{inner.getMessage()});
        }
    }

    private static DruidException parseValidationMessage(Exception e) {
        if (e.getCause() instanceof DruidException) {
            return (DruidException)e.getCause();
        }
        CalciteContextException contextException = null;
        for (Throwable maybeContextException = e; maybeContextException != null; maybeContextException = maybeContextException.getCause()) {
            if (!(maybeContextException instanceof CalciteContextException)) continue;
            contextException = (CalciteContextException)maybeContextException;
            break;
        }
        if (contextException != null) {
            return InvalidSqlInput.exception((Throwable)e, (String)"%s (line [%s], column [%s])", (Object[])new Object[]{contextException.getCause().getMessage(), contextException.getPosLine(), contextException.getPosColumn()}).withContext("line", (Object)String.valueOf(contextException.getPosLine())).withContext("column", (Object)String.valueOf(contextException.getPosColumn())).withContext("endLine", (Object)String.valueOf(contextException.getEndPosLine())).withContext("endColumn", (Object)String.valueOf(contextException.getEndPosColumn()));
        }
        return DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.UNCATEGORIZED).build((Throwable)e, "Uncategorized calcite error message: [%s]", new Object[]{e.getMessage()});
    }

    private static String getUnexpectedTokenString(ParseException parseException) {
        int maxSize = 0;
        for (int[] ints : parseException.expectedTokenSequences) {
            if (maxSize >= ints.length) continue;
            maxSize = ints.length;
        }
        StringBuilder bob = new StringBuilder();
        Token tok = parseException.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                bob.append(" ");
            }
            if (tok.kind == 0) {
                bob.append("<EOF>");
                break;
            }
            block13: for (int i1 = 0; i1 < tok.image.length(); ++i1) {
                switch (tok.image.charAt(i1)) {
                    case '\u0000': {
                        continue block13;
                    }
                    case '\b': {
                        bob.append("\\b");
                        continue block13;
                    }
                    case '\t': {
                        bob.append("\\t");
                        continue block13;
                    }
                    case '\n': {
                        bob.append("\\n");
                        continue block13;
                    }
                    case '\f': {
                        bob.append("\\f");
                        continue block13;
                    }
                    case '\r': {
                        bob.append("\\r");
                        continue block13;
                    }
                    case '\"': {
                        bob.append("\\\"");
                        continue block13;
                    }
                    case '\'': {
                        bob.append("\\'");
                        continue block13;
                    }
                    case '\\': {
                        bob.append("\\\\");
                        continue block13;
                    }
                    default: {
                        char ch = tok.image.charAt(i1);
                        if (ch < ' ' || ch > '~') {
                            String s = "0000" + Integer.toString(ch, 16);
                            bob.append("\\u").append(s.substring(s.length() - 4, s.length()));
                            continue block13;
                        }
                        bob.append(ch);
                    }
                }
            }
            tok = tok.next;
        }
        return bob.toString();
    }

    protected class HandlerContextImpl
    implements SqlStatementHandler.HandlerContext {
        protected HandlerContextImpl() {
        }

        @Override
        public PlannerContext plannerContext() {
            return DruidPlanner.this.plannerContext;
        }

        @Override
        public SqlEngine engine() {
            return DruidPlanner.this.engine;
        }

        @Override
        public CalcitePlanner planner() {
            return DruidPlanner.this.planner;
        }

        @Override
        public QueryContext queryContext() {
            return DruidPlanner.this.plannerContext.queryContext();
        }

        @Override
        public Map<String, Object> queryContextMap() {
            return DruidPlanner.this.plannerContext.queryContextMap();
        }

        @Override
        public SchemaPlus defaultSchema() {
            return DruidPlanner.this.frameworkConfig.getDefaultSchema();
        }

        @Override
        public ObjectMapper jsonMapper() {
            return DruidPlanner.this.plannerContext.getJsonMapper();
        }

        @Override
        public DateTimeZone timeZone() {
            return DruidPlanner.this.plannerContext.getTimeZone();
        }

        @Override
        public PlannerHook hook() {
            return DruidPlanner.this.hook;
        }
    }

    public static class AuthResult {
        public final AuthorizationResult authorizationResult;
        public final Set<ResourceAction> sqlResourceActions;
        public final Set<ResourceAction> allResourceActions;

        public AuthResult(AuthorizationResult authorizationResult, Set<ResourceAction> sqlResourceActions, Set<ResourceAction> allResourceActions) {
            this.authorizationResult = authorizationResult;
            this.sqlResourceActions = sqlResourceActions;
            this.allResourceActions = allResourceActions;
        }
    }

    public static enum State {
        START,
        VALIDATED,
        PREPARED,
        PLANNED;

    }
}

