/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel.logical;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.schema.Table;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.SourceDescProducer;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalConvention;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;
import org.apache.druid.sql.calcite.table.DruidTable;

public class DruidTableScan
extends TableScan
implements DruidLogicalNode,
SourceDescProducer {
    public DruidTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table) {
        super(cluster, traitSet, table);
        assert (this.getConvention() instanceof DruidLogicalConvention);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new DruidTableScan(this.getCluster(), traitSet, this.table);
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return planner.getCostFactory().makeTinyCost();
    }

    public double estimateRowCount(RelMetadataQuery mq) {
        return 1000.0;
    }

    public RelWriter explainTerms(RelWriter pw) {
        return super.explainTerms(pw).item("druid", (Object)"logical");
    }

    public RelDataType deriveRowType() {
        return super.deriveRowType();
    }

    public static DruidTableScan create(RelOptCluster cluster, RelOptTable relOptTable) {
        Table table = (Table)relOptTable.unwrap(Table.class);
        RelTraitSet traitSet = cluster.traitSet().replaceIfs((RelTraitDef)RelCollationTraitDef.INSTANCE, () -> {
            if (table != null) {
                return table.getStatistic().getCollations();
            }
            return ImmutableList.of();
        });
        return new DruidTableScan(cluster, traitSet, relOptTable);
    }

    @Override
    public SourceDescProducer.SourceDesc getSourceDesc(PlannerContext plannerContext, List<SourceDescProducer.SourceDesc> sources) {
        DruidTable druidTable = this.getDruidTable();
        return new SourceDescProducer.SourceDesc(druidTable.getDataSource(), druidTable.getRowSignature());
    }

    private DruidTable getDruidTable() {
        RelOptTable table = this.getTable();
        DruidTable druidTable = (DruidTable)table.unwrap(DruidTable.class);
        Preconditions.checkNotNull((Object)druidTable, (Object)"DruidTable may not be null");
        return druidTable;
    }
}

