/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.DruidOuterQueryRel;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.PartialDruidQuery;
import org.apache.druid.sql.calcite.rule.DruidCorrelateUnnestRule;
import org.apache.druid.sql.calcite.rule.DruidFilterUnnestRule;
import org.apache.druid.sql.calcite.rule.DruidJoinRule;
import org.apache.druid.sql.calcite.rule.DruidSortUnionRule;
import org.apache.druid.sql.calcite.rule.DruidUnionDataSourceRule;
import org.apache.druid.sql.calcite.rule.DruidUnionRule;
import org.apache.druid.sql.calcite.rule.DruidUnnestRule;
import org.apache.druid.sql.calcite.run.EngineFeature;

public class DruidRules {
    public static final Predicate<DruidRel> CAN_BUILD_ON = druidRel -> druidRel.getPartialDruidQuery() != null;

    private DruidRules() {
    }

    public static List<RelOptRule> rules(PlannerContext plannerContext) {
        ArrayList<RelOptRule> retVal = new ArrayList<RelOptRule>((Collection<RelOptRule>)ImmutableList.of(new DruidQueryRule<Filter>(Filter.class, PartialDruidQuery.Stage.WHERE_FILTER, PartialDruidQuery::withWhereFilter), new DruidQueryRule<Project>(Project.class, PartialDruidQuery.Stage.SELECT_PROJECT, PartialDruidQuery::withSelectProject), new DruidQueryRule<Aggregate>(Aggregate.class, PartialDruidQuery.Stage.AGGREGATE, PartialDruidQuery::withAggregate), new DruidQueryRule<Project>(Project.class, PartialDruidQuery.Stage.AGGREGATE_PROJECT, PartialDruidQuery::withAggregateProject), new DruidQueryRule<Filter>(Filter.class, PartialDruidQuery.Stage.HAVING_FILTER, PartialDruidQuery::withHavingFilter), new DruidQueryRule<Sort>(Sort.class, PartialDruidQuery.Stage.SORT, PartialDruidQuery::withSort), new DruidQueryRule<Project>(Project.class, PartialDruidQuery.Stage.SORT_PROJECT, PartialDruidQuery::withSortProject), (Object)DruidOuterQueryRule.AGGREGATE, (Object)DruidOuterQueryRule.WHERE_FILTER, (Object)DruidOuterQueryRule.SELECT_PROJECT, (Object)DruidOuterQueryRule.SORT, (Object)((Object)new DruidUnionRule(plannerContext)), (Object[])new RelOptRule[]{new DruidUnionDataSourceRule(plannerContext), DruidJoinRule.instance(plannerContext)}));
        if (plannerContext.featureAvailable(EngineFeature.ALLOW_TOP_LEVEL_UNION_ALL)) {
            retVal.add(DruidSortUnionRule.instance());
        }
        if (plannerContext.featureAvailable(EngineFeature.WINDOW_FUNCTIONS)) {
            retVal.add(new DruidQueryRule<Window>(Window.class, PartialDruidQuery.Stage.WINDOW, PartialDruidQuery::withWindow));
            retVal.add(new DruidQueryRule<Project>(Project.class, PartialDruidQuery.Stage.WINDOW_PROJECT, Project::isMapping, PartialDruidQuery::withWindowProject));
            retVal.add(DruidOuterQueryRule.WINDOW);
        }
        if (plannerContext.featureAvailable(EngineFeature.UNNEST)) {
            retVal.add(new DruidUnnestRule(plannerContext));
            retVal.add(new DruidCorrelateUnnestRule(plannerContext));
            retVal.add((RelOptRule)CoreRules.PROJECT_CORRELATE_TRANSPOSE);
            retVal.add(DruidFilterUnnestRule.instance());
            retVal.add(DruidFilterUnnestRule.DruidProjectOnUnnestRule.instance());
        }
        return retVal;
    }

    public static abstract class DruidOuterQueryRule
    extends RelOptRule {
        public static final RelOptRule AGGREGATE = new DruidOuterQueryRule(PartialDruidQuery.Stage.AGGREGATE, DruidOuterQueryRule.operand(Aggregate.class, (RelOptRuleOperand)DruidOuterQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "AGGREGATE"){

            public void onMatch(RelOptRuleCall call) {
                Aggregate aggregate = (Aggregate)call.rel(0);
                DruidRel druidRel = (DruidRel)call.rel(1);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.createOuterQuery(druidRel.getPartialDruidQuery(), druidRel.getPlannerContext()).withAggregate(aggregate));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule WHERE_FILTER = new DruidOuterQueryRule(PartialDruidQuery.Stage.WHERE_FILTER, DruidOuterQueryRule.operand(Filter.class, (RelOptRuleOperand)DruidOuterQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "WHERE_FILTER"){

            public void onMatch(RelOptRuleCall call) {
                Filter filter = (Filter)call.rel(0);
                DruidRel druidRel = (DruidRel)call.rel(1);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.createOuterQuery(druidRel.getPartialDruidQuery(), druidRel.getPlannerContext()).withWhereFilter(filter));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule SELECT_PROJECT = new DruidOuterQueryRule(PartialDruidQuery.Stage.SELECT_PROJECT, DruidOuterQueryRule.operand(Project.class, (RelOptRuleOperand)DruidOuterQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "SELECT_PROJECT"){

            public void onMatch(RelOptRuleCall call) {
                Project filter = (Project)call.rel(0);
                DruidRel druidRel = (DruidRel)call.rel(1);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.createOuterQuery(druidRel.getPartialDruidQuery(), druidRel.getPlannerContext()).withSelectProject(filter));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule SORT = new DruidOuterQueryRule(PartialDruidQuery.Stage.SORT, DruidOuterQueryRule.operand(Sort.class, (RelOptRuleOperand)DruidOuterQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "SORT"){

            public void onMatch(RelOptRuleCall call) {
                Sort sort = (Sort)call.rel(0);
                DruidRel druidRel = (DruidRel)call.rel(1);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.createOuterQuery(druidRel.getPartialDruidQuery(), druidRel.getPlannerContext()).withSort(sort));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        public static final RelOptRule WINDOW = new DruidOuterQueryRule(PartialDruidQuery.Stage.WINDOW, DruidOuterQueryRule.operand(Window.class, (RelOptRuleOperand)DruidOuterQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidOuterQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), "WINDOW"){

            public void onMatch(RelOptRuleCall call) {
                Window window = (Window)call.rel(0);
                DruidRel druidRel = (DruidRel)call.rel(1);
                DruidOuterQueryRel outerQueryRel = DruidOuterQueryRel.create(druidRel, PartialDruidQuery.createOuterQuery(druidRel.getPartialDruidQuery(), druidRel.getPlannerContext()).withWindow(window));
                if (outerQueryRel.isValidDruidQuery()) {
                    call.transformTo((RelNode)outerQueryRel);
                }
            }
        };
        private final PartialDruidQuery.Stage stage;

        public DruidOuterQueryRule(PartialDruidQuery.Stage stage, RelOptRuleOperand op, String description) {
            super(op, StringUtils.format((String)"%s(%s)", (Object[])new Object[]{DruidOuterQueryRel.class.getSimpleName(), description}));
            this.stage = stage;
        }

        public boolean matches(RelOptRuleCall call) {
            DruidRel lowerDruidRel = (DruidRel)call.rel(call.getRelList().size() - 1);
            RelNode lowerRel = lowerDruidRel.getPartialDruidQuery().leafRel();
            PartialDruidQuery.Stage lowerStage = lowerDruidRel.getPartialDruidQuery().stage();
            if (this.stage.canFollow(lowerStage) || this.stage == PartialDruidQuery.Stage.WHERE_FILTER && PartialDruidQuery.Stage.HAVING_FILTER.canFollow(lowerStage) || this.stage == PartialDruidQuery.Stage.SELECT_PROJECT && PartialDruidQuery.Stage.SORT_PROJECT.canFollow(lowerStage)) {
                return false;
            }
            if (this.stage == PartialDruidQuery.Stage.WHERE_FILTER && lowerRel instanceof Filter) {
                return false;
            }
            if (this.stage == PartialDruidQuery.Stage.WHERE_FILTER && lowerStage == PartialDruidQuery.Stage.SELECT_PROJECT) {
                return false;
            }
            return this.stage != PartialDruidQuery.Stage.SELECT_PROJECT || !(lowerRel instanceof Project);
        }
    }

    public static class DruidQueryRule<RelType extends RelNode>
    extends RelOptRule {
        private final PartialDruidQuery.Stage stage;
        private final Predicate<RelType> matchesFn;
        private final BiFunction<PartialDruidQuery, RelType, PartialDruidQuery> applyFn;

        public DruidQueryRule(Class<RelType> relClass, PartialDruidQuery.Stage stage, Predicate<RelType> matchesFn, BiFunction<PartialDruidQuery, RelType, PartialDruidQuery> applyFn) {
            super(DruidQueryRule.operand(relClass, (RelOptRuleOperand)DruidQueryRule.operandJ(DruidRel.class, null, CAN_BUILD_ON, (RelOptRuleOperandChildren)DruidQueryRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), StringUtils.format((String)"%s(%s)", (Object[])new Object[]{DruidQueryRule.class.getSimpleName(), stage}));
            this.stage = stage;
            this.matchesFn = matchesFn;
            this.applyFn = applyFn;
        }

        public DruidQueryRule(Class<RelType> relClass, PartialDruidQuery.Stage stage, BiFunction<PartialDruidQuery, RelType, PartialDruidQuery> applyFn) {
            this(relClass, stage, r -> true, applyFn);
        }

        public boolean matches(RelOptRuleCall call) {
            RelNode otherRel = call.rel(0);
            DruidRel druidRel = (DruidRel)call.rel(1);
            return druidRel.getPartialDruidQuery().canAccept(this.stage) && this.matchesFn.test(otherRel);
        }

        public void onMatch(RelOptRuleCall call) {
            PartialDruidQuery newPartialDruidQuery;
            RelNode otherRel = call.rel(0);
            DruidRel druidRel = (DruidRel)call.rel(1);
            Object newDruidRel = druidRel.withPartialQuery(newPartialDruidQuery = this.applyFn.apply(druidRel.getPartialDruidQuery(), otherRel));
            if (((DruidRel)((Object)newDruidRel)).isValidDruidQuery()) {
                call.transformTo(newDruidRel);
            }
        }
    }
}

