/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule.logical;

import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.UnnestDataSource;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.querygen.SourceDescProducer;
import org.apache.druid.sql.calcite.rel.DruidJoinQueryRel;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;
import org.apache.druid.sql.calcite.rule.logical.Unnest;

public class DruidUnnest
extends Unnest
implements DruidLogicalNode,
SourceDescProducer {
    protected DruidUnnest(RelOptCluster cluster, RelTraitSet traits, RelNode input, RexNode unnestExpr, RelDataType rowType, RexNode condition) {
        super(cluster, traits, input, unnestExpr, rowType, condition);
    }

    @Override
    protected RelNode copy(RelTraitSet traitSet, RelNode input) {
        return new DruidUnnest(this.getCluster(), traitSet, input, this.unnestExpr, this.rowType, this.filter);
    }

    @Override
    public SourceDescProducer.SourceDesc getSourceDesc(PlannerContext plannerContext, List<SourceDescProducer.SourceDesc> sources) {
        SourceDescProducer.SourceDesc inputDesc = sources.get(0);
        RowSignature outputRowSignature = this.computeRowOutputSignature(inputDesc);
        RowSignature filterRowSignature = RowSignature.builder().add(outputRowSignature.getColumnName(outputRowSignature.size() - 1), (ColumnType)outputRowSignature.getColumnType(outputRowSignature.size() - 1).get()).build();
        VirtualColumn virtualColumn = this.buildUnnestVirtualColumn(plannerContext, inputDesc, filterRowSignature.getColumnName(0));
        DimFilter dimFilter = this.buildDimFilter(plannerContext, filterRowSignature);
        UnnestDataSource dataSource = UnnestDataSource.create((DataSource)inputDesc.dataSource, (VirtualColumn)virtualColumn, (DimFilter)dimFilter);
        return new SourceDescProducer.SourceDesc((DataSource)dataSource, outputRowSignature);
    }

    private DimFilter buildDimFilter(PlannerContext plannerContext, RowSignature filterRowSignature) {
        if (this.filter == null) {
            return null;
        }
        DimFilter dimFilter = Expressions.toFilter(plannerContext, filterRowSignature, null, this.filter);
        return Filtration.create(dimFilter).optimizeFilterOnly(filterRowSignature).getDimFilter();
    }

    private VirtualColumn buildUnnestVirtualColumn(PlannerContext plannerContext, SourceDescProducer.SourceDesc inputDesc, String columnName) {
        DruidExpression expressionToUnnest = Expressions.toDruidExpression(plannerContext, inputDesc.rowSignature, this.unnestExpr);
        VirtualColumn virtualColumn = expressionToUnnest.toVirtualColumn(columnName, Calcites.getColumnTypeForRelDataType(this.unnestExpr.getType()), plannerContext.getExpressionParser());
        return virtualColumn;
    }

    private RowSignature computeRowOutputSignature(SourceDescProducer.SourceDesc inputDesc) {
        return (RowSignature)DruidJoinQueryRel.computeJoinRowSignature((RowSignature)inputDesc.rowSignature, (RowSignature)RowSignature.builder().add((String)"unnest", (ColumnType)Calcites.getColumnTypeForRelDataType((RelDataType)this.getUnnestedType())).build(), DruidJoinQueryRel.findExistingJoinPrefixes((DataSource[])new DataSource[]{inputDesc.dataSource})).rhs;
    }

    private RelDataType getUnnestedType() {
        return ((RelDataTypeField)this.rowType.getFieldList().get(this.rowType.getFieldCount() - 1)).getType();
    }
}

