/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.nio.ByteBuffer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.datasketches.hll.TgtHllType;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringEncoding;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.BufferAggregator;
import org.apache.druid.query.aggregation.VectorAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildBufferAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildUtil;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchBuildVectorAggregator;
import org.apache.druid.query.aggregation.datasketches.hll.HllSketchUpdater;
import org.apache.druid.query.dimension.DefaultDimensionSpec;
import org.apache.druid.query.dimension.DimensionSpec;
import org.apache.druid.segment.ColumnInspector;
import org.apache.druid.segment.ColumnSelectorFactory;
import org.apache.druid.segment.ColumnValueSelector;
import org.apache.druid.segment.DimensionSelector;
import org.apache.druid.segment.column.ColumnCapabilities;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.segment.data.IndexedInts;
import org.apache.druid.segment.vector.VectorColumnSelectorFactory;

public class HllSketchBuildAggregatorFactory
extends HllSketchAggregatorFactory {
    public static final ColumnType TYPE = ColumnType.ofComplex((String)"HLLSketchBuild");

    @JsonCreator
    public HllSketchBuildAggregatorFactory(@JsonProperty(value="name") String name, @JsonProperty(value="fieldName") String fieldName, @JsonProperty(value="lgK") @Nullable Integer lgK, @JsonProperty(value="tgtHllType") @Nullable String tgtHllType, @JsonProperty(value="stringEncoding") @Nullable StringEncoding stringEncoding, @JsonProperty(value="shouldFinalize") Boolean shouldFinalize, @JsonProperty(value="round") boolean round) {
        super(name, fieldName, lgK, tgtHllType, stringEncoding, shouldFinalize, round);
    }

    public ColumnType getIntermediateType() {
        return TYPE;
    }

    @Override
    protected byte getCacheTypeId() {
        return 46;
    }

    public Aggregator factorize(ColumnSelectorFactory columnSelectorFactory) {
        return new HllSketchBuildAggregator(this.formulateSketchUpdater(columnSelectorFactory), this.getLgK(), TgtHllType.valueOf((String)this.getTgtHllType()));
    }

    public BufferAggregator factorizeBuffered(ColumnSelectorFactory columnSelectorFactory) {
        return new HllSketchBuildBufferAggregator(this.formulateSketchUpdater(columnSelectorFactory), this.getLgK(), TgtHllType.valueOf((String)this.getTgtHllType()), this.getStringEncoding(), this.getMaxIntermediateSize());
    }

    public boolean canVectorize(ColumnInspector columnInspector) {
        return true;
    }

    public VectorAggregator factorizeVector(VectorColumnSelectorFactory selectorFactory) {
        this.validateInputs(selectorFactory.getColumnCapabilities(this.getFieldName()));
        return HllSketchBuildVectorAggregator.create(selectorFactory, this.getFieldName(), this.getLgK(), TgtHllType.valueOf((String)this.getTgtHllType()), this.getStringEncoding(), this.getMaxIntermediateSize());
    }

    public int getMaxIntermediateSize() {
        return HllSketch.getMaxUpdatableSerializationBytes((int)this.getLgK(), (TgtHllType)TgtHllType.valueOf((String)this.getTgtHllType()));
    }

    public AggregatorFactory withName(String newName) {
        return new HllSketchBuildAggregatorFactory(newName, this.getFieldName(), this.getLgK(), this.getTgtHllType(), this.getStringEncoding(), this.isShouldFinalize(), this.isRound());
    }

    private void validateInputs(@Nullable ColumnCapabilities capabilities) {
        if (capabilities != null && capabilities.is((TypeDescriptor)ValueType.COMPLEX)) {
            throw new ISE("Invalid input [%s] of type [%s] for [%s] aggregator [%s]", new Object[]{this.getFieldName(), capabilities.asTypeString(), "HLLSketchBuild", this.getName()});
        }
    }

    private HllSketchUpdater formulateSketchUpdater(ColumnSelectorFactory columnSelectorFactory) {
        ColumnValueSelector selector;
        ColumnCapabilities capabilities = columnSelectorFactory.getColumnCapabilities(this.getFieldName());
        this.validateInputs(capabilities);
        HllSketchUpdater updater = null;
        if (capabilities != null && StringEncoding.UTF8.equals((Object)this.getStringEncoding()) && ValueType.STRING.equals((Object)capabilities.getType()) && (selector = columnSelectorFactory.makeDimensionSelector((DimensionSpec)DefaultDimensionSpec.of((String)this.getFieldName()))).supportsLookupNameUtf8()) {
            updater = arg_0 -> HllSketchBuildAggregatorFactory.lambda$formulateSketchUpdater$0((DimensionSelector)selector, arg_0);
        }
        if (updater == null) {
            selector = columnSelectorFactory.makeColumnValueSelector(this.getFieldName());
            ValueType type = capabilities == null ? ValueType.COMPLEX : (ValueType)capabilities.getType();
            switch (type) {
                case LONG: {
                    updater = sketch -> {
                        if (!selector.isNull()) {
                            ((HllSketch)sketch.get()).update(selector.getLong());
                        }
                    };
                    break;
                }
                case FLOAT: 
                case DOUBLE: {
                    updater = sketch -> {
                        if (!selector.isNull()) {
                            ((HllSketch)sketch.get()).update(selector.getDouble());
                        }
                    };
                    break;
                }
                case ARRAY: {
                    throw InvalidInput.exception((String)"ARRAY types are not supported for hll sketch", (Object[])new Object[0]);
                }
                default: {
                    updater = sketch -> {
                        Object obj = selector.getObject();
                        if (obj != null) {
                            HllSketchBuildUtil.updateSketch((HllSketch)sketch.get(), this.getStringEncoding(), obj);
                        }
                    };
                }
            }
        }
        return updater;
    }

    private static /* synthetic */ void lambda$formulateSketchUpdater$0(DimensionSelector selector, Supplier sketch) {
        IndexedInts row = selector.getRow();
        int sz = row.size();
        for (int i = 0; i < sz; ++i) {
            ByteBuffer buf = selector.lookupNameUtf8(row.get(i));
            if (buf == null) continue;
            ((HllSketch)sketch.get()).update(buf);
        }
    }
}

