/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.quantiles.DoublesSketch;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.SafeWritableMemory;

public class DoublesSketchOperations {
    public static final DoublesSketch EMPTY_SKETCH = DoublesSketch.builder().build();

    public static DoublesSketch deserialize(Object serializedSketch) {
        if (serializedSketch instanceof String) {
            return DoublesSketchOperations.deserializeFromBase64EncodedString((String)serializedSketch);
        }
        if (serializedSketch instanceof byte[]) {
            return DoublesSketchOperations.deserializeFromByteArray((byte[])serializedSketch);
        }
        if (serializedSketch instanceof DoublesSketch) {
            return (DoublesSketch)serializedSketch;
        }
        throw new ISE("Object is not of a type that can be deserialized to a quantiles DoublesSketch: %s", new Object[]{serializedSketch == null ? "null" : serializedSketch.getClass()});
    }

    public static DoublesSketch deserializeSafe(Object serializedSketch) {
        if (serializedSketch instanceof String) {
            return DoublesSketchOperations.deserializeFromBase64EncodedStringSafe((String)serializedSketch);
        }
        if (serializedSketch instanceof byte[]) {
            return DoublesSketchOperations.deserializeFromByteArraySafe((byte[])serializedSketch);
        }
        return DoublesSketchOperations.deserialize(serializedSketch);
    }

    public static DoublesSketch deserializeFromBase64EncodedString(String str) {
        return DoublesSketchOperations.deserializeFromByteArray(StringUtils.decodeBase64((byte[])str.getBytes(StandardCharsets.UTF_8)));
    }

    public static DoublesSketch deserializeFromByteArray(byte[] data) {
        return DoublesSketch.wrap((Memory)Memory.wrap((byte[])data));
    }

    public static DoublesSketch deserializeFromBase64EncodedStringSafe(String str) {
        return DoublesSketchOperations.deserializeFromByteArraySafe(StringUtils.decodeBase64((byte[])str.getBytes(StandardCharsets.UTF_8)));
    }

    public static DoublesSketch deserializeFromByteArraySafe(byte[] data) {
        return DoublesSketch.wrap((Memory)SafeWritableMemory.wrap((byte[])data));
    }
}

