/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.quantiles.sql;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchAggregatorFactory;
import org.apache.druid.query.aggregation.datasketches.quantiles.DoublesSketchToQuantilePostAggregator;
import org.apache.druid.query.aggregation.post.FieldAccessPostAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.Aggregations;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;

public class DoublesSketchApproxQuantileSqlAggregator
implements SqlAggregator {
    public static final String CTX_APPROX_QUANTILE_DS_MAX_STREAM_LENGTH = "approxQuantileDsMaxStreamLength";
    private static final String NAME = "APPROX_QUANTILE_DS";
    private static final SqlAggFunction FUNCTION_INSTANCE = (SqlAggFunction)OperatorConversions.aggregatorBuilder((String)"APPROX_QUANTILE_DS").operandNames(new String[]{"column", "probability", "k"}).operandTypes(new SqlTypeFamily[]{SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.EXACT_NUMERIC}).returnTypeNonNull(SqlTypeName.DOUBLE).requiredOperandCount(2).literalOperands(new int[]{1, 2}).functionCategory(SqlFunctionCategory.NUMERIC).build();

    public SqlAggFunction calciteFunction() {
        return FUNCTION_INSTANCE;
    }

    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        DoublesSketchAggregatorFactory aggregatorFactory;
        int k;
        DruidExpression input = Aggregations.toDruidExpressionForNumericAggregator((PlannerContext)plannerContext, (RowSignature)inputAccessor.getInputRowSignature(), (RexNode)inputAccessor.getField(((Integer)aggregateCall.getArgList().get(0)).intValue()));
        if (input == null) {
            return null;
        }
        String histogramName = StringUtils.format((String)"%s:agg", (Object[])new Object[]{name});
        RexNode probabilityArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(1)).intValue());
        if (!probabilityArg.isA(SqlKind.LITERAL)) {
            return null;
        }
        float probability = ((Number)((Object)RexLiteral.value((RexNode)probabilityArg))).floatValue();
        if (aggregateCall.getArgList().size() >= 3) {
            RexNode resolutionArg = inputAccessor.getField(((Integer)aggregateCall.getArgList().get(2)).intValue());
            if (!resolutionArg.isA(SqlKind.LITERAL)) {
                return null;
            }
            k = ((Number)((Object)RexLiteral.value((RexNode)resolutionArg))).intValue();
        } else {
            k = 128;
        }
        for (Aggregation existing : existingAggregations) {
            for (AggregatorFactory factory : existing.getAggregatorFactories()) {
                DoublesSketchAggregatorFactory theFactory;
                DruidExpression virtualInput;
                boolean inputMatches;
                boolean matches;
                if (!(factory instanceof DoublesSketchAggregatorFactory) || !(matches = (inputMatches = (virtualInput = (DruidExpression)virtualColumnRegistry.findVirtualColumnExpressions((theFactory = (DoublesSketchAggregatorFactory)factory).requiredFields()).stream().findFirst().orElse(null)) == null ? input.isDirectColumnAccess() && input.getDirectColumn().equals(theFactory.getFieldName()) : virtualInput.equals((Object)input)) && theFactory.getK() == k)) continue;
                return Aggregation.create((List)ImmutableList.of(), (PostAggregator)new DoublesSketchToQuantilePostAggregator(name, (PostAggregator)new FieldAccessPostAggregator(factory.getName(), factory.getName()), probability));
            }
        }
        if (input.isDirectColumnAccess()) {
            aggregatorFactory = new DoublesSketchAggregatorFactory(histogramName, input.getDirectColumn(), k, DoublesSketchApproxQuantileSqlAggregator.getMaxStreamLengthFromQueryContext(plannerContext.queryContext()), true);
        } else {
            String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(input, ColumnType.FLOAT);
            aggregatorFactory = new DoublesSketchAggregatorFactory(histogramName, virtualColumnName, k, DoublesSketchApproxQuantileSqlAggregator.getMaxStreamLengthFromQueryContext(plannerContext.queryContext()), true);
        }
        return Aggregation.create((List)ImmutableList.of((Object)((Object)aggregatorFactory)), (PostAggregator)new DoublesSketchToQuantilePostAggregator(name, (PostAggregator)new FieldAccessPostAggregator(histogramName, histogramName), probability));
    }

    static long getMaxStreamLengthFromQueryContext(QueryContext queryContext) {
        return queryContext.getLong(CTX_APPROX_QUANTILE_DS_MAX_STREAM_LENGTH, 1000000000L);
    }
}

