/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.tuple;

import java.nio.charset.StandardCharsets;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesAnotB;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesCombiner;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesIntersection;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSetOperationBuilder;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketch;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesSketches;
import org.apache.datasketches.tuple.arrayofdoubles.ArrayOfDoublesUnion;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.segment.data.SafeWritableMemory;

public class ArrayOfDoublesSketchOperations {
    private static ArrayOfDoublesCombiner COMBINER = new ArrayOfDoublesCombiner(){

        public double[] combine(double[] a, double[] b) {
            double[] result = new double[a.length];
            for (int i = 0; i < a.length; ++i) {
                result[i] = a[i] + b[i];
            }
            return result;
        }
    };

    public static ArrayOfDoublesSketch deserialize(Object serializedSketch) {
        if (serializedSketch instanceof String) {
            return ArrayOfDoublesSketchOperations.deserializeFromBase64EncodedString((String)serializedSketch);
        }
        if (serializedSketch instanceof byte[]) {
            return ArrayOfDoublesSketchOperations.deserializeFromByteArray((byte[])serializedSketch);
        }
        if (serializedSketch instanceof ArrayOfDoublesSketch) {
            return (ArrayOfDoublesSketch)serializedSketch;
        }
        throw new ISE("Object is not of a type that can deserialize to sketch: %s", new Object[]{serializedSketch.getClass()});
    }

    public static ArrayOfDoublesSketch deserializeSafe(Object serializedSketch) {
        if (serializedSketch instanceof String) {
            return ArrayOfDoublesSketchOperations.deserializeFromBase64EncodedStringSafe((String)serializedSketch);
        }
        if (serializedSketch instanceof byte[]) {
            return ArrayOfDoublesSketchOperations.deserializeFromByteArraySafe((byte[])serializedSketch);
        }
        return ArrayOfDoublesSketchOperations.deserialize(serializedSketch);
    }

    public static ArrayOfDoublesSketch deserializeFromBase64EncodedString(String str) {
        return ArrayOfDoublesSketchOperations.deserializeFromByteArray(StringUtils.decodeBase64((byte[])str.getBytes(StandardCharsets.UTF_8)));
    }

    public static ArrayOfDoublesSketch deserializeFromByteArray(byte[] data) {
        return ArrayOfDoublesSketches.wrapSketch((Memory)Memory.wrap((byte[])data));
    }

    public static ArrayOfDoublesSketch deserializeFromBase64EncodedStringSafe(String str) {
        return ArrayOfDoublesSketchOperations.deserializeFromByteArraySafe(StringUtils.decodeBase64((byte[])str.getBytes(StandardCharsets.UTF_8)));
    }

    public static ArrayOfDoublesSketch deserializeFromByteArraySafe(byte[] data) {
        return ArrayOfDoublesSketches.wrapSketch((Memory)SafeWritableMemory.wrap((byte[])data));
    }

    public static enum Operation {
        UNION{

            @Override
            public ArrayOfDoublesSketch apply(int nominalEntries, int numberOfValues, ArrayOfDoublesSketch[] sketches) {
                ArrayOfDoublesUnion union = new ArrayOfDoublesSetOperationBuilder().setNominalEntries(nominalEntries).setNumberOfValues(numberOfValues).buildUnion();
                for (ArrayOfDoublesSketch sketch : sketches) {
                    union.union(sketch);
                }
                return union.getResult();
            }
        }
        ,
        INTERSECT{

            @Override
            public ArrayOfDoublesSketch apply(int nominalEntries, int numberOfValues, ArrayOfDoublesSketch[] sketches) {
                ArrayOfDoublesIntersection intersection = new ArrayOfDoublesSetOperationBuilder().setNominalEntries(nominalEntries).setNumberOfValues(numberOfValues).buildIntersection();
                for (ArrayOfDoublesSketch sketch : sketches) {
                    intersection.intersect(sketch, COMBINER);
                }
                return intersection.getResult();
            }
        }
        ,
        NOT{

            @Override
            public ArrayOfDoublesSketch apply(int nominalEntries, int numberOfValues, ArrayOfDoublesSketch[] sketches) {
                if (sketches.length < 1) {
                    throw new IAE("A-Not-B requires at least 1 sketch", new Object[0]);
                }
                if (sketches.length == 1) {
                    return sketches[0];
                }
                ArrayOfDoublesSketch result = sketches[0];
                for (int i = 1; i < sketches.length; ++i) {
                    ArrayOfDoublesAnotB aNotB = new ArrayOfDoublesSetOperationBuilder().setNumberOfValues(numberOfValues).buildAnotB();
                    aNotB.update(result, sketches[i]);
                    result = aNotB.getResult();
                }
                return result;
            }
        };


        public abstract ArrayOfDoublesSketch apply(int var1, int var2, ArrayOfDoublesSketch[] var3);
    }
}

