/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.histogram;

import com.google.common.primitives.Longs;
import java.util.Comparator;
import javax.annotation.Nullable;
import org.apache.druid.query.aggregation.Aggregator;
import org.apache.druid.query.aggregation.histogram.FixedBucketsHistogram;
import org.apache.druid.segment.BaseObjectColumnValueSelector;
import org.apache.druid.segment.column.ColumnType;

public class FixedBucketsHistogramAggregator
implements Aggregator {
    public static final String TYPE_NAME = "fixedBucketsHistogram";
    public static final ColumnType TYPE = ColumnType.ofComplex((String)"fixedBucketsHistogram");
    public static final Comparator COMPARATOR = new Comparator(){

        public int compare(Object o, Object o1) {
            return Longs.compare((long)((FixedBucketsHistogram)o).getCount(), (long)((FixedBucketsHistogram)o1).getCount());
        }
    };
    private final BaseObjectColumnValueSelector selector;
    private FixedBucketsHistogram histogram;

    public FixedBucketsHistogramAggregator(BaseObjectColumnValueSelector selector, double lowerLimit, double upperLimit, int numBuckets, FixedBucketsHistogram.OutlierHandlingMode outlierHandlingMode) {
        this.selector = selector;
        this.histogram = new FixedBucketsHistogram(lowerLimit, upperLimit, numBuckets, outlierHandlingMode);
    }

    public void aggregate() {
        Object val = this.selector.getObject();
        this.histogram.combine(val);
    }

    @Nullable
    public Object get() {
        return this.histogram;
    }

    public float getFloat() {
        throw new UnsupportedOperationException("FixedBucketsHistogramAggregator does not support getFloat()");
    }

    public long getLong() {
        throw new UnsupportedOperationException("FixedBucketsHistogramAggregator does not support getLong()");
    }

    public double getDouble() {
        throw new UnsupportedOperationException("FixedBucketsHistogramAggregator does not support getDouble()");
    }

    public boolean isNull() {
        return false;
    }

    public void close() {
    }
}

