/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.rds.model.Metric;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class PerformanceIssueDetails
implements Serializable,
Cloneable {
    private Date startTime;
    private Date endTime;
    private SdkInternalList<Metric> metrics;
    private String analysis;

    public void setStartTime(Date startTime) {
        this.startTime = startTime;
    }

    public Date getStartTime() {
        return this.startTime;
    }

    public PerformanceIssueDetails withStartTime(Date startTime) {
        this.setStartTime(startTime);
        return this;
    }

    public void setEndTime(Date endTime) {
        this.endTime = endTime;
    }

    public Date getEndTime() {
        return this.endTime;
    }

    public PerformanceIssueDetails withEndTime(Date endTime) {
        this.setEndTime(endTime);
        return this;
    }

    public List<Metric> getMetrics() {
        if (this.metrics == null) {
            this.metrics = new SdkInternalList();
        }
        return this.metrics;
    }

    public void setMetrics(Collection<Metric> metrics) {
        if (metrics == null) {
            this.metrics = null;
            return;
        }
        this.metrics = new SdkInternalList(metrics);
    }

    public PerformanceIssueDetails withMetrics(Metric ... metrics) {
        if (this.metrics == null) {
            this.setMetrics((Collection<Metric>)new SdkInternalList(metrics.length));
        }
        for (Metric ele : metrics) {
            this.metrics.add((Object)ele);
        }
        return this;
    }

    public PerformanceIssueDetails withMetrics(Collection<Metric> metrics) {
        this.setMetrics(metrics);
        return this;
    }

    public void setAnalysis(String analysis) {
        this.analysis = analysis;
    }

    public String getAnalysis() {
        return this.analysis;
    }

    public PerformanceIssueDetails withAnalysis(String analysis) {
        this.setAnalysis(analysis);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getStartTime() != null) {
            sb.append("StartTime: ").append(this.getStartTime()).append(",");
        }
        if (this.getEndTime() != null) {
            sb.append("EndTime: ").append(this.getEndTime()).append(",");
        }
        if (this.getMetrics() != null) {
            sb.append("Metrics: ").append(this.getMetrics()).append(",");
        }
        if (this.getAnalysis() != null) {
            sb.append("Analysis: ").append(this.getAnalysis());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PerformanceIssueDetails)) {
            return false;
        }
        PerformanceIssueDetails other = (PerformanceIssueDetails)obj;
        if (other.getStartTime() == null ^ this.getStartTime() == null) {
            return false;
        }
        if (other.getStartTime() != null && !other.getStartTime().equals(this.getStartTime())) {
            return false;
        }
        if (other.getEndTime() == null ^ this.getEndTime() == null) {
            return false;
        }
        if (other.getEndTime() != null && !other.getEndTime().equals(this.getEndTime())) {
            return false;
        }
        if (other.getMetrics() == null ^ this.getMetrics() == null) {
            return false;
        }
        if (other.getMetrics() != null && !other.getMetrics().equals(this.getMetrics())) {
            return false;
        }
        if (other.getAnalysis() == null ^ this.getAnalysis() == null) {
            return false;
        }
        return other.getAnalysis() == null || other.getAnalysis().equals(this.getAnalysis());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getStartTime() == null ? 0 : this.getStartTime().hashCode());
        hashCode = 31 * hashCode + (this.getEndTime() == null ? 0 : this.getEndTime().hashCode());
        hashCode = 31 * hashCode + (this.getMetrics() == null ? 0 : this.getMetrics().hashCode());
        hashCode = 31 * hashCode + (this.getAnalysis() == null ? 0 : this.getAnalysis().hashCode());
        return hashCode;
    }

    public PerformanceIssueDetails clone() {
        try {
            return (PerformanceIssueDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

