/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.catalog.model.table;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.catalog.model.CatalogUtils;
import org.apache.druid.catalog.model.ColumnSpec;
import org.apache.druid.catalog.model.table.BaseInputSourceDefn;
import org.apache.druid.catalog.model.table.BaseTableFunction;
import org.apache.druid.catalog.model.table.ExternalTableSpec;
import org.apache.druid.catalog.model.table.FormattedInputSourceDefn;
import org.apache.druid.catalog.model.table.ResolvedExternalTable;
import org.apache.druid.catalog.model.table.TableFunction;
import org.apache.druid.data.input.InputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.s3.S3InputSource;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.utils.CollectionUtils;

public class S3InputSourceDefn
extends FormattedInputSourceDefn {
    public static final String TYPE_KEY = "s3";
    public static final String URIS_PARAMETER = "uris";
    public static final String PREFIXES_PARAMETER = "prefixes";
    public static final String BUCKET_PARAMETER = "bucket";
    public static final String PATHS_PARAMETER = "paths";
    public static final String ACCESS_KEY_ID_PARAMETER = "accessKeyId";
    public static final String SECRET_ACCESS_KEY_PARAMETER = "secretAccessKey";
    public static final String ASSUME_ROLE_ARN_PARAMETER = "assumeRoleArn";
    public static final String OBJECT_GLOB_PARAMETER = "objectGlob";
    public static final String BUCKET_PROPERTY = "bucket";
    private static final TableFunction.ParameterDefn URI_PARAM_DEFN = new BaseTableFunction.Parameter("uris", TableFunction.ParameterType.VARCHAR_ARRAY, true);
    private static final TableFunction.ParameterDefn PREFIXES_PARAM_DEFN = new BaseTableFunction.Parameter("prefixes", TableFunction.ParameterType.VARCHAR_ARRAY, true);
    private static final TableFunction.ParameterDefn BUCKET_PARAM_DEFN = new BaseTableFunction.Parameter("bucket", TableFunction.ParameterType.VARCHAR, true);
    private static final TableFunction.ParameterDefn PATHS_PARAM_DEFN = new BaseTableFunction.Parameter("paths", TableFunction.ParameterType.VARCHAR_ARRAY, true);
    private static final TableFunction.ParameterDefn OBJECT_GLOB_PARAM_DEFN = new BaseTableFunction.Parameter("objectGlob", TableFunction.ParameterType.VARCHAR, true);
    private static final List<TableFunction.ParameterDefn> SECURITY_PARAMS = Arrays.asList(new BaseTableFunction.Parameter("accessKeyId", TableFunction.ParameterType.VARCHAR, true), new BaseTableFunction.Parameter("secretAccessKey", TableFunction.ParameterType.VARCHAR, true), new BaseTableFunction.Parameter("assumeRoleArn", TableFunction.ParameterType.VARCHAR, true));
    private static final String URIS_FIELD = "uris";
    private static final String PREFIXES_FIELD = "prefixes";
    private static final String OBJECTS_FIELD = "objects";
    private static final String OBJECT_GLOB_FIELD = "objectGlob";
    private static final String PROPERTIES_FIELD = "properties";
    private static final String ACCESS_KEY_ID_FIELD = "accessKeyId";
    private static final String SECRET_ACCESS_KEY_FIELD = "secretAccessKey";
    private static final String ASSUME_ROLE_ARN_FIELD = "assumeRoleArn";

    public String typeValue() {
        return TYPE_KEY;
    }

    protected Class<? extends InputSource> inputSourceClass() {
        return S3InputSource.class;
    }

    public void validate(ResolvedExternalTable table) {
        boolean hasColumns;
        boolean hasFormat = table.inputFormatMap != null;
        boolean bl = hasColumns = !CollectionUtils.isNullOrEmpty((Collection)table.resolvedTable().spec().columns());
        if (hasFormat && !hasColumns) {
            throw new IAE("An external S3 table with a format must also provide the corresponding columns", new Object[0]);
        }
        String bucket = table.resolvedTable().stringProperty("bucket");
        boolean hasBucket = bucket != null;
        Map sourceMap = table.inputSourceMap;
        boolean hasUris = sourceMap.containsKey("uris");
        boolean hasPrefix = sourceMap.containsKey("prefixes");
        boolean hasObjects = sourceMap.containsKey(OBJECTS_FIELD);
        boolean hasGlob = sourceMap.containsKey("objectGlob");
        if (hasBucket) {
            if (hasUris || hasPrefix || hasObjects) {
                throw new IAE("Provide either the %s property, or one of the S3 input source fields %s, %s or %s, but not both.", new Object[]{"bucket", "uris", "prefixes", OBJECTS_FIELD});
            }
            if (hasGlob) {
                throw new IAE("The %s property cannot be provided when the %s property is set", new Object[]{"objectGlob", "bucket"});
            }
            sourceMap.put("uris", Collections.singletonList(bucket));
        }
        super.validate(table);
    }

    protected List<TableFunction.ParameterDefn> adHocTableFnParameters() {
        return CatalogUtils.concatLists(Arrays.asList(URI_PARAM_DEFN, PREFIXES_PARAM_DEFN, BUCKET_PARAM_DEFN, PATHS_PARAM_DEFN, OBJECT_GLOB_PARAM_DEFN), SECURITY_PARAMS);
    }

    protected void convertArgsToSourceMap(Map<String, Object> jsonMap, Map<String, Object> args) {
        boolean hasPaths;
        jsonMap.put("type", TYPE_KEY);
        List uris = CatalogUtils.getStringArray(args, (String)"uris");
        List prefixes = CatalogUtils.getStringArray(args, (String)"prefixes");
        String bucket = CatalogUtils.getNonBlankString(args, (String)"bucket");
        List paths = CatalogUtils.getStringArray(args, (String)PATHS_PARAMETER);
        String objectGlob = CatalogUtils.getNonBlankString(args, (String)"objectGlob");
        boolean hasUris = uris != null;
        boolean hasPrefixes = prefixes != null;
        boolean hasBucket = bucket != null;
        boolean bl = hasPaths = !CollectionUtils.isNullOrEmpty((Collection)paths);
        if (hasPaths && !hasBucket) {
            throw new IAE("S3 requires the %s parameter if %s is set", new Object[]{"bucket", PATHS_PARAMETER});
        }
        if (hasUris && (hasPrefixes || hasBucket) || hasPrefixes && hasBucket) {
            throw new IAE("S3 accepts only one of %s, %s or %s", new Object[]{PATHS_PARAMETER, "bucket", "prefixes"});
        }
        if (!(hasUris || hasPrefixes || hasBucket)) {
            throw new IAE("S3 requires one of %s, %s or %s", new Object[]{PATHS_PARAMETER, "bucket", "prefixes"});
        }
        if (hasUris) {
            jsonMap.put("uris", CatalogUtils.stringListToUriList((List)uris));
        }
        if (hasPrefixes) {
            jsonMap.put("prefixes", prefixes);
        }
        if (hasBucket) {
            if (!hasPaths) {
                throw new IAE("When using the %s parameter, %s must also be provided", new Object[]{"bucket", PATHS_PARAMETER});
            }
            ArrayList<CloudObjectLocation> objects = new ArrayList<CloudObjectLocation>();
            for (String obj : paths) {
                objects.add(new CloudObjectLocation(bucket, obj));
            }
            jsonMap.put(OBJECTS_FIELD, objects);
        }
        if (objectGlob != null) {
            jsonMap.put("objectGlob", objectGlob);
        }
        this.applySecurityParams(jsonMap, args);
    }

    private void applySecurityParams(Map<String, Object> jsonMap, Map<String, Object> args) {
        String accessKeyId = CatalogUtils.getNonBlankString(args, (String)"accessKeyId");
        String secretAccessKey = CatalogUtils.getNonBlankString(args, (String)"secretAccessKey");
        String assumeRoleArn = CatalogUtils.getNonBlankString(args, (String)"assumeRoleArn");
        if (accessKeyId != null || secretAccessKey != null || assumeRoleArn != null) {
            HashMap<String, String> properties = new HashMap<String, String>();
            if (accessKeyId != null) {
                properties.put("accessKeyId", accessKeyId);
            }
            if (secretAccessKey != null) {
                properties.put("secretAccessKey", secretAccessKey);
            }
            if (assumeRoleArn != null) {
                properties.put("assumeRoleArn", assumeRoleArn);
            }
            jsonMap.put(PROPERTIES_FIELD, properties);
        }
    }

    public TableFunction partialTableFn(ResolvedExternalTable table) {
        Map sourceMap = table.inputSourceMap;
        List<Object> params = new ArrayList<TableFunction.ParameterDefn>();
        if (table.resolvedTable().spec().properties().containsKey("bucket")) {
            params.add(PATHS_PARAM_DEFN);
        } else if (!sourceMap.containsKey("objectGlob")) {
            params.add(OBJECT_GLOB_PARAM_DEFN);
        }
        if (!sourceMap.containsKey(PROPERTIES_FIELD)) {
            params.addAll(SECURITY_PARAMS);
        }
        if (table.inputFormatMap == null) {
            params = this.addFormatParameters(params);
        }
        return new BaseInputSourceDefn.PartialTableFunction((BaseInputSourceDefn)this, table, params);
    }

    protected ExternalTableSpec convertCompletedTable(ResolvedExternalTable table, Map<String, Object> args, List<ColumnSpec> columns) {
        HashMap<String, Object> sourceMap = new HashMap<String, Object>(table.inputSourceMap);
        String bucket = table.resolvedTable().stringProperty("bucket");
        if (bucket != null) {
            List paths = CatalogUtils.getStringArray(args, (String)PATHS_PARAMETER);
            if (CollectionUtils.isNullOrEmpty((Collection)paths)) {
                throw new IAE("S3 external table defines the %s property. The table function must provide the %s parameter", new Object[]{"bucket", PATHS_PARAMETER});
            }
            ArrayList<CloudObjectLocation> objects = new ArrayList<CloudObjectLocation>();
            for (String obj : paths) {
                objects.add(new CloudObjectLocation(bucket, obj));
            }
            sourceMap.put(OBJECTS_FIELD, objects);
        }
        this.applySecurityParams(sourceMap, args);
        return this.convertPartialFormattedTable(table, args, columns, sourceMap);
    }
}

