/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Objects;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Map;
import org.apache.druid.guice.annotations.Json;
import org.apache.druid.segment.loading.DataSegmentArchiver;
import org.apache.druid.segment.loading.LoadSpec;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.storage.s3.S3DataSegmentArchiverConfig;
import org.apache.druid.storage.s3.S3DataSegmentMover;
import org.apache.druid.storage.s3.S3DataSegmentPusherConfig;
import org.apache.druid.storage.s3.S3LoadSpec;
import org.apache.druid.storage.s3.ServerSideEncryptingAmazonS3;
import org.apache.druid.timeline.DataSegment;

public class S3DataSegmentArchiver
extends S3DataSegmentMover
implements DataSegmentArchiver {
    private final S3DataSegmentArchiverConfig archiveConfig;
    private final S3DataSegmentPusherConfig restoreConfig;
    private final ObjectMapper mapper;

    @Inject
    public S3DataSegmentArchiver(@Json ObjectMapper mapper, Supplier<ServerSideEncryptingAmazonS3> s3Client, S3DataSegmentArchiverConfig archiveConfig, S3DataSegmentPusherConfig restoreConfig) {
        super(s3Client, restoreConfig);
        this.mapper = mapper;
        this.archiveConfig = archiveConfig;
        this.restoreConfig = restoreConfig;
    }

    public DataSegment archive(DataSegment segment) throws SegmentLoadingException {
        String targetS3BaseKey;
        String targetS3Bucket = this.archiveConfig.getArchiveBucket();
        DataSegment archived = this.move(segment, (Map<String, Object>)ImmutableMap.of((Object)"bucket", (Object)targetS3Bucket, (Object)"baseKey", (Object)(targetS3BaseKey = this.archiveConfig.getArchiveBaseKey())));
        if (this.sameLoadSpec(segment, archived)) {
            return null;
        }
        return archived;
    }

    public DataSegment restore(DataSegment segment) throws SegmentLoadingException {
        String targetS3BaseKey;
        String targetS3Bucket = this.restoreConfig.getBucket();
        DataSegment restored = this.move(segment, (Map<String, Object>)ImmutableMap.of((Object)"bucket", (Object)targetS3Bucket, (Object)"baseKey", (Object)(targetS3BaseKey = this.restoreConfig.getBaseKey())));
        if (this.sameLoadSpec(segment, restored)) {
            return null;
        }
        return restored;
    }

    boolean sameLoadSpec(DataSegment s1, DataSegment s2) {
        S3LoadSpec s1LoadSpec = (S3LoadSpec)this.mapper.convertValue((Object)s1.getLoadSpec(), LoadSpec.class);
        S3LoadSpec s2LoadSpec = (S3LoadSpec)this.mapper.convertValue((Object)s2.getLoadSpec(), LoadSpec.class);
        return Objects.equal((Object)s1LoadSpec.getBucket(), (Object)s2LoadSpec.getBucket()) && Objects.equal((Object)s1LoadSpec.getKey(), (Object)s2LoadSpec.getKey());
    }
}

