/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.s3;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.apache.druid.java.util.common.IAE;

public class S3InputDataConfig {
    @VisibleForTesting
    static final int MAX_LISTING_LENGTH_MIN = 1;
    @VisibleForTesting
    static final int MAX_LISTING_LENGTH_MAX = 1000;
    @JsonProperty
    @Min(value=1L)
    @Max(value=1000L)
    private @Min(value=1L) @Max(value=1000L) int maxListingLength = 1000;

    @VisibleForTesting
    public void setMaxListingLength(int maxListingLength) {
        if (maxListingLength < 1 || maxListingLength > 1000) {
            throw new IAE("valid values for maxListingLength are between [%d, %d]", new Object[]{1, 1000});
        }
        this.maxListingLength = maxListingLength;
    }

    public int getMaxListingLength() {
        return this.maxListingLength;
    }
}

