/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.apimachinery;

import io.kubernetes.client.apimachinery.GroupVersionResource;
import io.kubernetes.client.apimachinery.ParseKubernetesResourceException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KubernetesResource {
    public static final Pattern CORE_RESOURCE_URL_PATH_PATTERN = Pattern.compile("^/api/v1(/namespaces/(?<namespace>[\\w-]+))?/(?<resource>[\\w-]+)(/(?<name>[\\w-]+))?(/(?<subresource>[\\w-]+))?");
    public static final Pattern REGULAR_RESOURCE_URL_PATH_PATTERN = Pattern.compile("^/apis/(?<group>\\S+?)/(?<version>\\S+?)(/namespaces/(?<namespace>[\\w-]+))?/(?<resource>[\\w-]+)(/(?<name>[\\w-]+))?(/(?<subresource>[\\w-]+))?");
    private final GroupVersionResource groupVersionResource;
    private final String subResource;
    private final String namespace;
    private final String name;

    public static KubernetesResource parseCoreResource(String urlPath) throws ParseKubernetesResourceException {
        Matcher matcher = CORE_RESOURCE_URL_PATH_PATTERN.matcher(urlPath);
        if (!matcher.matches()) {
            throw new ParseKubernetesResourceException();
        }
        KubernetesResource resource = new KubernetesResource(new GroupVersionResource("", "v1", matcher.group("resource")), matcher.group("subresource"), matcher.group("namespace"), matcher.group("name"));
        return resource;
    }

    public static KubernetesResource parseRegularResource(String urlPath) throws ParseKubernetesResourceException {
        Matcher matcher = REGULAR_RESOURCE_URL_PATH_PATTERN.matcher(urlPath);
        if (!matcher.matches()) {
            throw new ParseKubernetesResourceException();
        }
        KubernetesResource resource = new KubernetesResource(new GroupVersionResource(matcher.group("group"), matcher.group("version"), matcher.group("resource")), matcher.group("subresource"), matcher.group("namespace"), matcher.group("name"));
        return resource;
    }

    KubernetesResource(GroupVersionResource gvr, String subResource, String namespace, String name) {
        this.groupVersionResource = gvr;
        this.subResource = subResource;
        this.namespace = namespace;
        this.name = name;
    }

    public GroupVersionResource getGroupVersionResource() {
        return this.groupVersionResource;
    }

    public String getSubResource() {
        return this.subResource;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getName() {
        return this.name;
    }
}

