/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.storage.azure.output;

import com.azure.storage.blob.batch.BlobBatchStorageException;
import com.azure.storage.blob.models.BlobStorageException;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.druid.data.input.impl.prefetch.ObjectOpenFunction;
import org.apache.druid.storage.azure.AzureStorage;
import org.apache.druid.storage.azure.AzureUtils;
import org.apache.druid.storage.azure.output.AzureInputRange;
import org.apache.druid.storage.azure.output.AzureOutputConfig;
import org.apache.druid.storage.remote.ChunkingStorageConnector;
import org.apache.druid.storage.remote.ChunkingStorageConnectorParameters;

public class AzureStorageConnector
extends ChunkingStorageConnector<AzureInputRange> {
    private static final String DELIM = "/";
    private static final Joiner JOINER = Joiner.on((String)"/").skipNulls();
    private final AzureOutputConfig config;
    private final AzureStorage azureStorage;

    public AzureStorageConnector(AzureOutputConfig config, AzureStorage azureStorage) {
        this.config = config;
        this.azureStorage = azureStorage;
    }

    public ChunkingStorageConnectorParameters<AzureInputRange> buildInputParams(String path) throws IOException {
        try {
            return this.buildInputParams(path, 0L, this.azureStorage.getBlockBlobLength(this.config.getContainer(), this.objectPath(path)));
        }
        catch (BlobStorageException e) {
            throw new IOException(e);
        }
    }

    public ChunkingStorageConnectorParameters<AzureInputRange> buildInputParams(String path, long from, long size) {
        ChunkingStorageConnectorParameters.Builder parameters = new ChunkingStorageConnectorParameters.Builder();
        parameters.tempDirSupplier(this.config::getTempDir);
        parameters.maxRetry(this.config.getMaxRetry());
        parameters.cloudStoragePath(this.objectPath(path));
        parameters.retryCondition(AzureUtils.AZURE_RETRY);
        parameters.start(from);
        parameters.end(from + size);
        parameters.objectSupplier((start, end) -> new AzureInputRange(start, end - start, this.config.getContainer(), this.objectPath(path)));
        parameters.objectOpenFunction((ObjectOpenFunction)new ObjectOpenFunction<AzureInputRange>(){

            public InputStream open(AzureInputRange inputRange) throws IOException {
                try {
                    return AzureStorageConnector.this.azureStorage.getBlockBlobInputStream(inputRange.getStart(), inputRange.getSize(), inputRange.getContainer(), inputRange.getPath(), AzureStorageConnector.this.config.getMaxRetry());
                }
                catch (BlobStorageException e) {
                    throw new IOException(e);
                }
            }

            public InputStream open(AzureInputRange inputRange, long offset) throws IOException {
                AzureInputRange newInputRange = new AzureInputRange(inputRange.getStart() + offset, Math.max(inputRange.getSize() - offset, 0L), inputRange.getContainer(), inputRange.getPath());
                return this.open(newInputRange);
            }
        });
        return parameters.build();
    }

    public boolean pathExists(String path) throws IOException {
        try {
            return this.azureStorage.getBlockBlobExists(this.config.getContainer(), this.objectPath(path), this.config.getMaxRetry());
        }
        catch (BlobStorageException e) {
            throw new IOException(e);
        }
    }

    public OutputStream write(String path) throws IOException {
        try {
            return this.azureStorage.getBlockBlobOutputStream(this.config.getContainer(), this.objectPath(path), this.config.getChunkSize().getBytes(), this.config.getMaxRetry());
        }
        catch (BlobStorageException e) {
            throw new IOException(e);
        }
    }

    public void deleteFile(String path) throws IOException {
        try {
            this.azureStorage.batchDeleteFiles(this.config.getContainer(), Collections.singletonList(this.objectPath(path)), this.config.getMaxRetry());
        }
        catch (BlobBatchStorageException | BlobStorageException e) {
            throw new IOException(e);
        }
    }

    public void deleteFiles(Iterable<String> paths) throws IOException {
        try {
            this.azureStorage.batchDeleteFiles(this.config.getContainer(), Iterables.transform(paths, this::objectPath), this.config.getMaxRetry());
        }
        catch (BlobBatchStorageException | BlobStorageException e) {
            throw new IOException(e);
        }
    }

    public void deleteRecursively(String path) throws IOException {
        try {
            this.azureStorage.emptyCloudBlobDirectory(this.config.getContainer(), this.objectPath(path), this.config.getMaxRetry());
        }
        catch (BlobStorageException e) {
            throw new IOException(e);
        }
    }

    public Iterator<String> listDir(String dirName) throws IOException {
        List<String> paths;
        String prefixBasePath = this.objectPath(dirName);
        try {
            paths = this.azureStorage.listBlobs(this.config.getContainer(), prefixBasePath, null, this.config.getMaxRetry());
        }
        catch (BlobStorageException e) {
            throw new IOException(e);
        }
        return paths.stream().map(path -> {
            String[] size = path.split(prefixBasePath, 2);
            if (size.length > 1) {
                return size[1];
            }
            return "";
        }).iterator();
    }

    private String objectPath(String path) {
        return JOINER.join((Object)this.config.getPrefix(), (Object)path, new Object[0]);
    }
}

