/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveStringMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveURLRecursiveMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseInsensitiveURLRecursiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveURLRecursiveMatcher;
import org.apache.ranger.plugin.resourcematcher.CaseSensitiveURLRecursiveWildcardMatcher;
import org.apache.ranger.plugin.resourcematcher.RangerDefaultResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcher;
import org.apache.ranger.plugin.resourcematcher.ResourceMatcherWrapper;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerURLResourceMatcher
extends RangerDefaultResourceMatcher {
    private static final Logger LOG = LoggerFactory.getLogger(RangerURLResourceMatcher.class);
    public static final String OPTION_PATH_SEPARATOR = "pathSeparatorChar";
    public static final char DEFAULT_PATH_SEPARATOR_CHAR = '/';
    boolean policyIsRecursive;
    char pathSeparatorChar = (char)47;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerURLResourceMatcher.init()");
        }
        Map<String, String> options = this.resourceDef == null ? null : this.resourceDef.getMatcherOptions();
        this.policyIsRecursive = this.policyResource != null && this.policyResource.getIsRecursive() != false;
        this.pathSeparatorChar = ServiceDefUtil.getCharOption(options, OPTION_PATH_SEPARATOR, '/');
        super.init();
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerURLResourceMatcher.init()");
        }
    }

    @Override
    protected ResourceMatcherWrapper buildResourceMatchers() {
        ArrayList<ResourceMatcher> resourceMatchers = new ArrayList<ResourceMatcher>();
        boolean needsDynamicEval = false;
        for (String policyValue : this.policyValues) {
            ResourceMatcher matcher;
            if (this.optWildCard && this.policyIsRecursive && policyValue.charAt(policyValue.length() - 1) == this.pathSeparatorChar) {
                policyValue = policyValue + "*";
            }
            if ((matcher = this.getMatcher(policyValue)) == null) continue;
            if (matcher.isMatchAny()) {
                resourceMatchers.clear();
                break;
            }
            if (!needsDynamicEval && matcher.getNeedsDynamicEval()) {
                needsDynamicEval = true;
            }
            resourceMatchers.add(matcher);
        }
        Collections.sort(resourceMatchers, new ResourceMatcher.PriorityComparator());
        return CollectionUtils.isNotEmpty(resourceMatchers) ? new ResourceMatcherWrapper(needsDynamicEval, resourceMatchers) : null;
    }

    @Override
    ResourceMatcher getMatcher(String policyValue) {
        ResourceMatcher ret;
        int len;
        if (!this.policyIsRecursive) {
            return super.getMatcher(policyValue);
        }
        int n = len = policyValue != null ? policyValue.length() : 0;
        if (len == 0) {
            return null;
        }
        if (this.optWildCard && "*".equals(policyValue)) {
            return new CaseInsensitiveStringMatcher("", this.getOptions());
        }
        boolean isWildcardPresent = false;
        if (this.optWildCard) {
            for (int i = 0; i < len; ++i) {
                char c = policyValue.charAt(i);
                if (c != '?' && c != '*') continue;
                isWildcardPresent = true;
                break;
            }
        }
        if (isWildcardPresent) {
            ret = this.optIgnoreCase ? new CaseInsensitiveURLRecursiveWildcardMatcher(policyValue, this.getOptions(), this.pathSeparatorChar) : new CaseSensitiveURLRecursiveWildcardMatcher(policyValue, this.getOptions(), this.pathSeparatorChar);
        } else {
            ResourceMatcher resourceMatcher = ret = this.optIgnoreCase ? new CaseInsensitiveURLRecursiveMatcher(policyValue, this.getOptions(), this.pathSeparatorChar) : new CaseSensitiveURLRecursiveMatcher(policyValue, this.getOptions(), this.pathSeparatorChar);
        }
        if (this.optReplaceTokens) {
            ret.setDelimiters(this.startDelimiterChar, this.endDelimiterChar, this.escapeChar, this.tokenPrefix);
        }
        return ret;
    }

    static boolean isRecursiveWildCardMatch(String pathToCheck, String wildcardPath, char pathSeparatorChar, IOCase caseSensitivity) {
        boolean ret = false;
        String url = StringUtils.trim((String)pathToCheck);
        if (!StringUtils.isEmpty((String)url) && RangerURLResourceMatcher.isPathURLType(url)) {
            String scheme = RangerURLResourceMatcher.getScheme(url);
            if (StringUtils.isEmpty((String)scheme)) {
                return ret;
            }
            String path = RangerURLResourceMatcher.getPathWithOutScheme(url);
            Object[] pathElements = StringUtils.split((String)path, (char)pathSeparatorChar);
            if (!ArrayUtils.isEmpty((Object[])pathElements)) {
                StringBuilder sb = new StringBuilder();
                sb.append(scheme);
                if (pathToCheck.charAt(0) == pathSeparatorChar) {
                    sb.append(pathSeparatorChar);
                }
                for (Object p : pathElements) {
                    sb.append((String)p);
                    ret = FilenameUtils.wildcardMatch((String)sb.toString(), (String)wildcardPath, (IOCase)caseSensitivity);
                    if (ret) break;
                    sb.append(pathSeparatorChar);
                }
                if (!ret) {
                    boolean isEndsWithPathSeparator = url.endsWith(Character.toString(pathSeparatorChar));
                    if (!isEndsWithPathSeparator) {
                        sb.deleteCharAt(sb.length() - 1);
                    }
                    ret = FilenameUtils.wildcardMatch((String)sb.toString(), (String)wildcardPath, (IOCase)caseSensitivity);
                }
                sb = null;
            } else {
                ret = FilenameUtils.wildcardMatch((String)pathToCheck, (String)wildcardPath, (IOCase)caseSensitivity);
            }
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerURLResourceMatcher={");
        super.toString(sb);
        sb.append("policyIsRecursive={").append(this.policyIsRecursive).append("} ");
        sb.append("}");
        return sb;
    }

    static boolean isPathURLType(String url) {
        boolean ret = false;
        if (url != null) {
            Pattern p1 = Pattern.compile(":/{2}");
            Matcher m1 = p1.matcher(url);
            Pattern p2 = Pattern.compile(":/{3,}");
            Matcher m2 = p2.matcher(url);
            ret = m1.find() && !m2.find();
        }
        return ret;
    }

    static String getScheme(String url) {
        return StringUtils.substring((String)url, (int)0, (int)(StringUtils.indexOf((String)url, (String)":") + 3));
    }

    static String getPathWithOutScheme(String url) {
        return StringUtils.substring((String)url, (int)(StringUtils.indexOf((String)url, (String)":") + 2));
    }
}

