/*
 * Decompiled with CFR 0.152.
 */
package net.thisptr.jackson.jq.internal.operators;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.TreeSet;
import net.thisptr.jackson.jq.exception.JsonQueryException;
import net.thisptr.jackson.jq.exception.JsonQueryTypeException;
import net.thisptr.jackson.jq.internal.misc.JsonNodeComparator;
import net.thisptr.jackson.jq.internal.misc.JsonNodeUtils;
import net.thisptr.jackson.jq.internal.operators.BinaryOperator;

public class MinusOperator
implements BinaryOperator {
    private static final JsonNodeComparator comparator = JsonNodeComparator.getInstance();

    @Override
    public JsonNode apply(ObjectMapper mapper, JsonNode lhs, JsonNode rhs) throws JsonQueryException {
        if (lhs.isIntegralNumber() && rhs.isIntegralNumber()) {
            long r = lhs.asLong() - rhs.asLong();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isNumber() && rhs.isNumber()) {
            double r = lhs.asDouble() - rhs.asDouble();
            return JsonNodeUtils.asNumericNode(r);
        }
        if (lhs.isArray() && rhs.isArray()) {
            ArrayNode result = mapper.createArrayNode();
            TreeSet<JsonNode> rset = new TreeSet<JsonNode>(comparator);
            for (JsonNode r : rhs) {
                rset.add(r);
            }
            for (JsonNode l : lhs) {
                if (rset.contains(l)) continue;
                result.add(l);
            }
            return result;
        }
        throw new JsonQueryTypeException(lhs, rhs, "cannot be subtracted");
    }

    @Override
    public String image() {
        return "-";
    }
}

