/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1AggregationRule;
import io.kubernetes.client.openapi.models.V1AggregationRuleFluent;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1AggregationRuleFluentImpl<A extends V1AggregationRuleFluent<A>>
extends BaseFluent<A>
implements V1AggregationRuleFluent<A> {
    private ArrayList<V1LabelSelectorBuilder> clusterRoleSelectors;

    public V1AggregationRuleFluentImpl() {
    }

    public V1AggregationRuleFluentImpl(V1AggregationRule instance) {
        if (instance != null) {
            this.withClusterRoleSelectors(instance.getClusterRoleSelectors());
        }
    }

    @Override
    public A addToClusterRoleSelectors(int index, V1LabelSelector item) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
        if (index < 0 || index >= this.clusterRoleSelectors.size()) {
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        } else {
            this._visitables.get("clusterRoleSelectors").add(index, builder);
            this.clusterRoleSelectors.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToClusterRoleSelectors(int index, V1LabelSelector item) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
        if (index < 0 || index >= this.clusterRoleSelectors.size()) {
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        } else {
            this._visitables.get("clusterRoleSelectors").set(index, builder);
            this.clusterRoleSelectors.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToClusterRoleSelectors(V1LabelSelector ... items) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToClusterRoleSelectors(Collection<V1LabelSelector> items) {
        if (this.clusterRoleSelectors == null) {
            this.clusterRoleSelectors = new ArrayList();
        }
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").add(builder);
            this.clusterRoleSelectors.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromClusterRoleSelectors(V1LabelSelector ... items) {
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").remove(builder);
            if (this.clusterRoleSelectors == null) continue;
            this.clusterRoleSelectors.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromClusterRoleSelectors(Collection<V1LabelSelector> items) {
        for (V1LabelSelector item : items) {
            V1LabelSelectorBuilder builder = new V1LabelSelectorBuilder(item);
            this._visitables.get("clusterRoleSelectors").remove(builder);
            if (this.clusterRoleSelectors == null) continue;
            this.clusterRoleSelectors.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromClusterRoleSelectors(Predicate<V1LabelSelectorBuilder> predicate) {
        if (this.clusterRoleSelectors == null) {
            return (A)this;
        }
        Iterator<V1LabelSelectorBuilder> each = this.clusterRoleSelectors.iterator();
        Object visitables = this._visitables.get("clusterRoleSelectors");
        while (each.hasNext()) {
            V1LabelSelectorBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1LabelSelector> getClusterRoleSelectors() {
        return this.clusterRoleSelectors != null ? V1AggregationRuleFluentImpl.build(this.clusterRoleSelectors) : null;
    }

    @Override
    public List<V1LabelSelector> buildClusterRoleSelectors() {
        return this.clusterRoleSelectors != null ? V1AggregationRuleFluentImpl.build(this.clusterRoleSelectors) : null;
    }

    @Override
    public V1LabelSelector buildClusterRoleSelector(int index) {
        return this.clusterRoleSelectors.get(index).build();
    }

    @Override
    public V1LabelSelector buildFirstClusterRoleSelector() {
        return this.clusterRoleSelectors.get(0).build();
    }

    @Override
    public V1LabelSelector buildLastClusterRoleSelector() {
        return this.clusterRoleSelectors.get(this.clusterRoleSelectors.size() - 1).build();
    }

    @Override
    public V1LabelSelector buildMatchingClusterRoleSelector(Predicate<V1LabelSelectorBuilder> predicate) {
        for (V1LabelSelectorBuilder item : this.clusterRoleSelectors) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingClusterRoleSelector(Predicate<V1LabelSelectorBuilder> predicate) {
        for (V1LabelSelectorBuilder item : this.clusterRoleSelectors) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withClusterRoleSelectors(List<V1LabelSelector> clusterRoleSelectors) {
        if (this.clusterRoleSelectors != null) {
            this._visitables.get("clusterRoleSelectors").clear();
        }
        if (clusterRoleSelectors != null) {
            this.clusterRoleSelectors = new ArrayList();
            for (V1LabelSelector item : clusterRoleSelectors) {
                this.addToClusterRoleSelectors(item);
            }
        } else {
            this.clusterRoleSelectors = null;
        }
        return (A)this;
    }

    @Override
    public A withClusterRoleSelectors(V1LabelSelector ... clusterRoleSelectors) {
        if (this.clusterRoleSelectors != null) {
            this.clusterRoleSelectors.clear();
            this._visitables.remove("clusterRoleSelectors");
        }
        if (clusterRoleSelectors != null) {
            for (V1LabelSelector item : clusterRoleSelectors) {
                this.addToClusterRoleSelectors(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasClusterRoleSelectors() {
        return this.clusterRoleSelectors != null && !this.clusterRoleSelectors.isEmpty();
    }

    @Override
    public V1AggregationRuleFluent.ClusterRoleSelectorsNested<A> addNewClusterRoleSelector() {
        return new ClusterRoleSelectorsNestedImpl();
    }

    @Override
    public V1AggregationRuleFluent.ClusterRoleSelectorsNested<A> addNewClusterRoleSelectorLike(V1LabelSelector item) {
        return new ClusterRoleSelectorsNestedImpl(-1, item);
    }

    @Override
    public V1AggregationRuleFluent.ClusterRoleSelectorsNested<A> setNewClusterRoleSelectorLike(int index, V1LabelSelector item) {
        return new ClusterRoleSelectorsNestedImpl(index, item);
    }

    @Override
    public V1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editClusterRoleSelector(int index) {
        if (this.clusterRoleSelectors.size() <= index) {
            throw new RuntimeException("Can't edit clusterRoleSelectors. Index exceeds size.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    @Override
    public V1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editFirstClusterRoleSelector() {
        if (this.clusterRoleSelectors.size() == 0) {
            throw new RuntimeException("Can't edit first clusterRoleSelectors. The list is empty.");
        }
        return this.setNewClusterRoleSelectorLike(0, this.buildClusterRoleSelector(0));
    }

    @Override
    public V1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editLastClusterRoleSelector() {
        int index = this.clusterRoleSelectors.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last clusterRoleSelectors. The list is empty.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    @Override
    public V1AggregationRuleFluent.ClusterRoleSelectorsNested<A> editMatchingClusterRoleSelector(Predicate<V1LabelSelectorBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.clusterRoleSelectors.size(); ++i) {
            if (!predicate.test(this.clusterRoleSelectors.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching clusterRoleSelectors. No match found.");
        }
        return this.setNewClusterRoleSelectorLike(index, this.buildClusterRoleSelector(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1AggregationRuleFluentImpl that = (V1AggregationRuleFluentImpl)o;
        return Objects.equals(this.clusterRoleSelectors, that.clusterRoleSelectors);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.clusterRoleSelectors, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.clusterRoleSelectors != null) {
            sb.append("clusterRoleSelectors:");
            sb.append(this.clusterRoleSelectors);
        }
        sb.append("}");
        return sb.toString();
    }

    class ClusterRoleSelectorsNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1AggregationRuleFluent.ClusterRoleSelectorsNested<N>>
    implements V1AggregationRuleFluent.ClusterRoleSelectorsNested<N>,
    Nested<N> {
        V1LabelSelectorBuilder builder;
        int index;

        ClusterRoleSelectorsNestedImpl(int index, V1LabelSelector item) {
            this.index = index;
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        ClusterRoleSelectorsNestedImpl() {
            this.index = -1;
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1AggregationRuleFluentImpl.this.setToClusterRoleSelectors(this.index, this.builder.build());
        }

        @Override
        public N endClusterRoleSelector() {
            return this.and();
        }
    }
}

