/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngress;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngressBuilder;
import io.kubernetes.client.openapi.models.V1LoadBalancerIngressFluentImpl;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatus;
import io.kubernetes.client.openapi.models.V1LoadBalancerStatusFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1LoadBalancerStatusFluentImpl<A extends V1LoadBalancerStatusFluent<A>>
extends BaseFluent<A>
implements V1LoadBalancerStatusFluent<A> {
    private ArrayList<V1LoadBalancerIngressBuilder> ingress;

    public V1LoadBalancerStatusFluentImpl() {
    }

    public V1LoadBalancerStatusFluentImpl(V1LoadBalancerStatus instance) {
        if (instance != null) {
            this.withIngress(instance.getIngress());
        }
    }

    @Override
    public A addToIngress(int index, V1LoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").add(index, builder);
            this.ingress.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToIngress(int index, V1LoadBalancerIngress item) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
        if (index < 0 || index >= this.ingress.size()) {
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        } else {
            this._visitables.get("ingress").set(index, builder);
            this.ingress.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToIngress(V1LoadBalancerIngress ... items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1LoadBalancerIngress item : items) {
            V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToIngress(Collection<V1LoadBalancerIngress> items) {
        if (this.ingress == null) {
            this.ingress = new ArrayList();
        }
        for (V1LoadBalancerIngress item : items) {
            V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").add(builder);
            this.ingress.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromIngress(V1LoadBalancerIngress ... items) {
        for (V1LoadBalancerIngress item : items) {
            V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromIngress(Collection<V1LoadBalancerIngress> items) {
        for (V1LoadBalancerIngress item : items) {
            V1LoadBalancerIngressBuilder builder = new V1LoadBalancerIngressBuilder(item);
            this._visitables.get("ingress").remove(builder);
            if (this.ingress == null) continue;
            this.ingress.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromIngress(Predicate<V1LoadBalancerIngressBuilder> predicate) {
        if (this.ingress == null) {
            return (A)this;
        }
        Iterator<V1LoadBalancerIngressBuilder> each = this.ingress.iterator();
        Object visitables = this._visitables.get("ingress");
        while (each.hasNext()) {
            V1LoadBalancerIngressBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1LoadBalancerIngress> getIngress() {
        return this.ingress != null ? V1LoadBalancerStatusFluentImpl.build(this.ingress) : null;
    }

    @Override
    public List<V1LoadBalancerIngress> buildIngress() {
        return this.ingress != null ? V1LoadBalancerStatusFluentImpl.build(this.ingress) : null;
    }

    @Override
    public V1LoadBalancerIngress buildIngress(int index) {
        return this.ingress.get(index).build();
    }

    @Override
    public V1LoadBalancerIngress buildFirstIngress() {
        return this.ingress.get(0).build();
    }

    @Override
    public V1LoadBalancerIngress buildLastIngress() {
        return this.ingress.get(this.ingress.size() - 1).build();
    }

    @Override
    public V1LoadBalancerIngress buildMatchingIngress(Predicate<V1LoadBalancerIngressBuilder> predicate) {
        for (V1LoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingIngress(Predicate<V1LoadBalancerIngressBuilder> predicate) {
        for (V1LoadBalancerIngressBuilder item : this.ingress) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withIngress(List<V1LoadBalancerIngress> ingress) {
        if (this.ingress != null) {
            this._visitables.get("ingress").clear();
        }
        if (ingress != null) {
            this.ingress = new ArrayList();
            for (V1LoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        } else {
            this.ingress = null;
        }
        return (A)this;
    }

    @Override
    public A withIngress(V1LoadBalancerIngress ... ingress) {
        if (this.ingress != null) {
            this.ingress.clear();
            this._visitables.remove("ingress");
        }
        if (ingress != null) {
            for (V1LoadBalancerIngress item : ingress) {
                this.addToIngress(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasIngress() {
        return this.ingress != null && !this.ingress.isEmpty();
    }

    @Override
    public V1LoadBalancerStatusFluent.IngressNested<A> addNewIngress() {
        return new IngressNestedImpl();
    }

    @Override
    public V1LoadBalancerStatusFluent.IngressNested<A> addNewIngressLike(V1LoadBalancerIngress item) {
        return new IngressNestedImpl(-1, item);
    }

    @Override
    public V1LoadBalancerStatusFluent.IngressNested<A> setNewIngressLike(int index, V1LoadBalancerIngress item) {
        return new IngressNestedImpl(index, item);
    }

    @Override
    public V1LoadBalancerStatusFluent.IngressNested<A> editIngress(int index) {
        if (this.ingress.size() <= index) {
            throw new RuntimeException("Can't edit ingress. Index exceeds size.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public V1LoadBalancerStatusFluent.IngressNested<A> editFirstIngress() {
        if (this.ingress.size() == 0) {
            throw new RuntimeException("Can't edit first ingress. The list is empty.");
        }
        return this.setNewIngressLike(0, this.buildIngress(0));
    }

    @Override
    public V1LoadBalancerStatusFluent.IngressNested<A> editLastIngress() {
        int index = this.ingress.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last ingress. The list is empty.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public V1LoadBalancerStatusFluent.IngressNested<A> editMatchingIngress(Predicate<V1LoadBalancerIngressBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.ingress.size(); ++i) {
            if (!predicate.test(this.ingress.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching ingress. No match found.");
        }
        return this.setNewIngressLike(index, this.buildIngress(index));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1LoadBalancerStatusFluentImpl that = (V1LoadBalancerStatusFluentImpl)o;
        return Objects.equals(this.ingress, that.ingress);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ingress, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.ingress != null) {
            sb.append("ingress:");
            sb.append(this.ingress);
        }
        sb.append("}");
        return sb.toString();
    }

    class IngressNestedImpl<N>
    extends V1LoadBalancerIngressFluentImpl<V1LoadBalancerStatusFluent.IngressNested<N>>
    implements V1LoadBalancerStatusFluent.IngressNested<N>,
    Nested<N> {
        V1LoadBalancerIngressBuilder builder;
        int index;

        IngressNestedImpl(int index, V1LoadBalancerIngress item) {
            this.index = index;
            this.builder = new V1LoadBalancerIngressBuilder(this, item);
        }

        IngressNestedImpl() {
            this.index = -1;
            this.builder = new V1LoadBalancerIngressBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1LoadBalancerStatusFluentImpl.this.setToIngress(this.index, this.builder.build());
        }

        @Override
        public N endIngress() {
            return this.and();
        }
    }
}

