/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.custom.IntOrString;
import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.openapi.models.V1ServicePort;
import io.kubernetes.client.openapi.models.V1ServicePortFluent;
import java.util.Objects;

public class V1ServicePortFluentImpl<A extends V1ServicePortFluent<A>>
extends BaseFluent<A>
implements V1ServicePortFluent<A> {
    private String appProtocol;
    private String name;
    private Integer nodePort;
    private Integer port;
    private String protocol;
    private IntOrString targetPort;

    public V1ServicePortFluentImpl() {
    }

    public V1ServicePortFluentImpl(V1ServicePort instance) {
        if (instance != null) {
            this.withAppProtocol(instance.getAppProtocol());
            this.withName(instance.getName());
            this.withNodePort(instance.getNodePort());
            this.withPort(instance.getPort());
            this.withProtocol(instance.getProtocol());
            this.withTargetPort(instance.getTargetPort());
        }
    }

    @Override
    public String getAppProtocol() {
        return this.appProtocol;
    }

    @Override
    public A withAppProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
        return (A)this;
    }

    @Override
    public Boolean hasAppProtocol() {
        return this.appProtocol != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    public Integer getNodePort() {
        return this.nodePort;
    }

    @Override
    public A withNodePort(Integer nodePort) {
        this.nodePort = nodePort;
        return (A)this;
    }

    @Override
    public Boolean hasNodePort() {
        return this.nodePort != null;
    }

    @Override
    public Integer getPort() {
        return this.port;
    }

    @Override
    public A withPort(Integer port) {
        this.port = port;
        return (A)this;
    }

    @Override
    public Boolean hasPort() {
        return this.port != null;
    }

    @Override
    public String getProtocol() {
        return this.protocol;
    }

    @Override
    public A withProtocol(String protocol) {
        this.protocol = protocol;
        return (A)this;
    }

    @Override
    public Boolean hasProtocol() {
        return this.protocol != null;
    }

    @Override
    public IntOrString getTargetPort() {
        return this.targetPort;
    }

    @Override
    public A withTargetPort(IntOrString targetPort) {
        this.targetPort = targetPort;
        return (A)this;
    }

    @Override
    public Boolean hasTargetPort() {
        return this.targetPort != null;
    }

    @Override
    public A withNewTargetPort(int value) {
        return this.withTargetPort(new IntOrString(value));
    }

    @Override
    public A withNewTargetPort(String value) {
        return this.withTargetPort(new IntOrString(value));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ServicePortFluentImpl that = (V1ServicePortFluentImpl)o;
        if (!Objects.equals(this.appProtocol, that.appProtocol)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.nodePort, that.nodePort)) {
            return false;
        }
        if (!Objects.equals(this.port, that.port)) {
            return false;
        }
        if (!Objects.equals(this.protocol, that.protocol)) {
            return false;
        }
        return Objects.equals(this.targetPort, that.targetPort);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.appProtocol, this.name, this.nodePort, this.port, this.protocol, this.targetPort, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.appProtocol != null) {
            sb.append("appProtocol:");
            sb.append(this.appProtocol + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.nodePort != null) {
            sb.append("nodePort:");
            sb.append(this.nodePort + ",");
        }
        if (this.port != null) {
            sb.append("port:");
            sb.append(this.port + ",");
        }
        if (this.protocol != null) {
            sb.append("protocol:");
            sb.append(this.protocol + ",");
        }
        if (this.targetPort != null) {
            sb.append("targetPort:");
            sb.append(this.targetPort);
        }
        sb.append("}");
        return sb.toString();
    }
}

