/*
 * Decompiled with CFR 0.152.
 */
package io.kubernetes.client.openapi.models;

import io.kubernetes.client.fluent.BaseFluent;
import io.kubernetes.client.fluent.Nested;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1WebhookClientConfig;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1WebhookClientConfigBuilder;
import io.kubernetes.client.openapi.models.AdmissionregistrationV1WebhookClientConfigFluentImpl;
import io.kubernetes.client.openapi.models.V1LabelSelector;
import io.kubernetes.client.openapi.models.V1LabelSelectorBuilder;
import io.kubernetes.client.openapi.models.V1LabelSelectorFluentImpl;
import io.kubernetes.client.openapi.models.V1MatchCondition;
import io.kubernetes.client.openapi.models.V1MatchConditionBuilder;
import io.kubernetes.client.openapi.models.V1MatchConditionFluentImpl;
import io.kubernetes.client.openapi.models.V1RuleWithOperations;
import io.kubernetes.client.openapi.models.V1RuleWithOperationsBuilder;
import io.kubernetes.client.openapi.models.V1RuleWithOperationsFluentImpl;
import io.kubernetes.client.openapi.models.V1ValidatingWebhook;
import io.kubernetes.client.openapi.models.V1ValidatingWebhookFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public class V1ValidatingWebhookFluentImpl<A extends V1ValidatingWebhookFluent<A>>
extends BaseFluent<A>
implements V1ValidatingWebhookFluent<A> {
    private List<String> admissionReviewVersions;
    private AdmissionregistrationV1WebhookClientConfigBuilder clientConfig;
    private String failurePolicy;
    private ArrayList<V1MatchConditionBuilder> matchConditions;
    private String matchPolicy;
    private String name;
    private V1LabelSelectorBuilder namespaceSelector;
    private V1LabelSelectorBuilder objectSelector;
    private ArrayList<V1RuleWithOperationsBuilder> rules;
    private String sideEffects;
    private Integer timeoutSeconds;

    public V1ValidatingWebhookFluentImpl() {
    }

    public V1ValidatingWebhookFluentImpl(V1ValidatingWebhook instance) {
        if (instance != null) {
            this.withAdmissionReviewVersions(instance.getAdmissionReviewVersions());
            this.withClientConfig(instance.getClientConfig());
            this.withFailurePolicy(instance.getFailurePolicy());
            this.withMatchConditions(instance.getMatchConditions());
            this.withMatchPolicy(instance.getMatchPolicy());
            this.withName(instance.getName());
            this.withNamespaceSelector(instance.getNamespaceSelector());
            this.withObjectSelector(instance.getObjectSelector());
            this.withRules(instance.getRules());
            this.withSideEffects(instance.getSideEffects());
            this.withTimeoutSeconds(instance.getTimeoutSeconds());
        }
    }

    @Override
    public A addToAdmissionReviewVersions(int index, String item) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        this.admissionReviewVersions.add(index, item);
        return (A)this;
    }

    @Override
    public A setToAdmissionReviewVersions(int index, String item) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        this.admissionReviewVersions.set(index, item);
        return (A)this;
    }

    @Override
    public A addToAdmissionReviewVersions(String ... items) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.admissionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A addAllToAdmissionReviewVersions(Collection<String> items) {
        if (this.admissionReviewVersions == null) {
            this.admissionReviewVersions = new ArrayList<String>();
        }
        for (String item : items) {
            this.admissionReviewVersions.add(item);
        }
        return (A)this;
    }

    @Override
    public A removeFromAdmissionReviewVersions(String ... items) {
        for (String item : items) {
            if (this.admissionReviewVersions == null) continue;
            this.admissionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromAdmissionReviewVersions(Collection<String> items) {
        for (String item : items) {
            if (this.admissionReviewVersions == null) continue;
            this.admissionReviewVersions.remove(item);
        }
        return (A)this;
    }

    @Override
    public List<String> getAdmissionReviewVersions() {
        return this.admissionReviewVersions;
    }

    @Override
    public String getAdmissionReviewVersion(int index) {
        return this.admissionReviewVersions.get(index);
    }

    @Override
    public String getFirstAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(0);
    }

    @Override
    public String getLastAdmissionReviewVersion() {
        return this.admissionReviewVersions.get(this.admissionReviewVersions.size() - 1);
    }

    @Override
    public String getMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item : this.admissionReviewVersions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    @Override
    public Boolean hasMatchingAdmissionReviewVersion(Predicate<String> predicate) {
        for (String item : this.admissionReviewVersions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withAdmissionReviewVersions(List<String> admissionReviewVersions) {
        if (admissionReviewVersions != null) {
            this.admissionReviewVersions = new ArrayList<String>();
            for (String item : admissionReviewVersions) {
                this.addToAdmissionReviewVersions(item);
            }
        } else {
            this.admissionReviewVersions = null;
        }
        return (A)this;
    }

    @Override
    public A withAdmissionReviewVersions(String ... admissionReviewVersions) {
        if (this.admissionReviewVersions != null) {
            this.admissionReviewVersions.clear();
            this._visitables.remove("admissionReviewVersions");
        }
        if (admissionReviewVersions != null) {
            for (String item : admissionReviewVersions) {
                this.addToAdmissionReviewVersions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasAdmissionReviewVersions() {
        return this.admissionReviewVersions != null && !this.admissionReviewVersions.isEmpty();
    }

    @Override
    @Deprecated
    public AdmissionregistrationV1WebhookClientConfig getClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    @Override
    public AdmissionregistrationV1WebhookClientConfig buildClientConfig() {
        return this.clientConfig != null ? this.clientConfig.build() : null;
    }

    @Override
    public A withClientConfig(AdmissionregistrationV1WebhookClientConfig clientConfig) {
        this._visitables.get("clientConfig").remove(this.clientConfig);
        if (clientConfig != null) {
            this.clientConfig = new AdmissionregistrationV1WebhookClientConfigBuilder(clientConfig);
            this._visitables.get("clientConfig").add(this.clientConfig);
        } else {
            this.clientConfig = null;
            this._visitables.get("clientConfig").remove(this.clientConfig);
        }
        return (A)this;
    }

    @Override
    public Boolean hasClientConfig() {
        return this.clientConfig != null;
    }

    @Override
    public V1ValidatingWebhookFluent.ClientConfigNested<A> withNewClientConfig() {
        return new ClientConfigNestedImpl();
    }

    @Override
    public V1ValidatingWebhookFluent.ClientConfigNested<A> withNewClientConfigLike(AdmissionregistrationV1WebhookClientConfig item) {
        return new ClientConfigNestedImpl(item);
    }

    @Override
    public V1ValidatingWebhookFluent.ClientConfigNested<A> editClientConfig() {
        return this.withNewClientConfigLike(this.getClientConfig());
    }

    @Override
    public V1ValidatingWebhookFluent.ClientConfigNested<A> editOrNewClientConfig() {
        return this.withNewClientConfigLike(this.getClientConfig() != null ? this.getClientConfig() : new AdmissionregistrationV1WebhookClientConfigBuilder().build());
    }

    @Override
    public V1ValidatingWebhookFluent.ClientConfigNested<A> editOrNewClientConfigLike(AdmissionregistrationV1WebhookClientConfig item) {
        return this.withNewClientConfigLike(this.getClientConfig() != null ? this.getClientConfig() : item);
    }

    @Override
    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    @Override
    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)this;
    }

    @Override
    public Boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    @Override
    public A addToMatchConditions(int index, V1MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get("matchConditions").add(index, builder);
            this.matchConditions.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToMatchConditions(int index, V1MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get("matchConditions").set(index, builder);
            this.matchConditions.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToMatchConditions(V1MatchCondition ... items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (V1MatchCondition item : items) {
            V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToMatchConditions(Collection<V1MatchCondition> items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (V1MatchCondition item : items) {
            V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromMatchConditions(V1MatchCondition ... items) {
        for (V1MatchCondition item : items) {
            V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").remove(builder);
            if (this.matchConditions == null) continue;
            this.matchConditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromMatchConditions(Collection<V1MatchCondition> items) {
        for (V1MatchCondition item : items) {
            V1MatchConditionBuilder builder = new V1MatchConditionBuilder(item);
            this._visitables.get("matchConditions").remove(builder);
            if (this.matchConditions == null) continue;
            this.matchConditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromMatchConditions(Predicate<V1MatchConditionBuilder> predicate) {
        if (this.matchConditions == null) {
            return (A)this;
        }
        Iterator<V1MatchConditionBuilder> each = this.matchConditions.iterator();
        Object visitables = this._visitables.get("matchConditions");
        while (each.hasNext()) {
            V1MatchConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1MatchCondition> getMatchConditions() {
        return this.matchConditions != null ? V1ValidatingWebhookFluentImpl.build(this.matchConditions) : null;
    }

    @Override
    public List<V1MatchCondition> buildMatchConditions() {
        return this.matchConditions != null ? V1ValidatingWebhookFluentImpl.build(this.matchConditions) : null;
    }

    @Override
    public V1MatchCondition buildMatchCondition(int index) {
        return this.matchConditions.get(index).build();
    }

    @Override
    public V1MatchCondition buildFirstMatchCondition() {
        return this.matchConditions.get(0).build();
    }

    @Override
    public V1MatchCondition buildLastMatchCondition() {
        return this.matchConditions.get(this.matchConditions.size() - 1).build();
    }

    @Override
    public V1MatchCondition buildMatchingMatchCondition(Predicate<V1MatchConditionBuilder> predicate) {
        for (V1MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingMatchCondition(Predicate<V1MatchConditionBuilder> predicate) {
        for (V1MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withMatchConditions(List<V1MatchCondition> matchConditions) {
        if (this.matchConditions != null) {
            this._visitables.get("matchConditions").clear();
        }
        if (matchConditions != null) {
            this.matchConditions = new ArrayList();
            for (V1MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        } else {
            this.matchConditions = null;
        }
        return (A)this;
    }

    @Override
    public A withMatchConditions(V1MatchCondition ... matchConditions) {
        if (this.matchConditions != null) {
            this.matchConditions.clear();
            this._visitables.remove("matchConditions");
        }
        if (matchConditions != null) {
            for (V1MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasMatchConditions() {
        return this.matchConditions != null && !this.matchConditions.isEmpty();
    }

    @Override
    public V1ValidatingWebhookFluent.MatchConditionsNested<A> addNewMatchCondition() {
        return new MatchConditionsNestedImpl();
    }

    @Override
    public V1ValidatingWebhookFluent.MatchConditionsNested<A> addNewMatchConditionLike(V1MatchCondition item) {
        return new MatchConditionsNestedImpl(-1, item);
    }

    @Override
    public V1ValidatingWebhookFluent.MatchConditionsNested<A> setNewMatchConditionLike(int index, V1MatchCondition item) {
        return new MatchConditionsNestedImpl(index, item);
    }

    @Override
    public V1ValidatingWebhookFluent.MatchConditionsNested<A> editMatchCondition(int index) {
        if (this.matchConditions.size() <= index) {
            throw new RuntimeException("Can't edit matchConditions. Index exceeds size.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    @Override
    public V1ValidatingWebhookFluent.MatchConditionsNested<A> editFirstMatchCondition() {
        if (this.matchConditions.size() == 0) {
            throw new RuntimeException("Can't edit first matchConditions. The list is empty.");
        }
        return this.setNewMatchConditionLike(0, this.buildMatchCondition(0));
    }

    @Override
    public V1ValidatingWebhookFluent.MatchConditionsNested<A> editLastMatchCondition() {
        int index = this.matchConditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last matchConditions. The list is empty.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    @Override
    public V1ValidatingWebhookFluent.MatchConditionsNested<A> editMatchingMatchCondition(Predicate<V1MatchConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchConditions.size(); ++i) {
            if (!predicate.test(this.matchConditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching matchConditions. No match found.");
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    @Override
    public String getMatchPolicy() {
        return this.matchPolicy;
    }

    @Override
    public A withMatchPolicy(String matchPolicy) {
        this.matchPolicy = matchPolicy;
        return (A)this;
    }

    @Override
    public Boolean hasMatchPolicy() {
        return this.matchPolicy != null;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public A withName(String name) {
        this.name = name;
        return (A)this;
    }

    @Override
    public Boolean hasName() {
        return this.name != null;
    }

    @Override
    @Deprecated
    public V1LabelSelector getNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public V1LabelSelector buildNamespaceSelector() {
        return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
    }

    @Override
    public A withNamespaceSelector(V1LabelSelector namespaceSelector) {
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        if (namespaceSelector != null) {
            this.namespaceSelector = new V1LabelSelectorBuilder(namespaceSelector);
            this._visitables.get("namespaceSelector").add(this.namespaceSelector);
        } else {
            this.namespaceSelector = null;
            this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasNamespaceSelector() {
        return this.namespaceSelector != null;
    }

    @Override
    public V1ValidatingWebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
        return new NamespaceSelectorNestedImpl();
    }

    @Override
    public V1ValidatingWebhookFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(V1LabelSelector item) {
        return new NamespaceSelectorNestedImpl(item);
    }

    @Override
    public V1ValidatingWebhookFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector());
    }

    @Override
    public V1ValidatingWebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1ValidatingWebhookFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(V1LabelSelector item) {
        return this.withNewNamespaceSelectorLike(this.getNamespaceSelector() != null ? this.getNamespaceSelector() : item);
    }

    @Override
    @Deprecated
    public V1LabelSelector getObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    @Override
    public V1LabelSelector buildObjectSelector() {
        return this.objectSelector != null ? this.objectSelector.build() : null;
    }

    @Override
    public A withObjectSelector(V1LabelSelector objectSelector) {
        this._visitables.get("objectSelector").remove(this.objectSelector);
        if (objectSelector != null) {
            this.objectSelector = new V1LabelSelectorBuilder(objectSelector);
            this._visitables.get("objectSelector").add(this.objectSelector);
        } else {
            this.objectSelector = null;
            this._visitables.get("objectSelector").remove(this.objectSelector);
        }
        return (A)this;
    }

    @Override
    public Boolean hasObjectSelector() {
        return this.objectSelector != null;
    }

    @Override
    public V1ValidatingWebhookFluent.ObjectSelectorNested<A> withNewObjectSelector() {
        return new ObjectSelectorNestedImpl();
    }

    @Override
    public V1ValidatingWebhookFluent.ObjectSelectorNested<A> withNewObjectSelectorLike(V1LabelSelector item) {
        return new ObjectSelectorNestedImpl(item);
    }

    @Override
    public V1ValidatingWebhookFluent.ObjectSelectorNested<A> editObjectSelector() {
        return this.withNewObjectSelectorLike(this.getObjectSelector());
    }

    @Override
    public V1ValidatingWebhookFluent.ObjectSelectorNested<A> editOrNewObjectSelector() {
        return this.withNewObjectSelectorLike(this.getObjectSelector() != null ? this.getObjectSelector() : new V1LabelSelectorBuilder().build());
    }

    @Override
    public V1ValidatingWebhookFluent.ObjectSelectorNested<A> editOrNewObjectSelectorLike(V1LabelSelector item) {
        return this.withNewObjectSelectorLike(this.getObjectSelector() != null ? this.getObjectSelector() : item);
    }

    @Override
    public A addToRules(int index, V1RuleWithOperations item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").add(index, builder);
            this.rules.add(index, builder);
        }
        return (A)this;
    }

    @Override
    public A setToRules(int index, V1RuleWithOperations item) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
        if (index < 0 || index >= this.rules.size()) {
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        } else {
            this._visitables.get("rules").set(index, builder);
            this.rules.set(index, builder);
        }
        return (A)this;
    }

    @Override
    public A addToRules(V1RuleWithOperations ... items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1RuleWithOperations item : items) {
            V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A addAllToRules(Collection<V1RuleWithOperations> items) {
        if (this.rules == null) {
            this.rules = new ArrayList();
        }
        for (V1RuleWithOperations item : items) {
            V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
            this._visitables.get("rules").add(builder);
            this.rules.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromRules(V1RuleWithOperations ... items) {
        for (V1RuleWithOperations item : items) {
            V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeAllFromRules(Collection<V1RuleWithOperations> items) {
        for (V1RuleWithOperations item : items) {
            V1RuleWithOperationsBuilder builder = new V1RuleWithOperationsBuilder(item);
            this._visitables.get("rules").remove(builder);
            if (this.rules == null) continue;
            this.rules.remove(builder);
        }
        return (A)this;
    }

    @Override
    public A removeMatchingFromRules(Predicate<V1RuleWithOperationsBuilder> predicate) {
        if (this.rules == null) {
            return (A)this;
        }
        Iterator<V1RuleWithOperationsBuilder> each = this.rules.iterator();
        Object visitables = this._visitables.get("rules");
        while (each.hasNext()) {
            V1RuleWithOperationsBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove(builder);
            each.remove();
        }
        return (A)this;
    }

    @Override
    @Deprecated
    public List<V1RuleWithOperations> getRules() {
        return this.rules != null ? V1ValidatingWebhookFluentImpl.build(this.rules) : null;
    }

    @Override
    public List<V1RuleWithOperations> buildRules() {
        return this.rules != null ? V1ValidatingWebhookFluentImpl.build(this.rules) : null;
    }

    @Override
    public V1RuleWithOperations buildRule(int index) {
        return this.rules.get(index).build();
    }

    @Override
    public V1RuleWithOperations buildFirstRule() {
        return this.rules.get(0).build();
    }

    @Override
    public V1RuleWithOperations buildLastRule() {
        return this.rules.get(this.rules.size() - 1).build();
    }

    @Override
    public V1RuleWithOperations buildMatchingRule(Predicate<V1RuleWithOperationsBuilder> predicate) {
        for (V1RuleWithOperationsBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    @Override
    public Boolean hasMatchingRule(Predicate<V1RuleWithOperationsBuilder> predicate) {
        for (V1RuleWithOperationsBuilder item : this.rules) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public A withRules(List<V1RuleWithOperations> rules) {
        if (this.rules != null) {
            this._visitables.get("rules").clear();
        }
        if (rules != null) {
            this.rules = new ArrayList();
            for (V1RuleWithOperations item : rules) {
                this.addToRules(item);
            }
        } else {
            this.rules = null;
        }
        return (A)this;
    }

    @Override
    public A withRules(V1RuleWithOperations ... rules) {
        if (this.rules != null) {
            this.rules.clear();
            this._visitables.remove("rules");
        }
        if (rules != null) {
            for (V1RuleWithOperations item : rules) {
                this.addToRules(item);
            }
        }
        return (A)this;
    }

    @Override
    public Boolean hasRules() {
        return this.rules != null && !this.rules.isEmpty();
    }

    @Override
    public V1ValidatingWebhookFluent.RulesNested<A> addNewRule() {
        return new RulesNestedImpl();
    }

    @Override
    public V1ValidatingWebhookFluent.RulesNested<A> addNewRuleLike(V1RuleWithOperations item) {
        return new RulesNestedImpl(-1, item);
    }

    @Override
    public V1ValidatingWebhookFluent.RulesNested<A> setNewRuleLike(int index, V1RuleWithOperations item) {
        return new RulesNestedImpl(index, item);
    }

    @Override
    public V1ValidatingWebhookFluent.RulesNested<A> editRule(int index) {
        if (this.rules.size() <= index) {
            throw new RuntimeException("Can't edit rules. Index exceeds size.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1ValidatingWebhookFluent.RulesNested<A> editFirstRule() {
        if (this.rules.size() == 0) {
            throw new RuntimeException("Can't edit first rules. The list is empty.");
        }
        return this.setNewRuleLike(0, this.buildRule(0));
    }

    @Override
    public V1ValidatingWebhookFluent.RulesNested<A> editLastRule() {
        int index = this.rules.size() - 1;
        if (index < 0) {
            throw new RuntimeException("Can't edit last rules. The list is empty.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public V1ValidatingWebhookFluent.RulesNested<A> editMatchingRule(Predicate<V1RuleWithOperationsBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.rules.size(); ++i) {
            if (!predicate.test(this.rules.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException("Can't edit matching rules. No match found.");
        }
        return this.setNewRuleLike(index, this.buildRule(index));
    }

    @Override
    public String getSideEffects() {
        return this.sideEffects;
    }

    @Override
    public A withSideEffects(String sideEffects) {
        this.sideEffects = sideEffects;
        return (A)this;
    }

    @Override
    public Boolean hasSideEffects() {
        return this.sideEffects != null;
    }

    @Override
    public Integer getTimeoutSeconds() {
        return this.timeoutSeconds;
    }

    @Override
    public A withTimeoutSeconds(Integer timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
        return (A)this;
    }

    @Override
    public Boolean hasTimeoutSeconds() {
        return this.timeoutSeconds != null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        V1ValidatingWebhookFluentImpl that = (V1ValidatingWebhookFluentImpl)o;
        if (!Objects.equals(this.admissionReviewVersions, that.admissionReviewVersions)) {
            return false;
        }
        if (!Objects.equals(this.clientConfig, that.clientConfig)) {
            return false;
        }
        if (!Objects.equals(this.failurePolicy, that.failurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.matchConditions, that.matchConditions)) {
            return false;
        }
        if (!Objects.equals(this.matchPolicy, that.matchPolicy)) {
            return false;
        }
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.namespaceSelector, that.namespaceSelector)) {
            return false;
        }
        if (!Objects.equals(this.objectSelector, that.objectSelector)) {
            return false;
        }
        if (!Objects.equals(this.rules, that.rules)) {
            return false;
        }
        if (!Objects.equals(this.sideEffects, that.sideEffects)) {
            return false;
        }
        return Objects.equals(this.timeoutSeconds, that.timeoutSeconds);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.admissionReviewVersions, this.clientConfig, this.failurePolicy, this.matchConditions, this.matchPolicy, this.name, this.namespaceSelector, this.objectSelector, this.rules, this.sideEffects, this.timeoutSeconds, super.hashCode());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.admissionReviewVersions != null && !this.admissionReviewVersions.isEmpty()) {
            sb.append("admissionReviewVersions:");
            sb.append(this.admissionReviewVersions + ",");
        }
        if (this.clientConfig != null) {
            sb.append("clientConfig:");
            sb.append(this.clientConfig + ",");
        }
        if (this.failurePolicy != null) {
            sb.append("failurePolicy:");
            sb.append(this.failurePolicy + ",");
        }
        if (this.matchConditions != null) {
            sb.append("matchConditions:");
            sb.append(this.matchConditions + ",");
        }
        if (this.matchPolicy != null) {
            sb.append("matchPolicy:");
            sb.append(this.matchPolicy + ",");
        }
        if (this.name != null) {
            sb.append("name:");
            sb.append(this.name + ",");
        }
        if (this.namespaceSelector != null) {
            sb.append("namespaceSelector:");
            sb.append(this.namespaceSelector + ",");
        }
        if (this.objectSelector != null) {
            sb.append("objectSelector:");
            sb.append(this.objectSelector + ",");
        }
        if (this.rules != null) {
            sb.append("rules:");
            sb.append(this.rules + ",");
        }
        if (this.sideEffects != null) {
            sb.append("sideEffects:");
            sb.append(this.sideEffects + ",");
        }
        if (this.timeoutSeconds != null) {
            sb.append("timeoutSeconds:");
            sb.append(this.timeoutSeconds);
        }
        sb.append("}");
        return sb.toString();
    }

    class ClientConfigNestedImpl<N>
    extends AdmissionregistrationV1WebhookClientConfigFluentImpl<V1ValidatingWebhookFluent.ClientConfigNested<N>>
    implements V1ValidatingWebhookFluent.ClientConfigNested<N>,
    Nested<N> {
        AdmissionregistrationV1WebhookClientConfigBuilder builder;

        ClientConfigNestedImpl(AdmissionregistrationV1WebhookClientConfig item) {
            this.builder = new AdmissionregistrationV1WebhookClientConfigBuilder(this, item);
        }

        ClientConfigNestedImpl() {
            this.builder = new AdmissionregistrationV1WebhookClientConfigBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ValidatingWebhookFluentImpl.this.withClientConfig(this.builder.build());
        }

        @Override
        public N endClientConfig() {
            return this.and();
        }
    }

    class MatchConditionsNestedImpl<N>
    extends V1MatchConditionFluentImpl<V1ValidatingWebhookFluent.MatchConditionsNested<N>>
    implements V1ValidatingWebhookFluent.MatchConditionsNested<N>,
    Nested<N> {
        V1MatchConditionBuilder builder;
        int index;

        MatchConditionsNestedImpl(int index, V1MatchCondition item) {
            this.index = index;
            this.builder = new V1MatchConditionBuilder(this, item);
        }

        MatchConditionsNestedImpl() {
            this.index = -1;
            this.builder = new V1MatchConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ValidatingWebhookFluentImpl.this.setToMatchConditions(this.index, this.builder.build());
        }

        @Override
        public N endMatchCondition() {
            return this.and();
        }
    }

    class NamespaceSelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1ValidatingWebhookFluent.NamespaceSelectorNested<N>>
    implements V1ValidatingWebhookFluent.NamespaceSelectorNested<N>,
    Nested<N> {
        V1LabelSelectorBuilder builder;

        NamespaceSelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        NamespaceSelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ValidatingWebhookFluentImpl.this.withNamespaceSelector(this.builder.build());
        }

        @Override
        public N endNamespaceSelector() {
            return this.and();
        }
    }

    class ObjectSelectorNestedImpl<N>
    extends V1LabelSelectorFluentImpl<V1ValidatingWebhookFluent.ObjectSelectorNested<N>>
    implements V1ValidatingWebhookFluent.ObjectSelectorNested<N>,
    Nested<N> {
        V1LabelSelectorBuilder builder;

        ObjectSelectorNestedImpl(V1LabelSelector item) {
            this.builder = new V1LabelSelectorBuilder(this, item);
        }

        ObjectSelectorNestedImpl() {
            this.builder = new V1LabelSelectorBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ValidatingWebhookFluentImpl.this.withObjectSelector(this.builder.build());
        }

        @Override
        public N endObjectSelector() {
            return this.and();
        }
    }

    class RulesNestedImpl<N>
    extends V1RuleWithOperationsFluentImpl<V1ValidatingWebhookFluent.RulesNested<N>>
    implements V1ValidatingWebhookFluent.RulesNested<N>,
    Nested<N> {
        V1RuleWithOperationsBuilder builder;
        int index;

        RulesNestedImpl(int index, V1RuleWithOperations item) {
            this.index = index;
            this.builder = new V1RuleWithOperationsBuilder(this, item);
        }

        RulesNestedImpl() {
            this.index = -1;
            this.builder = new V1RuleWithOperationsBuilder(this);
        }

        @Override
        public N and() {
            return (N)V1ValidatingWebhookFluentImpl.this.setToRules(this.index, this.builder.build());
        }

        @Override
        public N endRule() {
            return this.and();
        }
    }
}

