/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.producer;

import java.time.Duration;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.apache.kafka.clients.consumer.ConsumerGroupMetadata;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.producer.Callback;
import org.apache.kafka.clients.producer.Partitioner;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.clients.producer.RecordMetadata;
import org.apache.kafka.clients.producer.internals.DefaultPartitioner;
import org.apache.kafka.clients.producer.internals.FutureRecordMetadata;
import org.apache.kafka.clients.producer.internals.ProduceRequestResult;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Metric;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.ProducerFencedException;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.utils.Time;

public class MockProducer<K, V>
implements Producer<K, V> {
    private final Cluster cluster;
    private final Partitioner partitioner;
    private final List<ProducerRecord<K, V>> sent;
    private final List<ProducerRecord<K, V>> uncommittedSends;
    private final Deque<Completion> completions;
    private final Map<TopicPartition, Long> offsets;
    private final List<Map<String, Map<TopicPartition, OffsetAndMetadata>>> consumerGroupOffsets;
    private Map<String, Map<TopicPartition, OffsetAndMetadata>> uncommittedConsumerGroupOffsets;
    private final Serializer<K> keySerializer;
    private final Serializer<V> valueSerializer;
    private boolean autoComplete;
    private boolean closed;
    private boolean transactionInitialized;
    private boolean transactionInFlight;
    private boolean transactionCommitted;
    private boolean transactionAborted;
    private boolean producerFenced;
    private boolean sentOffsets;
    private long commitCount = 0L;
    private final Map<MetricName, Metric> mockMetrics;
    public RuntimeException initTransactionException = null;
    public RuntimeException beginTransactionException = null;
    public RuntimeException sendOffsetsToTransactionException = null;
    public RuntimeException commitTransactionException = null;
    public RuntimeException abortTransactionException = null;
    public RuntimeException sendException = null;
    public RuntimeException flushException = null;
    public RuntimeException partitionsForException = null;
    public RuntimeException closeException = null;

    public MockProducer(Cluster cluster, boolean autoComplete, Partitioner partitioner, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this.cluster = cluster;
        this.autoComplete = autoComplete;
        this.partitioner = partitioner;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
        this.offsets = new HashMap<TopicPartition, Long>();
        this.sent = new ArrayList<ProducerRecord<K, V>>();
        this.uncommittedSends = new ArrayList<ProducerRecord<K, V>>();
        this.consumerGroupOffsets = new ArrayList<Map<String, Map<TopicPartition, OffsetAndMetadata>>>();
        this.uncommittedConsumerGroupOffsets = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
        this.completions = new ArrayDeque<Completion>();
        this.mockMetrics = new HashMap<MetricName, Metric>();
    }

    public MockProducer(boolean autoComplete, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(Cluster.empty(), autoComplete, new DefaultPartitioner(), keySerializer, valueSerializer);
    }

    public MockProducer(boolean autoComplete, Partitioner partitioner, Serializer<K> keySerializer, Serializer<V> valueSerializer) {
        this(Cluster.empty(), autoComplete, partitioner, keySerializer, valueSerializer);
    }

    public MockProducer() {
        this(Cluster.empty(), false, null, null, null);
    }

    @Override
    public void initTransactions() {
        this.verifyProducerState();
        if (this.transactionInitialized) {
            throw new IllegalStateException("MockProducer has already been initialized for transactions.");
        }
        if (this.initTransactionException != null) {
            throw this.initTransactionException;
        }
        this.transactionInitialized = true;
        this.transactionInFlight = false;
        this.transactionCommitted = false;
        this.transactionAborted = false;
        this.sentOffsets = false;
    }

    @Override
    public void beginTransaction() throws ProducerFencedException {
        this.verifyProducerState();
        this.verifyTransactionsInitialized();
        if (this.beginTransactionException != null) {
            throw this.beginTransactionException;
        }
        if (this.transactionInFlight) {
            throw new IllegalStateException("Transaction already started");
        }
        this.transactionInFlight = true;
        this.transactionCommitted = false;
        this.transactionAborted = false;
        this.sentOffsets = false;
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, String consumerGroupId) throws ProducerFencedException {
        Objects.requireNonNull(consumerGroupId);
        this.verifyProducerState();
        this.verifyTransactionsInitialized();
        this.verifyTransactionInFlight();
        if (this.sendOffsetsToTransactionException != null) {
            throw this.sendOffsetsToTransactionException;
        }
        if (offsets.size() == 0) {
            return;
        }
        Map uncommittedOffsets = this.uncommittedConsumerGroupOffsets.computeIfAbsent(consumerGroupId, k -> new HashMap());
        uncommittedOffsets.putAll(offsets);
        this.sentOffsets = true;
    }

    @Override
    public void sendOffsetsToTransaction(Map<TopicPartition, OffsetAndMetadata> offsets, ConsumerGroupMetadata groupMetadata) throws ProducerFencedException {
        Objects.requireNonNull(groupMetadata);
        this.sendOffsetsToTransaction(offsets, groupMetadata.groupId());
    }

    @Override
    public void commitTransaction() throws ProducerFencedException {
        this.verifyProducerState();
        this.verifyTransactionsInitialized();
        this.verifyTransactionInFlight();
        if (this.commitTransactionException != null) {
            throw this.commitTransactionException;
        }
        this.flush();
        this.sent.addAll(this.uncommittedSends);
        if (!this.uncommittedConsumerGroupOffsets.isEmpty()) {
            this.consumerGroupOffsets.add(this.uncommittedConsumerGroupOffsets);
        }
        this.uncommittedSends.clear();
        this.uncommittedConsumerGroupOffsets = new HashMap<String, Map<TopicPartition, OffsetAndMetadata>>();
        this.transactionCommitted = true;
        this.transactionAborted = false;
        this.transactionInFlight = false;
        ++this.commitCount;
    }

    @Override
    public void abortTransaction() throws ProducerFencedException {
        this.verifyProducerState();
        this.verifyTransactionsInitialized();
        this.verifyTransactionInFlight();
        if (this.abortTransactionException != null) {
            throw this.abortTransactionException;
        }
        this.flush();
        this.uncommittedSends.clear();
        this.uncommittedConsumerGroupOffsets.clear();
        this.transactionCommitted = false;
        this.transactionAborted = true;
        this.transactionInFlight = false;
    }

    private synchronized void verifyProducerState() {
        if (this.closed) {
            throw new IllegalStateException("MockProducer is already closed.");
        }
        if (this.producerFenced) {
            throw new ProducerFencedException("MockProducer is fenced.");
        }
    }

    private void verifyTransactionsInitialized() {
        if (!this.transactionInitialized) {
            throw new IllegalStateException("MockProducer hasn't been initialized for transactions.");
        }
    }

    private void verifyTransactionInFlight() {
        if (!this.transactionInFlight) {
            throw new IllegalStateException("There is no open transaction.");
        }
    }

    @Override
    public synchronized Future<RecordMetadata> send(ProducerRecord<K, V> record) {
        return this.send(record, null);
    }

    @Override
    public synchronized Future<RecordMetadata> send(ProducerRecord<K, V> record, Callback callback) {
        if (this.closed) {
            throw new IllegalStateException("MockProducer is already closed.");
        }
        if (this.producerFenced) {
            throw new KafkaException("MockProducer is fenced.", new ProducerFencedException("Fenced"));
        }
        if (this.sendException != null) {
            throw this.sendException;
        }
        int partition = 0;
        if (!this.cluster.partitionsForTopic(record.topic()).isEmpty()) {
            partition = this.partition(record, this.cluster);
        } else {
            this.keySerializer.serialize(record.topic(), record.key());
            this.valueSerializer.serialize(record.topic(), record.value());
        }
        TopicPartition topicPartition = new TopicPartition(record.topic(), partition);
        ProduceRequestResult result = new ProduceRequestResult(topicPartition);
        FutureRecordMetadata future = new FutureRecordMetadata(result, 0L, -1L, 0L, 0, 0, Time.SYSTEM);
        long offset = this.nextOffset(topicPartition);
        Completion completion = new Completion(offset, new RecordMetadata(topicPartition, 0L, offset, -1L, 0L, 0, 0), result, callback);
        if (!this.transactionInFlight) {
            this.sent.add(record);
        } else {
            this.uncommittedSends.add(record);
        }
        if (this.autoComplete) {
            completion.complete(null);
        } else {
            this.completions.addLast(completion);
        }
        return future;
    }

    private long nextOffset(TopicPartition tp) {
        Long offset = this.offsets.get(tp);
        if (offset == null) {
            this.offsets.put(tp, 1L);
            return 0L;
        }
        Long next = offset + 1L;
        this.offsets.put(tp, next);
        return offset;
    }

    @Override
    public synchronized void flush() {
        this.verifyProducerState();
        if (this.flushException != null) {
            throw this.flushException;
        }
        while (!this.completions.isEmpty()) {
            this.completeNext();
        }
    }

    @Override
    public List<PartitionInfo> partitionsFor(String topic) {
        if (this.partitionsForException != null) {
            throw this.partitionsForException;
        }
        return this.cluster.partitionsForTopic(topic);
    }

    @Override
    public Map<MetricName, Metric> metrics() {
        return this.mockMetrics;
    }

    public void setMockMetrics(MetricName name, Metric metric) {
        this.mockMetrics.put(name, metric);
    }

    @Override
    public void close() {
        this.close(Duration.ofMillis(0L));
    }

    @Override
    public void close(Duration timeout) {
        if (this.closeException != null) {
            throw this.closeException;
        }
        this.closed = true;
    }

    public boolean closed() {
        return this.closed;
    }

    public synchronized void fenceProducer() {
        this.verifyProducerState();
        this.verifyTransactionsInitialized();
        this.producerFenced = true;
    }

    public boolean transactionInitialized() {
        return this.transactionInitialized;
    }

    public boolean transactionInFlight() {
        return this.transactionInFlight;
    }

    public boolean transactionCommitted() {
        return this.transactionCommitted;
    }

    public boolean transactionAborted() {
        return this.transactionAborted;
    }

    public boolean flushed() {
        return this.completions.isEmpty();
    }

    public boolean sentOffsets() {
        return this.sentOffsets;
    }

    public long commitCount() {
        return this.commitCount;
    }

    public synchronized List<ProducerRecord<K, V>> history() {
        return new ArrayList<ProducerRecord<K, V>>(this.sent);
    }

    public synchronized List<ProducerRecord<K, V>> uncommittedRecords() {
        return new ArrayList<ProducerRecord<K, V>>(this.uncommittedSends);
    }

    public synchronized List<Map<String, Map<TopicPartition, OffsetAndMetadata>>> consumerGroupOffsetsHistory() {
        return new ArrayList<Map<String, Map<TopicPartition, OffsetAndMetadata>>>(this.consumerGroupOffsets);
    }

    public synchronized Map<String, Map<TopicPartition, OffsetAndMetadata>> uncommittedOffsets() {
        return this.uncommittedConsumerGroupOffsets;
    }

    public synchronized void clear() {
        this.sent.clear();
        this.uncommittedSends.clear();
        this.sentOffsets = false;
        this.completions.clear();
        this.consumerGroupOffsets.clear();
        this.uncommittedConsumerGroupOffsets.clear();
    }

    public synchronized boolean completeNext() {
        return this.errorNext(null);
    }

    public synchronized boolean errorNext(RuntimeException e) {
        Completion completion = this.completions.pollFirst();
        if (completion != null) {
            completion.complete(e);
            return true;
        }
        return false;
    }

    private int partition(ProducerRecord<K, V> record, Cluster cluster) {
        Integer partition = record.partition();
        String topic = record.topic();
        if (partition != null) {
            List<PartitionInfo> partitions = cluster.partitionsForTopic(topic);
            int numPartitions = partitions.size();
            if (partition < 0 || partition >= numPartitions) {
                throw new IllegalArgumentException("Invalid partition given with record: " + partition + " is not in the range [0..." + numPartitions + "].");
            }
            return partition;
        }
        byte[] keyBytes = this.keySerializer.serialize(topic, record.headers(), record.key());
        byte[] valueBytes = this.valueSerializer.serialize(topic, record.headers(), record.value());
        return this.partitioner.partition(topic, record.key(), keyBytes, record.value(), valueBytes, cluster);
    }

    private static class Completion {
        private final long offset;
        private final RecordMetadata metadata;
        private final ProduceRequestResult result;
        private final Callback callback;

        public Completion(long offset, RecordMetadata metadata, ProduceRequestResult result, Callback callback) {
            this.metadata = metadata;
            this.offset = offset;
            this.result = result;
            this.callback = callback;
        }

        public void complete(RuntimeException e) {
            this.result.set(e == null ? this.offset : -1L, -1L, e);
            if (this.callback != null) {
                if (e == null) {
                    this.callback.onCompletion(this.metadata, null);
                } else {
                    this.callback.onCompletion(null, e);
                }
            }
            this.result.done();
        }
    }
}

