/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.apache.druid.client.DruidServer;
import org.apache.druid.client.ImmutableDruidServer;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.selector.ServerSelector;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.planning.DataSourceAnalysis;
import org.apache.druid.segment.realtime.appenderator.SegmentSchemas;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.TimelineLookup;

public interface TimelineServerView
extends ServerView {
    public <T extends TimelineLookup<String, ServerSelector>> Optional<T> getTimeline(DataSourceAnalysis var1);

    default public List<DruidServerMetadata> getDruidServerMetadatas() {
        List<ImmutableDruidServer> druidServers = this.getDruidServers();
        ArrayList<DruidServerMetadata> metadatas = new ArrayList<DruidServerMetadata>(druidServers.size());
        for (ImmutableDruidServer druidServer : druidServers) {
            metadatas.add(druidServer.getMetadata());
        }
        return metadatas;
    }

    public List<ImmutableDruidServer> getDruidServers();

    public <T> QueryRunner<T> getQueryRunner(DruidServer var1);

    public void registerTimelineCallback(Executor var1, TimelineCallback var2);

    public static interface TimelineCallback {
        public ServerView.CallbackAction timelineInitialized();

        public ServerView.CallbackAction segmentAdded(DruidServerMetadata var1, DataSegment var2);

        public ServerView.CallbackAction segmentRemoved(DataSegment var1);

        public ServerView.CallbackAction serverSegmentRemoved(DruidServerMetadata var1, DataSegment var2);

        public ServerView.CallbackAction segmentSchemasAnnounced(SegmentSchemas var1);
    }
}

