/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.client.selector;

import com.google.common.collect.Iterables;
import it.unimi.dsi.fastutil.ints.Int2ObjectRBTreeMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.druid.client.QueryableDruidServer;
import org.apache.druid.client.selector.ServerSelectorStrategy;
import org.apache.druid.client.selector.TierSelectorStrategy;
import org.apache.druid.query.Query;
import org.apache.druid.timeline.DataSegment;

public abstract class AbstractTierSelectorStrategy
implements TierSelectorStrategy {
    private final ServerSelectorStrategy serverSelectorStrategy;

    public AbstractTierSelectorStrategy(ServerSelectorStrategy serverSelectorStrategy) {
        this.serverSelectorStrategy = serverSelectorStrategy;
    }

    @Override
    @Nullable
    public <T> QueryableDruidServer pick(Query<T> query, Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment) {
        return (QueryableDruidServer)Iterables.getOnlyElement(this.pick(query, prioritizedServers, segment, 1), null);
    }

    @Override
    public <T> List<QueryableDruidServer> pick(Query<T> query, Int2ObjectRBTreeMap<Set<QueryableDruidServer>> prioritizedServers, DataSegment segment, int numServersToPick) {
        ArrayList<QueryableDruidServer> result = new ArrayList<QueryableDruidServer>(numServersToPick);
        for (Set priorityServers : prioritizedServers.values()) {
            result.addAll(this.serverSelectorStrategy.pick(query, priorityServers, segment, numServersToPick - result.size()));
            if (result.size() != numServersToPick) continue;
            break;
        }
        return result;
    }
}

