/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.discovery;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.Enumeration;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.client.InputStreamHolder;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.http.client.response.ClientResponse;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryTimeoutException;
import org.apache.druid.query.context.ResponseContext;
import org.jboss.netty.buffer.ChannelBuffer;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.handler.codec.http.HttpChunk;
import org.jboss.netty.handler.codec.http.HttpResponse;

public class DataServerResponseHandler
implements HttpResponseHandler<InputStream, InputStream> {
    private static final Logger log = new Logger(DataServerResponseHandler.class);
    private final Query<?> query;
    private final ResponseContext responseContext;
    private final AtomicLong totalByteCount = new AtomicLong(0L);
    private final ObjectMapper objectMapper;
    private final AtomicReference<HttpResponseHandler.TrafficCop> trafficCopRef = new AtomicReference();
    private final long maxQueuedBytes;
    final boolean usingBackpressure;
    private final AtomicLong queuedByteCount = new AtomicLong(0L);
    private final AtomicBoolean done = new AtomicBoolean(false);
    private final BlockingQueue<InputStreamHolder> queue = new LinkedBlockingQueue<InputStreamHolder>();
    private final AtomicReference<String> fail = new AtomicReference();
    private final long failTime;

    public DataServerResponseHandler(Query<?> query, ResponseContext responseContext, ObjectMapper objectMapper) {
        this.query = query;
        this.responseContext = responseContext;
        this.objectMapper = objectMapper;
        QueryContext queryContext = query.context();
        this.maxQueuedBytes = queryContext.getMaxQueuedBytes(0L);
        this.usingBackpressure = this.maxQueuedBytes > 0L;
        long startTimeMillis = System.currentTimeMillis();
        this.failTime = queryContext.hasTimeout() ? startTimeMillis + queryContext.getTimeout() : 0L;
    }

    public ClientResponse<InputStream> handleResponse(HttpResponse response, HttpResponseHandler.TrafficCop trafficCop) {
        boolean continueReading;
        this.trafficCopRef.set(trafficCop);
        this.checkQueryTimeout();
        log.debug("Received response status[%s] for queryId[%s]", new Object[]{response.getStatus(), this.query.getId()});
        try {
            String queryResponseHeaders = response.headers().get("X-Druid-Response-Context");
            if (queryResponseHeaders != null) {
                this.responseContext.merge(ResponseContext.deserialize((String)queryResponseHeaders, (ObjectMapper)this.objectMapper));
            }
            continueReading = this.enqueue(response.getContent(), 0L);
        }
        catch (IOException e) {
            return ClientResponse.finished((Object)new InputStream(){

                @Override
                public int read() throws IOException {
                    throw e;
                }
            });
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        return ClientResponse.finished((Object)new SequenceInputStream((Enumeration<? extends InputStream>)new Enumeration<InputStream>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean hasMoreElements() {
                if (DataServerResponseHandler.this.fail.get() != null) {
                    throw new RE(DataServerResponseHandler.this.fail.get(), new Object[0]);
                }
                DataServerResponseHandler.this.checkQueryTimeout();
                AtomicBoolean atomicBoolean = DataServerResponseHandler.this.done;
                synchronized (atomicBoolean) {
                    return !DataServerResponseHandler.this.done.get() || !DataServerResponseHandler.this.queue.isEmpty();
                }
            }

            @Override
            public InputStream nextElement() {
                if (DataServerResponseHandler.this.fail.get() != null) {
                    throw new RE(DataServerResponseHandler.this.fail.get(), new Object[0]);
                }
                try {
                    return DataServerResponseHandler.this.dequeue();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException(e);
                }
            }
        }), (boolean)continueReading);
    }

    public ClientResponse<InputStream> handleChunk(ClientResponse<InputStream> clientResponse, HttpChunk chunk, long chunkNum) {
        this.checkQueryTimeout();
        ChannelBuffer channelBuffer = chunk.getContent();
        int bytes = channelBuffer.readableBytes();
        boolean continueReading = true;
        if (bytes > 0) {
            try {
                continueReading = this.enqueue(channelBuffer, chunkNum);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            this.totalByteCount.addAndGet(bytes);
        }
        return ClientResponse.finished((Object)((InputStream)clientResponse.getObj()), (boolean)continueReading);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientResponse<InputStream> done(ClientResponse<InputStream> clientResponse) {
        log.debug("Finished reading response for queryId[%s]. Read total[%d]", new Object[]{this.query.getId(), this.totalByteCount.get()});
        AtomicBoolean atomicBoolean = this.done;
        synchronized (atomicBoolean) {
            try {
                this.queue.put(InputStreamHolder.fromChannelBuffer(ChannelBuffers.EMPTY_BUFFER, Long.MAX_VALUE));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            finally {
                this.done.set(true);
            }
        }
        return ClientResponse.finished((Object)((InputStream)clientResponse.getObj()));
    }

    public void exceptionCaught(ClientResponse<InputStream> clientResponse, Throwable e) {
        String msg = StringUtils.format((String)"Query[%s] failed with exception msg [%s]", (Object[])new Object[]{this.query.getId(), e.getMessage()});
        this.setupResponseReadFailure(msg, e);
    }

    private boolean enqueue(ChannelBuffer buffer, long chunkNum) throws InterruptedException {
        InputStreamHolder holder = InputStreamHolder.fromChannelBuffer(buffer, chunkNum);
        long currentQueuedByteCount = this.queuedByteCount.addAndGet(holder.getLength());
        this.queue.put(holder);
        return !this.usingBackpressure || currentQueuedByteCount < this.maxQueuedBytes;
    }

    private InputStream dequeue() throws InterruptedException {
        InputStreamHolder holder = this.queue.poll(this.checkQueryTimeout(), TimeUnit.MILLISECONDS);
        if (holder == null) {
            throw new QueryTimeoutException(StringUtils.nonStrictFormat((String)"Query[%s] timed out.", (Object[])new Object[]{this.query.getId()}));
        }
        long currentQueuedByteCount = this.queuedByteCount.addAndGet(-holder.getLength());
        if (this.usingBackpressure && currentQueuedByteCount < this.maxQueuedBytes) {
            ((HttpResponseHandler.TrafficCop)Preconditions.checkNotNull((Object)this.trafficCopRef.get(), (Object)"No TrafficCop, how can this be?")).resume(holder.getChunkNum());
        }
        return holder.getStream();
    }

    private long checkQueryTimeout() {
        long timeLeft = this.failTime - System.currentTimeMillis();
        if (timeLeft <= 0L) {
            String msg = StringUtils.format((String)"Query[%s] timed out.", (Object[])new Object[]{this.query.getId()});
            this.setupResponseReadFailure(msg, null);
            throw new QueryTimeoutException(msg);
        }
        return timeLeft;
    }

    private void setupResponseReadFailure(final String msg, final Throwable th) {
        this.fail.set(msg);
        this.queue.clear();
        this.queue.offer(InputStreamHolder.fromStream(new InputStream(){

            @Override
            public int read() throws IOException {
                if (th != null) {
                    throw new IOException(msg, th);
                }
                throw new IOException(msg);
            }
        }, -1L, 0L));
    }
}

