/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.guice;

import com.google.inject.Binder;
import com.google.inject.Module;
import java.util.StringJoiner;
import org.apache.druid.client.FilteredServerInventoryView;
import org.apache.druid.client.FilteredServerInventoryViewProvider;
import org.apache.druid.client.HttpServerInventoryViewConfig;
import org.apache.druid.client.InventoryView;
import org.apache.druid.client.ServerInventoryView;
import org.apache.druid.client.ServerInventoryViewProvider;
import org.apache.druid.client.ServerView;
import org.apache.druid.guice.JsonConfigProvider;
import org.apache.druid.guice.ManageLifecycle;

public class ServerViewModule
implements Module {
    public static final String SERVERVIEW_PREFIX = "druid.serverview";
    public static final String TYPE = "type";
    public static final String SERVERVIEW_TYPE_PROPERTY = "druid.serverview.type";
    public static final String SERVERVIEW_TYPE_HTTP = "http";
    public static final String SERVERVIEW_TYPE_BATCH = "batch";

    public void configure(Binder binder) {
        JsonConfigProvider.bind((Binder)binder, (String)SERVERVIEW_PREFIX, ServerInventoryViewProvider.class);
        JsonConfigProvider.bind((Binder)binder, (String)SERVERVIEW_PREFIX, FilteredServerInventoryViewProvider.class);
        JsonConfigProvider.bind((Binder)binder, (String)new StringJoiner(".", SERVERVIEW_PREFIX, SERVERVIEW_TYPE_HTTP).toString(), HttpServerInventoryViewConfig.class);
        binder.bind(InventoryView.class).to(ServerInventoryView.class);
        binder.bind(ServerView.class).to(ServerInventoryView.class);
        binder.bind(ServerInventoryView.class).toProvider(ServerInventoryViewProvider.class).in(ManageLifecycle.class);
        binder.bind(FilteredServerInventoryView.class).toProvider(FilteredServerInventoryViewProvider.class).in(ManageLifecycle.class);
    }
}

