/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.initialization;

import com.google.inject.Injector;
import java.util.Collections;
import java.util.Set;
import org.apache.druid.curator.CuratorModule;
import org.apache.druid.curator.discovery.DiscoveryModule;
import org.apache.druid.discovery.NodeRole;
import org.apache.druid.guice.AnnouncerModule;
import org.apache.druid.guice.BuiltInTypesModule;
import org.apache.druid.guice.CoordinatorDiscoveryModule;
import org.apache.druid.guice.DruidInjectorBuilder;
import org.apache.druid.guice.DruidSecondaryModule;
import org.apache.druid.guice.ExpressionModule;
import org.apache.druid.guice.ExtensionsModule;
import org.apache.druid.guice.JacksonConfigManagerModule;
import org.apache.druid.guice.JavaScriptModule;
import org.apache.druid.guice.LifecycleModule;
import org.apache.druid.guice.LocalDataStorageDruidModule;
import org.apache.druid.guice.MetadataConfigModule;
import org.apache.druid.guice.ServerModule;
import org.apache.druid.guice.ServerViewModule;
import org.apache.druid.guice.StartupLoggingModule;
import org.apache.druid.guice.StorageNodeModule;
import org.apache.druid.guice.annotations.Client;
import org.apache.druid.guice.annotations.EscalatedClient;
import org.apache.druid.guice.http.HttpClientModule;
import org.apache.druid.guice.security.AuthenticatorModule;
import org.apache.druid.guice.security.AuthorizerModule;
import org.apache.druid.guice.security.DruidAuthModule;
import org.apache.druid.guice.security.EscalatorModule;
import org.apache.druid.initialization.Log4jShutterDownerModule;
import org.apache.druid.initialization.TombstoneDataStorageModule;
import org.apache.druid.metadata.storage.derby.DerbyMetadataStorageDruidModule;
import org.apache.druid.rpc.guice.ServiceClientModule;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumModule;
import org.apache.druid.server.emitter.EmitterModule;
import org.apache.druid.server.initialization.AuthenticatorMapperModule;
import org.apache.druid.server.initialization.AuthorizerMapperModule;
import org.apache.druid.server.initialization.ExternalStorageAccessSecurityModule;
import org.apache.druid.server.initialization.jetty.JettyServerModule;
import org.apache.druid.server.metrics.MetricsModule;
import org.apache.druid.server.security.TLSCertificateCheckerModule;
import org.apache.druid.storage.StorageConnectorModule;

public class CoreInjectorBuilder
extends DruidInjectorBuilder {
    public CoreInjectorBuilder(Injector baseInjector) {
        this(baseInjector, Collections.emptySet());
    }

    public CoreInjectorBuilder(Injector baseInjector, Set<NodeRole> nodeRoles) {
        super(baseInjector, nodeRoles);
        this.add(DruidSecondaryModule.class);
    }

    public CoreInjectorBuilder withLogging() {
        this.add(new Log4jShutterDownerModule());
        return this;
    }

    public CoreInjectorBuilder withLifecycle() {
        this.add(new LifecycleModule());
        return this;
    }

    public CoreInjectorBuilder forServer() {
        this.withLogging();
        this.withLifecycle();
        this.add(new Object[]{ExtensionsModule.SecondaryModule.class, new DruidAuthModule(), TLSCertificateCheckerModule.class, EmitterModule.class, HttpClientModule.global(), HttpClientModule.escalatedGlobal(), new HttpClientModule("druid.broker.http", Client.class, true), new HttpClientModule("druid.broker.http", EscalatedClient.class, true), new CuratorModule(), new AnnouncerModule(), new MetricsModule(), new SegmentWriteOutMediumModule(), new ServerModule(), new StorageNodeModule(), new JettyServerModule(), new ExpressionModule(), new BuiltInTypesModule(), new DiscoveryModule(), new ServerViewModule(), new MetadataConfigModule(), new DerbyMetadataStorageDruidModule(), new JacksonConfigManagerModule(), new CoordinatorDiscoveryModule(), new LocalDataStorageDruidModule(), new TombstoneDataStorageModule(), new JavaScriptModule(), new AuthenticatorModule(), new AuthenticatorMapperModule(), new EscalatorModule(), new AuthorizerModule(), new AuthorizerMapperModule(), new StartupLoggingModule(), new ExternalStorageAccessSecurityModule(), new ServiceClientModule(), new StorageConnectorModule()});
        return this;
    }
}

