/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.LegacyBrokerParallelMergeConfig;
import org.apache.druid.utils.JvmUtils;

public class BrokerParallelMergeConfig {
    private static final Logger LOG = new Logger(BrokerParallelMergeConfig.class);
    public static final int DEFAULT_MERGE_POOL_AWAIT_SHUTDOWN_MILLIS = 60000;
    @JsonProperty
    private final boolean useParallelMergePool;
    @JsonProperty
    private final int parallelism;
    @JsonProperty
    private final long awaitShutdownMillis;
    @JsonProperty
    private final int defaultMaxQueryParallelism;
    @JsonProperty
    private final int targetRunTimeMillis;
    @JsonProperty
    private final int initialYieldNumRows;
    @JsonProperty
    private final int smallBatchNumRows;

    @JsonCreator
    public BrokerParallelMergeConfig(@JsonProperty(value="useParallelMergePool") @Nullable Boolean useParallelMergePool, @JsonProperty(value="parallelism") @Nullable Integer parallelism, @JsonProperty(value="awaitShutdownMillis") @Nullable Long awaitShutdownMillis, @JsonProperty(value="defaultMaxQueryParallelism") @Nullable Integer defaultMaxQueryParallelism, @JsonProperty(value="targetRunTimeMillis") @Nullable Integer targetRunTimeMillis, @JsonProperty(value="initialYieldNumRows") @Nullable Integer initialYieldNumRows, @JsonProperty(value="smallBatchNumRows") @Nullable Integer smallBatchNumRows, @JacksonInject LegacyBrokerParallelMergeConfig oldConfig) {
        if (parallelism == null) {
            if (oldConfig == null || oldConfig.getMergePoolParallelism() == null) {
                this.parallelism = (int)Math.ceil((double)JvmUtils.getRuntimeInfo().getAvailableProcessors() * 0.75);
            } else {
                BrokerParallelMergeConfig.warnDeprecated("druid.processing.merge.pool.parallelism", "druid.processing.merge.parallelism");
                this.parallelism = oldConfig.getMergePoolParallelism();
            }
        } else {
            this.parallelism = parallelism;
        }
        if (this.parallelism > 2) {
            this.useParallelMergePool = useParallelMergePool == null || useParallelMergePool != false;
        } else {
            if (useParallelMergePool == null || useParallelMergePool.booleanValue()) {
                LOG.debug("Parallel merge pool is enabled, but there are not enough cores to enable parallel merges: %s", new Object[]{parallelism});
            }
            this.useParallelMergePool = false;
        }
        if (awaitShutdownMillis == null) {
            if (oldConfig == null || oldConfig.getMergePoolAwaitShutdownMillis() == null) {
                this.awaitShutdownMillis = 60000L;
            } else {
                BrokerParallelMergeConfig.warnDeprecated("druid.processing.merge.pool.awaitShutdownMillis", "druid.processing.merge.awaitShutdownMillis");
                this.awaitShutdownMillis = oldConfig.getMergePoolAwaitShutdownMillis();
            }
        } else {
            this.awaitShutdownMillis = awaitShutdownMillis;
        }
        if (defaultMaxQueryParallelism == null) {
            if (oldConfig == null || oldConfig.getMergePoolDefaultMaxQueryParallelism() == null) {
                this.defaultMaxQueryParallelism = (int)Math.max((double)JvmUtils.getRuntimeInfo().getAvailableProcessors() * 0.5, 1.0);
            } else {
                BrokerParallelMergeConfig.warnDeprecated("druid.processing.merge.pool.defaultMaxQueryParallelism", "druid.processing.merge.defaultMaxQueryParallelism");
                this.defaultMaxQueryParallelism = oldConfig.getMergePoolDefaultMaxQueryParallelism();
            }
        } else {
            this.defaultMaxQueryParallelism = defaultMaxQueryParallelism;
        }
        if (targetRunTimeMillis == null) {
            if (oldConfig == null || oldConfig.getMergePoolTargetTaskRunTimeMillis() == null) {
                this.targetRunTimeMillis = 100;
            } else {
                BrokerParallelMergeConfig.warnDeprecated("druid.processing.merge.task.targetRunTimeMillis", "druid.processing.merge.targetRunTimeMillis");
                this.targetRunTimeMillis = oldConfig.getMergePoolTargetTaskRunTimeMillis();
            }
        } else {
            this.targetRunTimeMillis = targetRunTimeMillis;
        }
        if (initialYieldNumRows == null) {
            if (oldConfig == null || oldConfig.getMergePoolTaskInitialYieldRows() == null) {
                this.initialYieldNumRows = 16384;
            } else {
                BrokerParallelMergeConfig.warnDeprecated("druid.processing.merge.task.initialYieldNumRows", "druid.processing.merge.initialYieldNumRows");
                this.initialYieldNumRows = oldConfig.getMergePoolTaskInitialYieldRows();
            }
        } else {
            this.initialYieldNumRows = initialYieldNumRows;
        }
        if (smallBatchNumRows == null) {
            if (oldConfig == null || oldConfig.getMergePoolSmallBatchRows() == null) {
                this.smallBatchNumRows = 4096;
            } else {
                BrokerParallelMergeConfig.warnDeprecated("druid.processing.merge.task.smallBatchNumRows", "druid.processing.merge.smallBatchNumRows");
                this.smallBatchNumRows = oldConfig.getMergePoolSmallBatchRows();
            }
        } else {
            this.smallBatchNumRows = smallBatchNumRows;
        }
    }

    @VisibleForTesting
    public BrokerParallelMergeConfig() {
        this(null, null, null, null, null, null, null, null);
    }

    public boolean useParallelMergePool() {
        return this.useParallelMergePool;
    }

    public int getParallelism() {
        return this.parallelism;
    }

    public long getAwaitShutdownMillis() {
        return this.awaitShutdownMillis;
    }

    public int getDefaultMaxQueryParallelism() {
        return this.defaultMaxQueryParallelism;
    }

    public int getTargetRunTimeMillis() {
        return this.targetRunTimeMillis;
    }

    public int getInitialYieldNumRows() {
        return this.initialYieldNumRows;
    }

    public int getSmallBatchNumRows() {
        return this.smallBatchNumRows;
    }

    private static void warnDeprecated(String oldPath, String newPath) {
        LOG.warn("Using deprecated config [%s] which has been replace by [%s]. This path is deprecated and will be removed in a future release, please transition to using [%s]", new Object[]{oldPath, newPath, newPath});
    }
}

