/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.segment.metadata;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.segment.SchemaPayload;
import org.apache.druid.segment.SchemaPayloadPlus;
import org.apache.druid.segment.SegmentMetadata;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.timeline.SegmentId;

@LazySingleton
public class SegmentSchemaCache {
    private static final Logger log = new Logger(SegmentSchemaCache.class);
    private final AtomicReference<CountDownLatch> initialized = new AtomicReference<CountDownLatch>(new CountDownLatch(1));
    private volatile FinalizedSegmentSchemaInfo finalizedSegmentSchemaInfo = new FinalizedSegmentSchemaInfo((ImmutableMap<SegmentId, SegmentMetadata>)ImmutableMap.of(), (ImmutableMap<String, SchemaPayload>)ImmutableMap.of());
    private final ConcurrentMap<SegmentId, SchemaPayloadPlus> realtimeSegmentSchema = new ConcurrentHashMap<SegmentId, SchemaPayloadPlus>();
    private final ConcurrentMap<SegmentId, SchemaPayloadPlus> temporaryMetadataQueryResults = new ConcurrentHashMap<SegmentId, SchemaPayloadPlus>();
    private final ConcurrentMap<SegmentId, SchemaPayloadPlus> temporaryPublishedMetadataQueryResults = new ConcurrentHashMap<SegmentId, SchemaPayloadPlus>();
    private final ServiceEmitter emitter;

    @Inject
    public SegmentSchemaCache(ServiceEmitter emitter) {
        this.emitter = emitter;
    }

    public void setInitialized() {
        if (!this.isInitialized()) {
            this.initialized.get().countDown();
            log.info("SegmentSchemaCache is initialized.", new Object[0]);
        }
    }

    public void onLeaderStop() {
        this.initialized.set(new CountDownLatch(1));
        this.finalizedSegmentSchemaInfo = new FinalizedSegmentSchemaInfo((ImmutableMap<SegmentId, SegmentMetadata>)ImmutableMap.of(), (ImmutableMap<String, SchemaPayload>)ImmutableMap.of());
        this.temporaryMetadataQueryResults.clear();
        this.temporaryPublishedMetadataQueryResults.clear();
    }

    public boolean isInitialized() {
        return this.initialized.get().getCount() == 0L;
    }

    public void awaitInitialization() throws InterruptedException {
        this.initialized.get().await();
    }

    public void updateFinalizedSegmentSchema(FinalizedSegmentSchemaInfo finalizedSegmentSchemaInfo) {
        this.finalizedSegmentSchemaInfo = finalizedSegmentSchemaInfo;
        this.temporaryPublishedMetadataQueryResults.keySet().removeAll((Collection<?>)finalizedSegmentSchemaInfo.getFinalizedSegmentMetadata().keySet());
        this.setInitialized();
    }

    public void addRealtimeSegmentSchema(SegmentId segmentId, RowSignature rowSignature, long numRows) {
        this.realtimeSegmentSchema.put(segmentId, new SchemaPayloadPlus(new SchemaPayload(rowSignature), Long.valueOf(numRows)));
    }

    public void addTemporaryMetadataQueryResult(SegmentId segmentId, RowSignature rowSignature, Map<String, AggregatorFactory> aggregatorFactories, long numRows) {
        this.temporaryMetadataQueryResults.put(segmentId, new SchemaPayloadPlus(new SchemaPayload(rowSignature, aggregatorFactories), Long.valueOf(numRows)));
    }

    public void markMetadataQueryResultPublished(SegmentId segmentId) {
        SchemaPayloadPlus temporaryMetadataQueryResult = (SchemaPayloadPlus)this.temporaryMetadataQueryResults.get(segmentId);
        if (temporaryMetadataQueryResult == null) {
            log.error("SegmentId [%s] not found in temporaryMetadataQueryResults map.", new Object[]{segmentId});
        } else {
            this.temporaryPublishedMetadataQueryResults.put(segmentId, temporaryMetadataQueryResult);
        }
        this.temporaryMetadataQueryResults.remove(segmentId);
    }

    public Optional<SchemaPayloadPlus> getSchemaForSegment(SegmentId segmentId) {
        SchemaPayload schemaPayload;
        SchemaPayloadPlus payloadPlus = (SchemaPayloadPlus)this.realtimeSegmentSchema.get(segmentId);
        if (payloadPlus != null) {
            return Optional.of(payloadPlus);
        }
        payloadPlus = (SchemaPayloadPlus)this.temporaryMetadataQueryResults.get(segmentId);
        if (payloadPlus != null) {
            return Optional.of(payloadPlus);
        }
        payloadPlus = (SchemaPayloadPlus)this.temporaryPublishedMetadataQueryResults.get(segmentId);
        if (payloadPlus != null) {
            return Optional.of(payloadPlus);
        }
        SegmentMetadata segmentMetadata = (SegmentMetadata)this.getSegmentMetadataMap().get((Object)segmentId);
        if (segmentMetadata != null && (schemaPayload = (SchemaPayload)this.getSchemaPayloadMap().get((Object)segmentMetadata.getSchemaFingerprint())) != null) {
            return Optional.of(new SchemaPayloadPlus(schemaPayload, Long.valueOf(segmentMetadata.getNumRows())));
        }
        return Optional.empty();
    }

    public boolean isSchemaCached(SegmentId segmentId) {
        return this.realtimeSegmentSchema.containsKey(segmentId) || this.temporaryMetadataQueryResults.containsKey(segmentId) || this.temporaryPublishedMetadataQueryResults.containsKey(segmentId) || this.isFinalizedSegmentSchemaCached(segmentId);
    }

    private boolean isFinalizedSegmentSchemaCached(SegmentId segmentId) {
        SegmentMetadata segmentMetadata = (SegmentMetadata)this.getSegmentMetadataMap().get((Object)segmentId);
        if (segmentMetadata != null) {
            return this.getSchemaPayloadMap().containsKey((Object)segmentMetadata.getSchemaFingerprint());
        }
        return false;
    }

    private ImmutableMap<SegmentId, SegmentMetadata> getSegmentMetadataMap() {
        return this.finalizedSegmentSchemaInfo.getFinalizedSegmentMetadata();
    }

    private ImmutableMap<String, SchemaPayload> getSchemaPayloadMap() {
        return this.finalizedSegmentSchemaInfo.getFinalizedSegmentSchema();
    }

    public boolean segmentRemoved(SegmentId segmentId) {
        this.realtimeSegmentSchema.remove(segmentId);
        this.temporaryMetadataQueryResults.remove(segmentId);
        this.temporaryPublishedMetadataQueryResults.remove(segmentId);
        return true;
    }

    public void realtimeSegmentRemoved(SegmentId segmentId) {
        this.realtimeSegmentSchema.remove(segmentId);
    }

    public void emitStats() {
        this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric("metadatacache/realtimeSegmentSchema/count", (Number)this.realtimeSegmentSchema.size()));
        this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric("metadatacache/finalizedSegmentMetadata/count", (Number)this.getSegmentMetadataMap().size()));
        this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric("metadatacache/finalizedSchemaPayload/count", (Number)this.getSchemaPayloadMap().size()));
        this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric("metadatacache/temporaryMetadataQueryResults/count", (Number)this.temporaryMetadataQueryResults.size()));
        this.emitter.emit((ServiceEventBuilder)ServiceMetricEvent.builder().setMetric("metadatacache/temporaryPublishedMetadataQueryResults/count", (Number)this.temporaryPublishedMetadataQueryResults.size()));
    }

    @VisibleForTesting
    SchemaPayloadPlus getTemporaryPublishedMetadataQueryResults(SegmentId id) {
        return (SchemaPayloadPlus)this.temporaryPublishedMetadataQueryResults.get(id);
    }

    public static class FinalizedSegmentSchemaInfo {
        private final ImmutableMap<SegmentId, SegmentMetadata> finalizedSegmentMetadata;
        private final ImmutableMap<String, SchemaPayload> finalizedSegmentSchema;

        public FinalizedSegmentSchemaInfo(ImmutableMap<SegmentId, SegmentMetadata> finalizedSegmentMetadata, ImmutableMap<String, SchemaPayload> finalizedSegmentSchema) {
            this.finalizedSegmentMetadata = finalizedSegmentMetadata;
            this.finalizedSegmentSchema = finalizedSegmentSchema;
        }

        public ImmutableMap<SegmentId, SegmentMetadata> getFinalizedSegmentMetadata() {
            return this.finalizedSegmentMetadata;
        }

        public ImmutableMap<String, SchemaPayload> getFinalizedSegmentSchema() {
            return this.finalizedSegmentSchema;
        }
    }
}

